/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.commons;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class FileUtils {
    private static final String FILE_SCHEME = "file";

    public static boolean isFileURI(URI uri) {
        return FileUtils.isEmpty(uri.getScheme()) || FILE_SCHEME.equals(uri.getScheme());
    }

    public static URI createUri(String uriString) {
        URI uri;
        block6: {
            if (FileUtils.isEmpty(uriString)) {
                return null;
            }
            try {
                if (uriString.startsWith("file:/")) {
                    String convertedUri = uriString.replace("file:///", "file:/");
                    convertedUri = convertedUri.replace("file://", "file:/");
                }
                if (uriString.indexOf(37) != -1) {
                    uriString = FileUtils.uriDecode(uriString, StandardCharsets.UTF_8);
                }
                if (FileUtils.isFileURI(uri = URI.create(uriString))) break block6;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return uri;
    }

    public static Path createPath(String uriString) {
        URI fileURi = FileUtils.createUri(uriString);
        if (fileURi == null) {
            return null;
        }
        if (fileURi.isAbsolute()) {
            return new File(fileURi).toPath();
        }
        return new File(uriString).toPath();
    }

    public static String toUri(Path path) {
        return path.toUri().toASCIIString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String uriDecode(String source, Charset charset) {
        int length = source.length();
        if (length == 0) {
            return source;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
        boolean changed = false;
        int i = 0;
        while (i < length) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 >= length) throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                char hex1 = source.charAt(i + 1);
                char hex2 = source.charAt(i + 2);
                int u = Character.digit(hex1, 16);
                int l = Character.digit(hex2, 16);
                if (u == -1 || l == -1) {
                    throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                }
                baos.write((char)((u << 4) + l));
                i += 2;
                changed = true;
            } else {
                baos.write(ch);
            }
            ++i;
        }
        return changed ? FileUtils.copyToString(baos, charset) : source;
    }

    private static String copyToString(ByteArrayOutputStream baos, Charset charset) {
        try {
            return baos.toString(charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return baos.toString();
        }
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

