/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.commons;

import com.redhat.qute.commons.JavaElementKind;
import com.redhat.qute.commons.JavaMemberInfo;
import com.redhat.qute.commons.JavaParameterInfo;
import com.redhat.qute.commons.JavaTypeInfo;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.jaxrs.JaxRsMethodKind;
import com.redhat.qute.commons.jaxrs.RestParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class JavaMethodInfo
extends JavaMemberInfo {
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private JaxRsMethodKind jaxRsMethodKind;
    private Map<String, RestParam> restParameters;
    private transient String methodName;
    private transient String returnType;
    private transient String getterName;
    private transient List<JavaParameterInfo> parameters;
    private transient JavaTypeInfo javaReturnType;

    @Override
    public String getSignature() {
        return super.getSignature();
    }

    public boolean isVirtual() {
        return false;
    }

    public JaxRsMethodKind getJaxRsMethodKind() {
        return this.jaxRsMethodKind;
    }

    public void setJaxRsMethodKind(JaxRsMethodKind jaxRsMethodKind) {
        this.jaxRsMethodKind = jaxRsMethodKind;
    }

    public void setRestParameters(Map<String, RestParam> restParameters) {
        this.restParameters = restParameters;
    }

    public Collection<RestParam> getRestParameters() {
        return this.restParameters != null ? this.restParameters.values() : Collections.emptyList();
    }

    public RestParam getRestParameter(String name) {
        return this.restParameters != null ? this.restParameters.get(name) : null;
    }

    public String getSimpleSignature() {
        StringBuilder simpleSignatureBuilder = new StringBuilder();
        simpleSignatureBuilder.append(this.getMethodName());
        simpleSignatureBuilder.append("(");
        List<JavaParameterInfo> parameters = this.getParameters();
        StringJoiner commaJoiner = new StringJoiner(", ");
        for (JavaParameterInfo parameter : parameters) {
            commaJoiner.add(parameter.getSimpleParameter());
        }
        simpleSignatureBuilder.append(commaJoiner.toString());
        simpleSignatureBuilder.append(") : ");
        simpleSignatureBuilder.append(JavaMemberInfo.getSimpleType(this.getReturnType()));
        return simpleSignatureBuilder.toString();
    }

    public String getMethodName() {
        return this.getName();
    }

    @Override
    public String getName() {
        int index;
        if (this.methodName != null) {
            return this.methodName;
        }
        String signature = this.getSignature();
        int n = index = signature != null ? signature.indexOf(40) : -1;
        if (index != -1) {
            this.methodName = signature.substring(0, index);
        }
        return this.methodName;
    }

    public String getReturnType() {
        if (this.returnType == null) {
            String signature = this.getSignature();
            int index = signature.lastIndexOf(58);
            this.returnType = index != -1 ? signature.substring(index + 1, signature.length()).trim() : "~";
        }
        return "~".equals(this.returnType) ? null : this.returnType;
    }

    public boolean isVoidMethod() {
        return "void".equals(this.getReturnType());
    }

    public JavaTypeInfo getJavaReturnType() {
        if (this.getReturnType() == null) {
            return null;
        }
        if (this.javaReturnType == null) {
            this.javaReturnType = new JavaTypeInfo();
            this.javaReturnType.setSignature(this.getReturnType());
        }
        return this.javaReturnType;
    }

    public String getGetterName() {
        if (this.getterName == null) {
            this.getterName = this.computeGetterName();
        }
        return "~".equals(this.getterName) ? null : this.getterName;
    }

    private String computeGetterName() {
        if (this.hasParameters()) {
            return "~";
        }
        String methodName = this.getName();
        if (GET_PREFIX.equals(methodName) || IS_PREFIX.equals(methodName)) {
            return "~";
        }
        int index = -1;
        if (methodName.startsWith(GET_PREFIX)) {
            index = 3;
        } else if (methodName.startsWith(IS_PREFIX)) {
            index = 2;
        }
        if (index == -1) {
            return "~";
        }
        return ("" + methodName.charAt(index)).toLowerCase() + methodName.substring(index + 1, methodName.length());
    }

    public boolean hasParameters() {
        int start;
        String signature = this.getSignature();
        int end = signature.indexOf(41, (start = signature.indexOf(40)) - 1);
        return end - start > 1;
    }

    public JavaParameterInfo getParameterAt(int index) {
        List<JavaParameterInfo> parameters = this.getParameters();
        return parameters.size() > index ? parameters.get(index) : null;
    }

    public List<JavaParameterInfo> getParameters() {
        if (this.parameters == null) {
            this.parameters = JavaMethodInfo.parseParameters(this.getSignature());
        }
        return this.parameters;
    }

    public List<JavaParameterInfo> getApplicableParameters() {
        return this.getParameters();
    }

    private static List<JavaParameterInfo> parseParameters(String signature) {
        ArrayList<JavaParameterInfo> parameters = new ArrayList<JavaParameterInfo>();
        int start = signature.indexOf(40);
        int end = signature.indexOf(41, start - 1);
        boolean paramTypeParsing = false;
        StringBuilder paramName = new StringBuilder();
        StringBuilder paramType = new StringBuilder();
        int daemon = 0;
        int i = start + 1;
        while (i < end) {
            char c = signature.charAt(i);
            if (!paramTypeParsing) {
                switch (c) {
                    case ' ': {
                        break;
                    }
                    case ':': {
                        paramTypeParsing = true;
                        break;
                    }
                    default: {
                        paramName.append(c);
                        break;
                    }
                }
            } else {
                switch (c) {
                    case ' ': {
                        break;
                    }
                    case '<': {
                        ++daemon;
                        paramType.append(c);
                        break;
                    }
                    case '>': {
                        --daemon;
                        paramType.append(c);
                        break;
                    }
                    case ',': {
                        if (daemon == 0) {
                            parameters.add(new JavaParameterInfo(paramName.toString(), paramType.toString()));
                            paramName.setLength(0);
                            paramType.setLength(0);
                            paramTypeParsing = false;
                            daemon = 0;
                            break;
                        }
                        paramType.append(c);
                        break;
                    }
                    default: {
                        paramType.append(c);
                    }
                }
            }
            ++i;
        }
        if (paramName.length() > 0) {
            parameters.add(new JavaParameterInfo(paramName.toString(), paramType.toString()));
        }
        return parameters;
    }

    @Override
    public JavaElementKind getJavaElementKind() {
        return JavaElementKind.METHOD;
    }

    @Override
    public String getJavaElementType() {
        return this.getReturnType();
    }

    @Override
    public String resolveJavaElementType(ResolvedJavaTypeInfo baseType) {
        return this.resolveReturnType(baseType, this.getJavaTypeInfo());
    }

    protected String resolveReturnType(ResolvedJavaTypeInfo baseType, JavaTypeInfo baseDeclType) {
        List<JavaParameterInfo> returnTypeParameters;
        if (this.getReturnType() == null) {
            return null;
        }
        if (baseType == null || baseDeclType == null) {
            return this.getReturnType();
        }
        JavaTypeInfo returnType = this.getJavaReturnType();
        if (!returnType.isGenericType()) {
            return returnType.getSignature();
        }
        HashMap<String, String> resolvedGenericNames = new HashMap<String, String>();
        List<JavaParameterInfo> genericsParameterType = baseDeclType.getTypeParameters();
        if (genericsParameterType.isEmpty()) {
            resolvedGenericNames.put(baseDeclType.getName(), baseType.getSignature());
            if (baseType.isArray()) {
                resolvedGenericNames.put(baseDeclType.getName().replace("[]", ""), baseType.getIterableOf());
            }
        } else {
            int i = 0;
            while (i < genericsParameterType.size()) {
                JavaParameterInfo argParameter = genericsParameterType.get(i);
                JavaParameterInfo javaParameter = baseType.getTypeParameters().get(i);
                resolvedGenericNames.put(argParameter.getType(), javaParameter.getType());
                ++i;
            }
        }
        if ((returnTypeParameters = returnType.getTypeParameters()).isEmpty()) {
            return (String)resolvedGenericNames.get(returnType.getName());
        }
        StringBuilder resolved = new StringBuilder(returnType.getName());
        resolved.append('<');
        int j = 0;
        while (j < returnTypeParameters.size()) {
            JavaParameterInfo p = returnTypeParameters.get(j);
            if (j > 0) {
                resolved.append(',');
            }
            resolved.append((String)resolvedGenericNames.get(p.getType()));
            ++j;
        }
        resolved.append('>');
        return resolved.toString();
    }

    public static JavaMethodInfo applyGenericTypeInvocation(JavaMethodInfo method, Map<String, String> genericMap) {
        JavaMethodInfo newMethod = new JavaMethodInfo();
        StringBuilder newSignature = new StringBuilder(method.getMethodName());
        newSignature.append("(");
        List<JavaParameterInfo> parameters = method.getParameters();
        int i = 0;
        while (i < parameters.size()) {
            JavaParameterInfo parameter = parameters.get(i);
            if (i > 0) {
                newSignature.append(", ");
            }
            newSignature.append(parameter.getName());
            newSignature.append(" : ");
            JavaTypeInfo.applyGenericTypeInvocation(parameter.getJavaType(), genericMap, newSignature);
            ++i;
        }
        newSignature.append(")");
        JavaTypeInfo returnType = method.getJavaReturnType();
        if (returnType != null) {
            newSignature.append(" : ");
            JavaTypeInfo.applyGenericTypeInvocation(returnType, genericMap, newSignature);
        }
        newMethod.setSignature(newSignature.toString());
        return newMethod;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("name", (Object)this.getName());
        b.add("returnType", (Object)this.getReturnType());
        b.add("signature", (Object)this.getSignature());
        return b.toString();
    }
}

