/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.commons.datamodel;

import com.redhat.qute.commons.datamodel.DataModelParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DataModelBaseTemplate<T extends DataModelParameter> {
    private String sourceType;
    private String sourceMethod;
    private List<T> parameters;
    private transient Map<String, T> parametersMap;

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceMethod() {
        return this.sourceMethod;
    }

    public void setSourceMethod(String sourceMethod) {
        this.sourceMethod = sourceMethod;
    }

    public List<T> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<T> parameters) {
        this.parameters = parameters;
    }

    public T getParameter(String key) {
        if (this.parameters == null) {
            return null;
        }
        return (T)((DataModelParameter)this.getParametersMap().get(key));
    }

    public void addParameter(T parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<T>();
        }
        this.parameters.add(parameter);
        this.getParametersMap().put(((DataModelParameter)parameter).getKey(), parameter);
    }

    private Map<String, T> getParametersMap() {
        if (this.parametersMap == null) {
            this.parametersMap = this.parameters.stream().collect(Collectors.toMap(DataModelParameter::getKey, Function.identity()));
        }
        return this.parametersMap;
    }
}

