/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.commons.datamodel;

import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.commons.datamodel.resolvers.NamespaceResolverInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class DataModelProject<T extends DataModelTemplate<?>> {
    private static final String QUTE_FILE_EXTENSION = ".qute";
    private List<T> templates;
    private Map<String, NamespaceResolverInfo> namespaceResolverInfos;
    private List<ValueResolverInfo> valueResolvers;

    public List<T> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<T> templates) {
        this.templates = templates;
    }

    public Map<String, NamespaceResolverInfo> getNamespaceResolverInfos() {
        return this.namespaceResolverInfos;
    }

    public void setNamespaceResolverInfos(Map<String, NamespaceResolverInfo> namespaceResolverInfos) {
        this.namespaceResolverInfos = namespaceResolverInfos;
    }

    public List<ValueResolverInfo> getValueResolvers() {
        return this.valueResolvers;
    }

    public void setValueResolvers(List<ValueResolverInfo> valueResolvers) {
        this.valueResolvers = valueResolvers;
    }

    public T findDataModelTemplate(String templateUri) {
        List<T> templates = this.getTemplates();
        if (templates == null || templates.isEmpty()) {
            return null;
        }
        T template = this.findDataModelTemplate(templateUri, templates);
        if (template != null) {
            return template;
        }
        String templateUriWithoutExtension = this.getUriWithoutExtension(templateUri);
        return this.findDataModelTemplate(templateUriWithoutExtension, templates);
    }

    public String getUriWithoutExtension(String templateUri) {
        int dotIndex = templateUri.lastIndexOf(46);
        if (dotIndex != -1) {
            templateUri = templateUri.substring(0, dotIndex);
        }
        if (templateUri.endsWith(QUTE_FILE_EXTENSION)) {
            templateUri = templateUri.substring(0, templateUri.length() - QUTE_FILE_EXTENSION.length());
        }
        return templateUri;
    }

    private T findDataModelTemplate(String templateUri, List<T> templates) {
        Optional<DataModelTemplate> dataModelForTemplate = templates.stream().filter(t -> templateUri.endsWith(t.getTemplateUri())).findFirst();
        if (dataModelForTemplate.isPresent()) {
            return (T)dataModelForTemplate.get();
        }
        return null;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("templates", this.getTemplates());
        b.add("valueResolvers", this.getValueResolvers());
        return b.toString();
    }
}

