/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt;

import com.redhat.qute.commons.QuteJavaCodeLensParams;
import com.redhat.qute.commons.QuteJavaDiagnosticsParams;
import com.redhat.qute.commons.QuteJavaDocumentLinkParams;
import com.redhat.qute.jdt.internal.java.QuarkusIntegrationForQute;
import com.redhat.qute.jdt.utils.IJDTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.PublishDiagnosticsParams;

public class QuteSupportForJava {
    private static final QuteSupportForJava INSTANCE = new QuteSupportForJava();

    public static QuteSupportForJava getInstance() {
        return INSTANCE;
    }

    public List<? extends CodeLens> codeLens(QuteJavaCodeLensParams params, IJDTUtils utils, IProgressMonitor monitor) {
        String uri = params.getUri();
        ITypeRoot typeRoot = QuteSupportForJava.resolveTypeRoot(uri, utils, monitor);
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return QuarkusIntegrationForQute.codeLens(typeRoot, utils, monitor);
    }

    public List<PublishDiagnosticsParams> diagnostics(QuteJavaDiagnosticsParams params, IJDTUtils utils, IProgressMonitor monitor) {
        List<String> uris = params.getUris();
        if (uris == null) {
            return Collections.emptyList();
        }
        ArrayList<PublishDiagnosticsParams> publishDiagnostics = new ArrayList<PublishDiagnosticsParams>();
        for (String uri : uris) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            PublishDiagnosticsParams publishDiagnostic = new PublishDiagnosticsParams(uri, diagnostics);
            publishDiagnostics.add(publishDiagnostic);
            ITypeRoot typeRoot = QuteSupportForJava.resolveTypeRoot(uri, utils, monitor);
            QuarkusIntegrationForQute.diagnostics(typeRoot, diagnostics, utils, monitor);
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return publishDiagnostics;
    }

    public List<DocumentLink> documentLink(QuteJavaDocumentLinkParams params, IJDTUtils utils, IProgressMonitor monitor) {
        String uri = params.getUri();
        ITypeRoot typeRoot = QuteSupportForJava.resolveTypeRoot(uri, utils, monitor);
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return QuarkusIntegrationForQute.documentLink(typeRoot, utils, monitor);
    }

    private static ITypeRoot resolveTypeRoot(String uri, IJDTUtils utils, IProgressMonitor monitor) {
        utils.waitForLifecycleJobs(monitor);
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        IClassFile classFile = null;
        if (unit == null ? (classFile = utils.resolveClassFile(uri)) == null : !unit.getResource().exists() || monitor.isCanceled()) {
            return null;
        }
        return unit != null ? unit : classFile;
    }
}

