/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;

public abstract class AbstractQuteExtensionPointRegistry<T>
implements IRegistryChangeListener {
    private static final String CLASS_ATTR = "class";
    private static final Logger LOGGER = Logger.getLogger(AbstractQuteExtensionPointRegistry.class.getName());
    private boolean extensionProvidersLoaded = false;
    private boolean registryListenerIntialized = false;
    private final List<T> providers = new ArrayList<T>();

    public abstract String getProviderExtensionId();

    public List<T> getProviders() {
        this.loadExtensionProviders();
        return this.providers;
    }

    private synchronized void loadExtensionProviders() {
        if (this.extensionProvidersLoaded) {
            return;
        }
        this.extensionProvidersLoaded = true;
        LOGGER.log(Level.INFO, "->- Loading ." + this.getProviderExtensionId() + " extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("com.redhat.qute.jdt", this.getProviderExtensionId());
        this.addExtensionProviders(cf);
        this.addRegistryListenerIfNeeded();
        LOGGER.log(Level.INFO, "-<- Done loading ." + this.getProviderExtensionId() + " extension point -<-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("com.redhat.qute.jdt", this.getProviderExtensionId());
        if (deltas != null) {
            AbstractQuteExtensionPointRegistry abstractQuteExtensionPointRegistry = this;
            synchronized (abstractQuteExtensionPointRegistry) {
                IExtensionDelta[] iExtensionDeltaArray = deltas;
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtensionDelta delta = iExtensionDeltaArray[n2];
                    IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
                    if (delta.getKind() == 1) {
                        this.addExtensionProviders(cf);
                    } else {
                        this.removeExtensionProviders(cf);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExtensionProviders(IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                T provider = this.createInstance(ce);
                List<T> list = this.providers;
                synchronized (list) {
                    this.providers.add(provider);
                }
                LOGGER.log(Level.INFO, "  Loaded " + this.getProviderExtensionId() + ": " + provider.getClass().getName());
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "  Loaded while loading " + this.getProviderExtensionId(), t);
            }
            ++n2;
        }
    }

    protected T createInstance(IConfigurationElement ce) throws CoreException {
        return (T)ce.createExecutableExtension(CLASS_ATTR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExtensionProviders(IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                T provider = this.createInstance(ce);
                List<T> list = this.providers;
                synchronized (list) {
                    this.providers.remove(provider);
                }
                LOGGER.log(Level.INFO, "  Unloaded " + this.getProviderExtensionId() + ": " + provider.getClass().getName());
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "  Unloaded while loading " + this.getProviderExtensionId(), t);
            }
            ++n2;
        }
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "com.redhat.qute.jdt");
        this.registryListenerIntialized = true;
    }

    public void destroy() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void initialize() {
    }
}

