/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.extensions.renarde;

import com.redhat.qute.commons.InvalidMethodReason;
import com.redhat.qute.commons.JavaMethodInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.commons.jaxrs.JaxRsMethodKind;
import com.redhat.qute.commons.jaxrs.JaxRsParamKind;
import com.redhat.qute.commons.jaxrs.RestParam;
import com.redhat.qute.jdt.internal.resolver.ITypeResolver;
import com.redhat.qute.jdt.internal.template.resolvedtype.AbstractResolvedJavaTypeFactory;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class RenardeResolvedJavaTypeFactory
extends AbstractResolvedJavaTypeFactory {
    private static final String JAVAX_WS_RS_POST_ANNOTATION = "javax.ws.rs.POST";
    private static final String JAKARTA_WS_RS_POST_ANNOTATION = "jakarta.ws.rs.POST";
    private static final String REST_FORM_ANNOTATION = "org.jboss.resteasy.reactive.RestForm";
    private static final String JAVAX_WS_RS_FORM_PARAM_ANNOTATION = "javax.ws.rs.FormParam";
    private static final String JAKARTA_WS_RS_FORM_PARAM_ANNOTATION = "jakarta.ws.rs.FormParam";
    private static final String JAVAX_VALIDATION_CONSTRAINTS_NOTBLANK_ANNOTATION = "javax.validation.constraints.NotBlank";
    private static final String JAKARTA_VALIDATION_CONSTRAINTS_NOTBLANK_ANNOTATION = "jakarta.validation.constraints.NotBlank";
    private static final String REST_PATH_ANNOTATION = "org.jboss.resteasy.reactive.RestPath";
    private static final String JAVAX_WS_RS_PATH_PARAM_ANNOTATION = "javax.ws.rs.PathParam";
    private static final String JAKARTA_WS_RS_PATH_PARAM_ANNOTATION = "jakarta.ws.rs.PathParam";
    private static final String REST_QUERY_ANNOTATION = "org.jboss.resteasy.reactive.RestQuery";
    private static final String JAVAX_WS_RS_QUERY_PARAM_ANNOTATION = "javax.ws.rs.QueryParam";
    private static final String JAKARTA_WS_RS_QUERY_PARAM_ANNOTATION = "jakarta.ws.rs.QueryParam";

    @Override
    public boolean isAdaptedFor(ValueResolverKind kind) {
        return kind == ValueResolverKind.Renarde;
    }

    @Override
    protected boolean isValidField(IField field, IType type) throws JavaModelException {
        return false;
    }

    @Override
    protected boolean isValidRecordField(IField field, IType type) {
        return false;
    }

    @Override
    protected InvalidMethodReason getValidMethodForQute(IMethod method, String typeName) {
        return null;
    }

    @Override
    protected JavaMethodInfo createMethod(IMethod method, ITypeResolver typeResolver) {
        JavaMethodInfo info = super.createMethod(method, typeResolver);
        RenardeResolvedJavaTypeFactory.collectJaxrsInfo(method, info);
        return info;
    }

    private static void collectJaxrsInfo(IMethod method, JavaMethodInfo info) {
        JaxRsMethodKind methodKind = JaxRsMethodKind.GET;
        if (RenardeResolvedJavaTypeFactory.isPostMethod(method)) {
            methodKind = JaxRsMethodKind.POST;
        }
        info.setJaxRsMethodKind(methodKind);
        try {
            ILocalVariable[] parameters;
            HashMap<String, RestParam> restParameters = null;
            ILocalVariable[] iLocalVariableArray = parameters = method.getParameters();
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalVariable parameter = iLocalVariableArray[n2];
                IAnnotation formAnnotation = AnnotationUtils.getAnnotation((IAnnotatable)parameter, REST_FORM_ANNOTATION, JAVAX_WS_RS_FORM_PARAM_ANNOTATION, JAKARTA_WS_RS_FORM_PARAM_ANNOTATION);
                if (formAnnotation != null) {
                    IAnnotation notBlankAnnotation;
                    if (restParameters == null) {
                        restParameters = new HashMap<String, RestParam>();
                    }
                    boolean required = (notBlankAnnotation = AnnotationUtils.getAnnotation((IAnnotatable)parameter, JAVAX_VALIDATION_CONSTRAINTS_NOTBLANK_ANNOTATION, JAKARTA_VALIDATION_CONSTRAINTS_NOTBLANK_ANNOTATION)) != null;
                    RenardeResolvedJavaTypeFactory.fillRestParam(parameter, formAnnotation, JaxRsParamKind.FORM, restParameters, required);
                } else {
                    IAnnotation pathAnnotation = AnnotationUtils.getAnnotation((IAnnotatable)parameter, REST_PATH_ANNOTATION, JAVAX_WS_RS_PATH_PARAM_ANNOTATION, JAKARTA_WS_RS_PATH_PARAM_ANNOTATION);
                    if (pathAnnotation != null) {
                        if (restParameters == null) {
                            restParameters = new HashMap();
                        }
                        RenardeResolvedJavaTypeFactory.fillRestParam(parameter, pathAnnotation, JaxRsParamKind.PATH, restParameters);
                    } else {
                        IAnnotation queryAnnotation = AnnotationUtils.getAnnotation((IAnnotatable)parameter, REST_QUERY_ANNOTATION, JAVAX_WS_RS_QUERY_PARAM_ANNOTATION, JAKARTA_WS_RS_QUERY_PARAM_ANNOTATION);
                        if (queryAnnotation != null) {
                            if (restParameters == null) {
                                restParameters = new HashMap();
                            }
                            RenardeResolvedJavaTypeFactory.fillRestParam(parameter, queryAnnotation, JaxRsParamKind.QUERY, restParameters);
                        }
                    }
                }
                ++n2;
            }
            if (restParameters != null) {
                info.setRestParameters(restParameters);
            }
        }
        catch (Exception exception) {}
    }

    private static void fillRestParam(ILocalVariable parameter, IAnnotation formAnnotation, JaxRsParamKind parameterKind, Map<String, RestParam> restParameters) throws JavaModelException {
        RenardeResolvedJavaTypeFactory.fillRestParam(parameter, formAnnotation, parameterKind, restParameters, false);
    }

    private static void fillRestParam(ILocalVariable parameter, IAnnotation formAnnotation, JaxRsParamKind parameterKind, Map<String, RestParam> restParameters, boolean required) throws JavaModelException {
        String parameterName;
        String formName = parameterName = parameter.getElementName();
        String value = AnnotationUtils.getAnnotationMemberValue(formAnnotation, "value");
        if (value != null) {
            formName = value;
        }
        restParameters.put(parameterName, new RestParam(formName, parameterKind, required));
    }

    private static boolean isPostMethod(IMethod method) {
        try {
            return AnnotationUtils.hasAnnotation((IAnnotatable)method, JAVAX_WS_RS_POST_ANNOTATION, JAKARTA_WS_RS_POST_ANNOTATION);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

