/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.java;

import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.GenerateTemplateInfo;
import com.redhat.qute.jdt.internal.java.AbstractQuteTemplateLinkCollector;
import com.redhat.qute.jdt.utils.IJDTUtils;
import com.redhat.qute.jdt.utils.JDTQuteProjectUtils;
import com.redhat.qute.jdt.utils.TemplatePathInfo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;

public class QuteJavaCodeLensCollector
extends AbstractQuteTemplateLinkCollector {
    private static final String QUTE_COMMAND_OPEN_URI_MESSAGE = "Open `{0}`";
    private static final String QUTE_COMMAND_OPEN_URI_WITH_FRAGMENT_MESSAGE = "Open `{0}` fragment of `{1}`";
    private static final String QUTE_COMMAND_GENERATE_TEMPLATE_MESSAGE = "Create `{0}`";
    private final List<CodeLens> lenses;

    public QuteJavaCodeLensCollector(ITypeRoot typeRoot, List<CodeLens> lenses, IJDTUtils utils, IProgressMonitor monitor) {
        super(typeRoot, utils, monitor);
        this.lenses = lenses;
    }

    @Override
    protected void collectTemplateLink(String basePath, ASTNode fieldOrMethod, ASTNode locationAnnotation, AbstractTypeDeclaration type, String className, String fieldOrMethodName, String location, IFile templateFile, TemplatePathInfo templatePathInfo) throws JavaModelException {
        if (!templatePathInfo.isValid()) {
            return;
        }
        Command command = null;
        String templateUri = templatePathInfo.getTemplateUri();
        String fragmentId = templatePathInfo.getFragmentId();
        if (templateFile.exists()) {
            String title = templatePathInfo.hasFragment() ? MessageFormat.format(QUTE_COMMAND_OPEN_URI_WITH_FRAGMENT_MESSAGE, fragmentId, templateUri) : MessageFormat.format(QUTE_COMMAND_OPEN_URI_MESSAGE, templateUri);
            command = new Command(title, "qute.command.open.uri", Arrays.asList(templateFile.getLocationURI().toString(), fragmentId));
        } else {
            List<DataModelParameter> parameters = QuteJavaCodeLensCollector.createParameters(fieldOrMethod);
            GenerateTemplateInfo info = new GenerateTemplateInfo();
            info.setParameters(parameters);
            info.setProjectUri(JDTQuteProjectUtils.getProjectUri(this.typeRoot.getJavaProject()));
            info.setTemplateFileUri(templateFile.getLocationURI().toString());
            info.setTemplateFilePath(templateUri);
            command = new Command(MessageFormat.format(QUTE_COMMAND_GENERATE_TEMPLATE_MESSAGE, templateUri), "qute.command.generate.template.file", Arrays.asList(info));
        }
        Range range = this.utils.toRange((IOpenable)this.typeRoot, fieldOrMethod.getStartPosition(), fieldOrMethod.getLength());
        CodeLens codeLens = new CodeLens(range, command, null);
        this.lenses.add(codeLens);
    }

    private static List<DataModelParameter> createParameters(ASTNode node) {
        if (node.getNodeType() == 31) {
            return QuteJavaCodeLensCollector.createParameter((MethodDeclaration)node);
        }
        return Collections.emptyList();
    }

    private static List<DataModelParameter> createParameter(MethodDeclaration method) {
        ArrayList<DataModelParameter> parameters = new ArrayList<DataModelParameter>();
        List methodParameters = method.parameters();
        for (Object methodParameter : methodParameters) {
            SingleVariableDeclaration variable = (SingleVariableDeclaration)methodParameter;
            String parameterName = variable.getName().getFullyQualifiedName();
            Type parameterType = variable.getType();
            ITypeBinding binding = parameterType.resolveBinding();
            if (binding == null) continue;
            DataModelParameter parameter = new DataModelParameter();
            parameter.setKey(parameterName);
            parameter.setSourceType(binding.getQualifiedName());
            parameters.add(parameter);
        }
        return parameters;
    }
}

