/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.java;

import com.redhat.qute.jdt.internal.java.AbstractQuteTemplateLinkCollector;
import com.redhat.qute.jdt.utils.IJDTUtils;
import com.redhat.qute.jdt.utils.TemplatePathInfo;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.Range;

public class QuteJavaDocumentLinkCollector
extends AbstractQuteTemplateLinkCollector {
    private static final String QUTE_DOCUMENT_LINK_OPEN_URI_MESSAGE = "Open `{0}`";
    private static final String QUTE_DOCUMENT_LINK_GENERATE_TEMPLATE_MESSAGE = "Create `{0}`";
    private final List<DocumentLink> links;

    public QuteJavaDocumentLinkCollector(ITypeRoot typeRoot, List<DocumentLink> links, IJDTUtils utils, IProgressMonitor monitor) {
        super(typeRoot, utils, monitor);
        this.links = links;
    }

    @Override
    protected void collectTemplateLink(String basePath, ASTNode fieldOrMethod, ASTNode locationAnnotation, AbstractTypeDeclaration type, String className, String fieldOrMethodName, String location, IFile templateFile, TemplatePathInfo templatePathInfo) throws JavaModelException {
        if (!templatePathInfo.isValid()) {
            return;
        }
        String templateUri = templateFile.getLocationURI().toString();
        String tooltip = QuteJavaDocumentLinkCollector.getTooltip(templateFile, templatePathInfo.getTemplateUri());
        Range range = this.createRange(locationAnnotation != null ? locationAnnotation : fieldOrMethod);
        DocumentLink link = new DocumentLink(range, templateUri, null, tooltip);
        this.links.add(link);
    }

    private static String getTooltip(IFile templateFile, String templateFilePath) {
        if (templateFile.exists()) {
            return MessageFormat.format(QUTE_DOCUMENT_LINK_OPEN_URI_MESSAGE, templateFilePath);
        }
        return MessageFormat.format(QUTE_DOCUMENT_LINK_GENERATE_TEMPLATE_MESSAGE, templateFilePath);
    }
}

