/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.ls;

import com.redhat.qute.jdt.IJavaDataModelChangedListener;
import com.redhat.qute.jdt.internal.JavaDataModelListenerManager;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public abstract class AbstractQuteDelegateCommandHandler
implements IDelegateCommandHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractQuteDelegateCommandHandler.class.getName());
    private static final String DATA_MODEL_CHANGED_COMMAND = "qute/dataModelChanged";
    private static final IJavaDataModelChangedListener LISTENER = event -> {
        try {
            JavaLanguageServerPlugin.getInstance().getClientConnection().executeClientCommand(Duration.of(5L, ChronoUnit.SECONDS), DATA_MODEL_CHANGED_COMMAND, new Object[]{event});
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while sending 'qute/dataModelChanged' event to the client", e);
        }
    };
    private static boolean initialized;

    public AbstractQuteDelegateCommandHandler() {
        AbstractQuteDelegateCommandHandler.initialize();
    }

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        JavaDataModelListenerManager.getInstance().addJavaDataModelChangedListener(LISTENER);
        initialized = true;
    }
}

