/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.ls;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;

public class ArgumentUtils {
    public static Map<String, Object> getFirst(List<Object> arguments) {
        return arguments.isEmpty() ? null : (Map)arguments.get(0);
    }

    public static String getString(Map<String, Object> obj, String key) {
        return (String)obj.get(key);
    }

    public static List<String> getStringList(Map<String, Object> obj, String key) {
        return (List)obj.get(key);
    }

    public static boolean getBoolean(Map<String, Object> obj, String key) {
        Object result = obj.get(key);
        return result != null && result instanceof Boolean && (Boolean)result != false;
    }

    public static int getInt(Map<String, Object> obj, String key) {
        Object result = obj.get(key);
        return result != null && result instanceof Number ? ((Number)result).intValue() : 0;
    }

    public static TextDocumentIdentifier getTextDocumentIdentifier(Map<String, Object> obj, String key) {
        Map textDocumentIdentifierObj = (Map)obj.get(key);
        if (textDocumentIdentifierObj == null) {
            return null;
        }
        String uri = ArgumentUtils.getString(textDocumentIdentifierObj, "uri");
        return new TextDocumentIdentifier(uri);
    }

    public static Position getPosition(Map<String, Object> obj, String key) {
        Map positionObj = (Map)obj.get(key);
        if (positionObj == null) {
            return null;
        }
        int line = ArgumentUtils.getInt(positionObj, "line");
        int character = ArgumentUtils.getInt(positionObj, "character");
        return new Position(line, character);
    }

    public static Range getRange(Map<String, Object> obj, String key) {
        Map rangeObj = (Map)obj.get(key);
        if (rangeObj == null) {
            return null;
        }
        Position start = ArgumentUtils.getPosition(rangeObj, "start");
        Position end = ArgumentUtils.getPosition(rangeObj, "end");
        return new Range(start, end);
    }

    public static CodeActionContext getCodeActionContext(Map<String, Object> obj, String key) {
        Map contextObj = (Map)obj.get(key);
        if (contextObj == null) {
            return null;
        }
        List diagnosticsObj = (List)contextObj.get("diagnostics");
        List diagnostics = diagnosticsObj.stream().map(diagnosticObj -> {
            Diagnostic diagnostic = new Diagnostic();
            diagnostic.setRange(ArgumentUtils.getRange(diagnosticObj, "range"));
            diagnostic.setCode(ArgumentUtils.getString(diagnosticObj, "code"));
            diagnostic.setMessage(ArgumentUtils.getString(diagnosticObj, "message"));
            diagnostic.setSource(ArgumentUtils.getString(diagnosticObj, "source"));
            return diagnostic;
        }).collect(Collectors.toList());
        List only = null;
        return new CodeActionContext(diagnostics, only);
    }

    public static Map<String, Object> getObject(Map<String, Object> obj, String key) {
        Object child = obj.get(key);
        if (child != null && child instanceof Map) {
            return (Map)child;
        }
        return null;
    }
}

