/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.resolver;

import com.redhat.qute.jdt.internal.resolver.ITypeResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public abstract class AbstractTypeResolver
implements ITypeResolver {
    private static final Logger LOGGER = Logger.getLogger(AbstractTypeResolver.class.getName());
    protected final IType primaryType;

    public AbstractTypeResolver(IType primaryType) {
        this.primaryType = primaryType;
    }

    public static String resolveJavaTypeSignature(IType type) {
        StringBuilder typeName = new StringBuilder(type.getFullyQualifiedName());
        try {
            ITypeParameter[] parameters = type.getTypeParameters();
            if (parameters.length > 0) {
                typeName.append("<");
                int i = 0;
                while (i < parameters.length) {
                    if (i > 0) {
                        typeName.append(",");
                    }
                    typeName.append(parameters[i].getElementName());
                    ++i;
                }
                typeName.append(">");
            }
            return typeName.toString();
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while collecting Java Types for Java type '" + String.valueOf(typeName) + "'.", e);
            return typeName.toString();
        }
    }

    @Override
    public List<String> resolveExtendedType() {
        ArrayList<String> extendedTypes = new ArrayList<String>();
        try {
            String[] superInterfaceTypeSignature;
            String superTypeSignature = this.primaryType.getSuperclassTypeSignature();
            if (superTypeSignature != null) {
                extendedTypes.add(this.resolveTypeSignature(superTypeSignature, this.primaryType));
            }
            if ((superInterfaceTypeSignature = this.primaryType.getSuperInterfaceTypeSignatures()) != null) {
                String[] stringArray = superInterfaceTypeSignature;
                int n = superInterfaceTypeSignature.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    extendedTypes.add(this.resolveTypeSignature(string, this.primaryType));
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while resolving super class Java Types for Java type '" + this.primaryType.getFullyQualifiedName('.') + "'.", e);
        }
        return extendedTypes;
    }

    @Override
    public String resolveFieldSignature(IField field) {
        StringBuilder signature = new StringBuilder(field.getElementName());
        signature.append(" : ");
        try {
            signature.append(this.resolveTypeSignature(field.getTypeSignature(), false, field.getDeclaringType()));
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while resolving field type '" + field.getElementName() + "'", e);
        }
        return signature.toString();
    }

    @Override
    public String resolveMethodSignature(IMethod method) {
        StringBuilder signature = new StringBuilder(method.getElementName());
        signature.append('(');
        try {
            ILocalVariable[] parameters = method.getParameters();
            if (parameters.length > 0) {
                boolean varargs = Flags.isVarargs((int)method.getFlags());
                int i = 0;
                while (i < parameters.length) {
                    if (i > 0) {
                        signature.append(", ");
                    }
                    ILocalVariable parameter = parameters[i];
                    signature.append(parameter.getElementName());
                    signature.append(" : ");
                    signature.append(this.resolveLocalVariableSignature(parameter, varargs && i == parameters.length - 1));
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while resolving method parameters type of '" + method.getElementName() + "'", e);
        }
        signature.append(')');
        try {
            String returnType = this.resolveTypeSignature(method.getReturnType(), false, method.getDeclaringType());
            signature.append(" : ");
            signature.append(returnType);
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while resolving method return type of '" + method.getElementName() + "'", e);
        }
        return signature.toString();
    }

    @Override
    public String resolveLocalVariableSignature(ILocalVariable parameter, boolean varargs) {
        return this.resolveTypeSignature(parameter.getTypeSignature(), varargs, parameter.getDeclaringMember().getDeclaringType());
    }

    @Override
    public String resolveTypeSignature(String typeSignature, IType declaringType) {
        return this.resolveTypeSignature(typeSignature, false, declaringType);
    }

    private String resolveTypeSignature(String typeSignature, boolean varargs, IType declaringType) {
        if (typeSignature.charAt(0) == '[') {
            return this.doResolveTypeSignature(typeSignature.substring(1, typeSignature.length()), declaringType) + (varargs ? "..." : "[]");
        }
        return this.doResolveTypeSignature(typeSignature, declaringType);
    }

    private String doResolveTypeSignature(String typeSignature, IType declaringType) {
        char type = typeSignature.charAt(0);
        switch (type) {
            case 'T': {
                boolean endsWithColon = typeSignature.charAt(typeSignature.length() - 1) == ';';
                return this.resolveSimpleType(typeSignature.substring(1, typeSignature.length() - (endsWithColon ? 1 : 0)));
            }
            case 'L': {
                if (typeSignature.indexOf(36) != -1) {
                    return this.doResolveTypeSignatureWithoutJDT(typeSignature, declaringType);
                }
                return Signature.toString((String)typeSignature);
            }
            case 'Q': {
                return this.doResolveTypeSignatureWithoutJDT(typeSignature, declaringType);
            }
        }
        return Signature.toString((String)typeSignature);
    }

    public String doResolveTypeSignatureWithoutJDT(String typeSignature, IType declaringType) {
        boolean hasGeneric;
        int startGeneric = typeSignature.indexOf(60);
        boolean bl = hasGeneric = startGeneric != -1;
        if (!hasGeneric) {
            boolean endsWithColon = typeSignature.charAt(typeSignature.length() - 1) == ';';
            String simpleType = typeSignature.substring(1, typeSignature.length() - (endsWithColon ? 1 : 0));
            String resolved = this.resolveSimpleType(simpleType);
            if (resolved.equals(simpleType) && declaringType != null) {
                try {
                    if (declaringType.isEnum()) {
                        return AbstractTypeResolver.resolveJavaTypeSignature(declaringType);
                    }
                }
                catch (JavaModelException javaModelException) {}
                IType type = declaringType.getType(simpleType);
                while (type != null && type.exists()) {
                    resolved = AbstractTypeResolver.resolveJavaTypeSignature(type);
                    if (!resolved.equals(simpleType)) {
                        return resolved;
                    }
                    type = type.getDeclaringType();
                }
            }
            return resolved;
        }
        int endGeneric = typeSignature.lastIndexOf(62);
        String typeErasure = typeSignature.substring(0, startGeneric);
        StringBuilder result = new StringBuilder();
        result.append(this.doResolveTypeSignature(typeErasure + ";", declaringType));
        result.append('<');
        int bracket = 0;
        int start = startGeneric + 1;
        int nbTypeParams = 0;
        int i = start;
        while (i < endGeneric) {
            char c = typeSignature.charAt(i);
            switch (c) {
                case '<': {
                    ++bracket;
                    break;
                }
                case '>': {
                    --bracket;
                    break;
                }
                case ';': {
                    if (bracket != 0) break;
                    if (nbTypeParams > 0) {
                        result.append(",");
                    }
                    String s = typeSignature.substring(start, i);
                    result.append(this.doResolveTypeSignature(s + ";", declaringType));
                    ++nbTypeParams;
                    start = i + 1;
                }
            }
            ++i;
        }
        result.append('>');
        return result.toString();
    }

    protected abstract String resolveSimpleType(String var1);
}

