/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template;

import com.redhat.qute.commons.GenerateMissingJavaMemberParams;
import com.redhat.qute.jdt.utils.IJDTUtils;
import com.redhat.qute.jdt.utils.TextEditConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.BodyDeclarationRewrite;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.text.edits.TextEdit;

public class TemplateGenerateMissingJavaMember {
    private static final Logger LOGGER = Logger.getLogger(TemplateGenerateMissingJavaMember.class.getName());
    private static final Pattern BROKEN_FILE_PROTOCOL = Pattern.compile("file:/(?!//)");
    private static final Range PREPEND_RANGE = new Range(new Position(0, 0), new Position(0, 0));

    private TemplateGenerateMissingJavaMember() {
    }

    public static WorkspaceEdit handleGenerateMissingJavaMember(GenerateMissingJavaMemberParams params, IJDTUtils utils, IProgressMonitor monitor) {
        switch (params.getMemberType()) {
            case Field: {
                return TemplateGenerateMissingJavaMember.handleMissingField(params, utils, monitor);
            }
            case Getter: {
                return TemplateGenerateMissingJavaMember.handleCreateMissingGetterCodeAction(params, utils, monitor);
            }
            case AppendTemplateExtension: {
                return TemplateGenerateMissingJavaMember.handleCreateMissingTemplateExtension(params, utils, monitor);
            }
            case CreateTemplateExtension: {
                return TemplateGenerateMissingJavaMember.createNewTemplateExtensionsFile(params, utils, monitor);
            }
        }
        return null;
    }

    private static WorkspaceEdit handleMissingField(GenerateMissingJavaMemberParams params, IJDTUtils utils, IProgressMonitor monitor) {
        IType javaType;
        IJavaProject project = TemplateGenerateMissingJavaMember.getJavaProjectFromProjectUri(params.getProjectUri());
        try {
            javaType = project.findType(params.getJavaType());
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        IField currentlyField = javaType.getField(params.getMissingProperty());
        if (currentlyField != null && currentlyField.exists()) {
            return TemplateGenerateMissingJavaMember.handleUpdatePermissionsOfExistingField(params, utils, project, javaType, monitor);
        }
        return TemplateGenerateMissingJavaMember.handleCreateMissingField(params, utils, project, javaType, monitor);
    }

    private static WorkspaceEdit handleCreateMissingField(GenerateMissingJavaMemberParams params, IJDTUtils utils, IJavaProject project, IType javaType, IProgressMonitor monitor) {
        TextEdit jdtTextEdit;
        CompilationUnit cu = TemplateGenerateMissingJavaMember.createQuickFixAST(javaType);
        if (cu == null) {
            return null;
        }
        ASTNode typeNode = cu.findDeclaringNode("L" + params.getJavaType().replace('.', '/') + ";");
        if (typeNode == null) {
            return null;
        }
        AST ast = typeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName(params.getMissingProperty()));
        Modifier modifier = ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        FieldDeclaration decl = ast.newFieldDeclaration(fragment);
        decl.setType((Type)ast.newSimpleType((Name)ast.newSimpleName("String")));
        decl.modifiers().add(modifier);
        TemplateGenerateMissingJavaMember.insertDeclaration((BodyDeclaration)decl, rewrite, typeNode);
        try {
            jdtTextEdit = rewrite.rewriteAST();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        TextDocumentEdit textDocumentEdit = new TextEditConverter((ICompilationUnit)javaType.getTypeRoot(), jdtTextEdit, utils).convertToTextDocumentEdit(0);
        return new WorkspaceEdit(Arrays.asList(Either.forLeft((Object)textDocumentEdit)));
    }

    private static WorkspaceEdit handleUpdatePermissionsOfExistingField(GenerateMissingJavaMemberParams params, IJDTUtils utils, IJavaProject project, IType javaType, IProgressMonitor monitor) {
        TextEdit jdtTextEdit;
        CompilationUnit cu = TemplateGenerateMissingJavaMember.createQuickFixAST(javaType);
        if (cu == null) {
            return null;
        }
        ASTNode typeNode = cu.findDeclaringNode("L" + params.getJavaType().replace('.', '/') + ";");
        if (typeNode == null) {
            return null;
        }
        AST ast = typeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        FieldDeclFinder fieldDeclFinder = new FieldDeclFinder(params.getMissingProperty());
        typeNode.accept((ASTVisitor)fieldDeclFinder);
        if (fieldDeclFinder.getFieldDeclaration() == null) {
            return null;
        }
        FieldDeclaration oldFieldDeclaration = fieldDeclFinder.getFieldDeclaration();
        boolean alreadyPublic = oldFieldDeclaration.modifiers().stream().anyMatch(mod -> {
            if (!(mod instanceof Modifier)) {
                return false;
            }
            Modifier asMod = (Modifier)mod;
            return asMod.getKeyword() == Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        });
        if (alreadyPublic) {
            return null;
        }
        if (fieldDeclFinder.hasMultiDecl()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)rewrite.createMoveTarget((ASTNode)fieldDeclFinder.getOldBadFragment());
            rewrite.remove((ASTNode)fieldDeclFinder.getOldBadFragment(), null);
            Modifier modifier = ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
            FieldDeclaration decl = ast.newFieldDeclaration(fragment);
            decl.setType(TemplateGenerateMissingJavaMember.getCloneOfType(oldFieldDeclaration, ast, rewrite));
            decl.modifiers().add(modifier);
            TemplateGenerateMissingJavaMember.insertDeclaration((BodyDeclaration)decl, rewrite, typeNode);
        } else {
            Modifier oldModifier = null;
            for (Object modifierUncast : oldFieldDeclaration.modifiers()) {
                Modifier modifier;
                if (!(modifierUncast instanceof Modifier) || !(modifier = (Modifier)modifierUncast).isPrivate() && !modifier.isProtected()) continue;
                oldModifier = modifier;
                break;
            }
            Modifier newModifier = ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
            rewrite.replace(oldModifier, (ASTNode)newModifier, null);
        }
        try {
            jdtTextEdit = rewrite.rewriteAST();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        TextDocumentEdit textDocumentEdit = new TextEditConverter((ICompilationUnit)javaType.getTypeRoot(), jdtTextEdit, utils).convertToTextDocumentEdit(0);
        return new WorkspaceEdit(Arrays.asList(Either.forLeft((Object)textDocumentEdit)));
    }

    private static WorkspaceEdit handleCreateMissingGetterCodeAction(GenerateMissingJavaMemberParams params, IJDTUtils utils, IProgressMonitor monitor) {
        TextEdit jdtTextEdit;
        IType javaType;
        IJavaProject project = TemplateGenerateMissingJavaMember.getJavaProjectFromProjectUri(params.getProjectUri());
        try {
            javaType = project.findType(params.getJavaType());
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        CompilationUnit cu = TemplateGenerateMissingJavaMember.createQuickFixAST(javaType);
        if (cu == null) {
            return null;
        }
        ASTNode typeNode = cu.findDeclaringNode("L" + params.getJavaType().replace('.', '/') + ";");
        if (typeNode == null) {
            return null;
        }
        AST ast = typeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        String methodName = "get" + TemplateGenerateMissingJavaMember.getCapitalized(params.getMissingProperty());
        methodDeclaration.setName(ast.newSimpleName(methodName));
        methodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        Block block = ast.newBlock();
        ReturnStatement returnStatement = ast.newReturnStatement();
        IField field = javaType.getField(params.getMissingProperty());
        if (field != null && field.exists()) {
            FieldDeclFinder declFinder = new FieldDeclFinder(params.getMissingProperty());
            typeNode.accept((ASTVisitor)declFinder);
            FieldDeclaration fieldDeclaration = declFinder.getFieldDeclaration();
            FieldAccess fieldAccess = ast.newFieldAccess();
            fieldAccess.setName(ast.newSimpleName(params.getMissingProperty()));
            fieldAccess.setExpression((Expression)ast.newThisExpression());
            returnStatement.setExpression((Expression)fieldAccess);
            methodDeclaration.setReturnType2(TemplateGenerateMissingJavaMember.getCloneOfType(fieldDeclaration, ast, rewrite));
        } else {
            NullLiteral expression = ast.newNullLiteral();
            returnStatement.setExpression((Expression)expression);
            methodDeclaration.setReturnType2((Type)ast.newSimpleType((Name)ast.newSimpleName("String")));
        }
        block.statements().add(returnStatement);
        methodDeclaration.setBody(block);
        TemplateGenerateMissingJavaMember.insertDeclaration((BodyDeclaration)methodDeclaration, rewrite, typeNode);
        try {
            jdtTextEdit = rewrite.rewriteAST();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        TextDocumentEdit textDocumentEdit = new TextEditConverter((ICompilationUnit)javaType.getTypeRoot(), jdtTextEdit, utils).convertToTextDocumentEdit(0);
        return new WorkspaceEdit(Arrays.asList(Either.forLeft((Object)textDocumentEdit)));
    }

    private static WorkspaceEdit handleCreateMissingTemplateExtension(GenerateMissingJavaMemberParams params, IJDTUtils utils, IProgressMonitor monitor) {
        IJavaProject project = TemplateGenerateMissingJavaMember.getJavaProjectFromProjectUri(params.getProjectUri());
        IType type = null;
        try {
            type = project.findType(params.getTemplateClass());
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, String.format("JavaModelException while trying to locate template extension class {0}", params.getTemplateClass()), e);
        }
        if (type == null) {
            return null;
        }
        return TemplateGenerateMissingJavaMember.addTemplateExtensionToFile(params, utils, project, type, monitor);
    }

    private static WorkspaceEdit createNewTemplateExtensionsFile(GenerateMissingJavaMemberParams params, IJDTUtils utils, IProgressMonitor monitor) {
        IJavaProject project = TemplateGenerateMissingJavaMember.getJavaProjectFromProjectUri(params.getProjectUri());
        return TemplateGenerateMissingJavaMember.createNewTemplateExtensionFile(params, utils, project, monitor);
    }

    private static WorkspaceEdit addTemplateExtensionToFile(GenerateMissingJavaMemberParams params, IJDTUtils utils, IJavaProject project, IType templateExtensionType, IProgressMonitor monitor) {
        TextEdit jdtTextEdit;
        CompilationUnit cu = TemplateGenerateMissingJavaMember.createQuickFixAST(templateExtensionType);
        ASTNode typeNode = cu.findDeclaringNode(templateExtensionType.getKey());
        if (typeNode == null) {
            return null;
        }
        AST ast = typeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        String methodName = params.getMissingProperty();
        methodDeclaration.setName(ast.newSimpleName(methodName));
        methodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        methodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        SingleVariableDeclaration singleVariableDeclaration = ast.newSingleVariableDeclaration();
        singleVariableDeclaration.setType((Type)ast.newSimpleType(ast.newName(params.getJavaType())));
        singleVariableDeclaration.setName(ast.newSimpleName(TemplateGenerateMissingJavaMember.getParamNameFromFullyQualifiedType(params.getJavaType())));
        methodDeclaration.parameters().add(singleVariableDeclaration);
        Block block = ast.newBlock();
        ReturnStatement returnStatement = ast.newReturnStatement();
        NullLiteral expression = ast.newNullLiteral();
        returnStatement.setExpression((Expression)expression);
        methodDeclaration.setReturnType2((Type)ast.newSimpleType((Name)ast.newSimpleName("String")));
        block.statements().add(returnStatement);
        methodDeclaration.setBody(block);
        TemplateGenerateMissingJavaMember.insertDeclaration((BodyDeclaration)methodDeclaration, rewrite, typeNode);
        try {
            jdtTextEdit = rewrite.rewriteAST();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        TextDocumentEdit textDocumentEdit = new TextEditConverter((ICompilationUnit)templateExtensionType.getTypeRoot(), jdtTextEdit, utils).convertToTextDocumentEdit(0);
        return new WorkspaceEdit(Arrays.asList(Either.forLeft((Object)textDocumentEdit)));
    }

    private static WorkspaceEdit createNewTemplateExtensionFile(GenerateMissingJavaMemberParams params, IJDTUtils utils, IJavaProject project, IProgressMonitor monitor) {
        TextDocumentEdit addContentEdit;
        IPackageFragment destPackage = null;
        try {
            IPath targetFolder = project.getOutputLocation().removeLastSegments(1);
            List<IClasspathEntry> sourceClassPathEntries = Stream.of(project.getRawClasspath()).filter(cpe -> {
                cpe.getExtraAttributes();
                return cpe.getEntryKind() == 3 && !cpe.isTest() && !targetFolder.isPrefixOf(cpe.getPath());
            }).toList();
            if (sourceClassPathEntries.isEmpty()) {
                throw new UnsupportedOperationException("Cannot locate source code folder");
            }
            Optional<IPackageFragmentRoot> sourceFragmentRootOptional = Stream.of(project.getPackageFragmentRoots()).filter(pfr -> {
                block3: {
                    try {
                        if (pfr.getKind() != 2 && pfr.getResource() != null) break block3;
                        return false;
                    }
                    catch (JavaModelException javaModelException) {
                        return false;
                    }
                }
                return Stream.of(pfr.getChildren()).anyMatch(child -> child.getElementType() == 4);
            }).filter(pfr -> {
                for (IClasspathEntry cpe : sourceClassPathEntries) {
                    if (!cpe.getPath().equals((Object)pfr.getResource().getFullPath())) continue;
                    return true;
                }
                return false;
            }).findFirst();
            if (sourceFragmentRootOptional.isEmpty()) {
                throw new UnsupportedOperationException("Cannot locate source code folder");
            }
            IPackageFragmentRoot fragmentRoot = sourceFragmentRootOptional.get();
            destPackage = fragmentRoot.getPackageFragment("");
        }
        catch (JavaModelException javaModelException) {}
        if (destPackage == null) {
            return null;
        }
        String baseName = "TemplateExtensions";
        Object name = baseName;
        ICompilationUnit cu = destPackage.getCompilationUnit(baseName + ".java");
        int i = 0;
        while (cu.exists()) {
            name = baseName + ++i;
            cu = destPackage.getCompilationUnit((String)name + ".java");
        }
        CreateFile createFileOperation = new CreateFile(TemplateGenerateMissingJavaMember.fixBrokenUri(cu.getResource().getRawLocationURI().toString()));
        try {
            addContentEdit = TemplateGenerateMissingJavaMember.createNewTemplateExtensionsContent(cu, (String)name, params.getMissingProperty(), params.getJavaType(), TemplateGenerateMissingJavaMember.fixBrokenUri(cu.getResource().getRawLocationURI().toString()));
        }
        catch (CoreException e) {
            throw new RuntimeException("Failure while constructing new Java file content", e);
        }
        WorkspaceEdit makeTemplateExtensions = new WorkspaceEdit();
        makeTemplateExtensions.setDocumentChanges(Arrays.asList(Either.forRight((Object)createFileOperation), Either.forLeft((Object)addContentEdit)));
        return makeTemplateExtensions;
    }

    private static TextDocumentEdit createNewTemplateExtensionsContent(ICompilationUnit cu, String typeName, String methodName, String methodParamFullyQualifiedType, String uri) throws CoreException {
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)cu.getJavaProject());
        String typeStub = TemplateGenerateMissingJavaMember.constructTypeStub(cu, typeName, 1, methodName, methodParamFullyQualifiedType, lineDelimiter);
        String cuContent = TemplateGenerateMissingJavaMember.constructCUContent(cu, typeStub, lineDelimiter);
        TextDocumentEdit tde = new TextDocumentEdit();
        tde.setTextDocument(new VersionedTextDocumentIdentifier(uri, Integer.valueOf(0)));
        tde.setEdits(Arrays.asList(new org.eclipse.lsp4j.TextEdit(PREPEND_RANGE, cuContent)));
        return tde;
    }

    private static String constructTypeStub(ICompilationUnit parentCU, String name, int modifiers, String methodName, String methodParamFullyQualifiedType, String lineDelimiter) {
        StringBuilder buf = new StringBuilder();
        buf.append("@");
        buf.append("io.quarkus.qute.TemplateExtension");
        buf.append(lineDelimiter);
        buf.append(Flags.toString((int)modifiers));
        if (modifiers != 0) {
            buf.append(' ');
        }
        buf.append("class ");
        buf.append(name);
        buf.append(" {").append(lineDelimiter);
        buf.append(TemplateGenerateMissingJavaMember.constructMethodStub(parentCU, methodName, methodParamFullyQualifiedType, lineDelimiter));
        buf.append('}').append(lineDelimiter);
        return buf.toString();
    }

    private static String constructMethodStub(ICompilationUnit compilationUnit, String methodName, String methodParamFullyQualifiedType, String lineDelimiter) {
        StringBuilder buf = new StringBuilder("\tpublic static String ");
        buf.append(methodName).append("(").append(methodParamFullyQualifiedType);
        buf.append(" ");
        buf.append(TemplateGenerateMissingJavaMember.getParamNameFromFullyQualifiedType(methodParamFullyQualifiedType));
        buf.append(") {").append(lineDelimiter);
        buf.append("\t\treturn null;").append(lineDelimiter);
        buf.append("\t}").append(lineDelimiter);
        return buf.toString();
    }

    private static String constructCUContent(ICompilationUnit cu, String typeContent, String lineDelimiter) throws CoreException {
        String fileComment = CodeGeneration.getFileComment((ICompilationUnit)cu, (String)lineDelimiter);
        String typeComment = CodeGeneration.getTypeComment((ICompilationUnit)cu, (String)JavaCore.removeJavaLikeExtension((String)cu.getElementName()), (String)lineDelimiter);
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String content = CodeGeneration.getCompilationUnitContent((ICompilationUnit)cu, (String)fileComment, (String)typeComment, (String)typeContent, (String)lineDelimiter);
        if (content != null) {
            ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
            parser.setProject(cu.getJavaProject());
            parser.setSource(content.toCharArray());
            CompilationUnit unit = (CompilationUnit)parser.createAST(null);
            if ((pack.isDefaultPackage() || unit.getPackage() != null) && !unit.types().isEmpty()) {
                return content;
            }
        }
        StringBuilder buf = new StringBuilder();
        if (!pack.isDefaultPackage()) {
            buf.append("package ").append(pack.getElementName()).append(';');
        }
        buf.append(lineDelimiter).append(lineDelimiter);
        buf.append(typeContent);
        return buf.toString();
    }

    private static CompilationUnit createQuickFixAST(IType javaType) {
        if (javaType.isBinary()) {
            return null;
        }
        return ASTResolving.createQuickFixAST((ICompilationUnit)javaType.getCompilationUnit(), null);
    }

    private static IJavaProject getJavaProjectFromProjectUri(String projectName) {
        if (projectName == null) {
            return null;
        }
        JavaProject javaProject = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectName);
        return javaProject.exists() ? javaProject : null;
    }

    private static String getCapitalized(String camelCaseName) {
        return camelCaseName.substring(0, 1).toUpperCase() + camelCaseName.substring(1);
    }

    private static Type getCloneOfType(FieldDeclaration toClone, AST ast, ASTRewrite rewrite) {
        return (Type)rewrite.createCopyTarget((ASTNode)toClone.getType());
    }

    private static String getParamNameFromFullyQualifiedType(String fullyQualifiedType) {
        int lastDot = fullyQualifiedType.lastIndexOf(".");
        return fullyQualifiedType.substring(lastDot + 1, lastDot + 2).toLowerCase() + fullyQualifiedType.substring(lastDot + 2);
    }

    private static String fixBrokenUri(String uri) {
        Matcher m = BROKEN_FILE_PROTOCOL.matcher(uri);
        return m.replaceFirst("file:///");
    }

    private static void insertDeclaration(BodyDeclaration decl, ASTRewrite rewrite, ASTNode typeNode) {
        BodyDeclarationRewrite bodyDeclarationRewrite = BodyDeclarationRewrite.create((ASTRewrite)rewrite, (ASTNode)typeNode);
        bodyDeclarationRewrite.insert(decl, null);
    }

    static class FieldDeclFinder
    extends ASTVisitor {
        private boolean hasEnteredRootType = false;
        private FieldDeclaration fieldDeclaration = null;
        private boolean multiDecl = false;
        private VariableDeclarationFragment oldBadFragment = null;
        private final String privatedProperty;

        public FieldDeclFinder(String privatedProperty) {
            this.privatedProperty = privatedProperty;
        }

        public boolean visit(FieldDeclaration fieldDeclaration) {
            if (this.fieldDeclaration != null) {
                return false;
            }
            Collection fragments = (Collection)fieldDeclaration.getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.FRAGMENTS_PROPERTY);
            for (VariableDeclarationFragment fragment : fragments) {
                if (!fragment.getName().getFullyQualifiedName().equals(this.privatedProperty)) continue;
                this.fieldDeclaration = fieldDeclaration;
                this.multiDecl = fragments.size() > 1;
                this.oldBadFragment = fragment;
                return false;
            }
            return false;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            if (this.hasEnteredRootType) {
                return false;
            }
            this.hasEnteredRootType = true;
            return true;
        }

        public FieldDeclaration getFieldDeclaration() {
            return this.fieldDeclaration;
        }

        public boolean hasMultiDecl() {
            return this.multiDecl;
        }

        public VariableDeclarationFragment getOldBadFragment() {
            return this.oldBadFragment;
        }
    }
}

