/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template.datamodel;

import com.redhat.qute.commons.datamodel.DataModelBaseTemplate;
import com.redhat.qute.commons.datamodel.DataModelFragment;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.jdt.internal.resolver.ITypeResolver;
import com.redhat.qute.jdt.internal.template.TemplateDataSupport;
import com.redhat.qute.jdt.template.datamodel.AbstractAnnotationTypeReferenceDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import com.redhat.qute.jdt.utils.JDTQuteProjectUtils;
import com.redhat.qute.jdt.utils.JDTTypeUtils;
import com.redhat.qute.jdt.utils.TemplateNameStrategy;
import com.redhat.qute.jdt.utils.TemplatePathInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class CheckedTemplateSupport
extends AbstractAnnotationTypeReferenceDataModelProvider {
    private static final Logger LOGGER = Logger.getLogger(CheckedTemplateSupport.class.getName());
    private static final String[] ANNOTATION_NAMES = new String[]{"io.quarkus.qute.CheckedTemplate", "io.quarkus.qute.api.CheckedTemplate"};

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation checkedTemplateAnnotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            boolean ignoreFragments = CheckedTemplateSupport.isIgnoreFragments(checkedTemplateAnnotation);
            String basePath = CheckedTemplateSupport.getBasePath(checkedTemplateAnnotation);
            TemplateNameStrategy templateNameStrategy = CheckedTemplateSupport.getDefaultName(checkedTemplateAnnotation);
            CheckedTemplateSupport.collectDataModelTemplateForCheckedTemplate(type, basePath, ignoreFragments, templateNameStrategy, context.getTypeResolver(type), context.getDataModelProject().getTemplates(), monitor);
        }
    }

    public static boolean isIgnoreFragments(IAnnotation checkedTemplateAnnotation) {
        boolean ignoreFragments = false;
        if (checkedTemplateAnnotation != null) {
            try {
                Boolean result = AnnotationUtils.getAnnotationMemberValueAsBoolean(checkedTemplateAnnotation, "ignoreFragments");
                if (result != null) {
                    ignoreFragments = result;
                }
            }
            catch (Exception exception) {}
        }
        return ignoreFragments;
    }

    public static String getBasePath(IAnnotation checkedTemplateAnnotation) {
        String basePath = null;
        if (checkedTemplateAnnotation != null) {
            try {
                IMemberValuePair[] iMemberValuePairArray = checkedTemplateAnnotation.getMemberValuePairs();
                int n = iMemberValuePairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemberValuePair pair = iMemberValuePairArray[n2];
                    if ("basePath".equalsIgnoreCase(pair.getMemberName())) {
                        basePath = AnnotationUtils.getValueAsString(pair);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {}
        }
        return basePath;
    }

    public static TemplateNameStrategy getDefaultName(IAnnotation checkedTemplateAnnotation) {
        TemplateNameStrategy defaultName = TemplateNameStrategy.ELEMENT_NAME;
        if (checkedTemplateAnnotation != null) {
            try {
                IMemberValuePair[] iMemberValuePairArray = checkedTemplateAnnotation.getMemberValuePairs();
                int n = iMemberValuePairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemberValuePair pair = iMemberValuePairArray[n2];
                    if ("defaultName".equalsIgnoreCase(pair.getMemberName())) {
                        String value = AnnotationUtils.getValueAsString(pair);
                        if (value.endsWith("HYPHENATED_ELEMENT_NAME")) {
                            defaultName = TemplateNameStrategy.HYPHENATED_ELEMENT_NAME;
                        } else if (value.endsWith("UNDERSCORED_ELEMENT_NAME")) {
                            defaultName = TemplateNameStrategy.UNDERSCORED_ELEMENT_NAME;
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {}
        }
        return defaultName;
    }

    private static void collectDataModelTemplateForCheckedTemplate(IType type, String basePath, boolean ignoreFragments, TemplateNameStrategy templateNameStrategy, ITypeResolver typeResolver, List<DataModelTemplate<DataModelParameter>> templates, IProgressMonitor monitor) throws JavaModelException {
        IMethod[] methods;
        String className = CheckedTemplateSupport.getParentClassName(type);
        IMethod[] iMethodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            TemplatePathInfo templatePathInfo = JDTQuteProjectUtils.getTemplatePath(basePath, className, method.getElementName(), ignoreFragments, templateNameStrategy);
            String templateUri = templatePathInfo.getTemplateUri();
            String fragmentId = templatePathInfo.getFragmentId();
            DataModelTemplate<DataModelParameter> template = null;
            Optional<DataModelTemplate> existingTemplate = templates.stream().filter(t -> t.getTemplateUri().equals(templateUri)).findFirst();
            if (existingTemplate.isEmpty()) {
                template = CheckedTemplateSupport.createTemplateDataModel(templateUri, method, type);
                templates.add(template);
            } else {
                template = existingTemplate.get();
                if (fragmentId == null) {
                    template.setSourceMethod(method.getElementName());
                }
            }
            if (fragmentId != null && fragmentId.length() > 0) {
                DataModelFragment<DataModelParameter> fragment = CheckedTemplateSupport.createFragmentDataModel(fragmentId, method, type);
                template.addFragment(fragment);
                CheckedTemplateSupport.collectParameters(method, typeResolver, fragment, monitor);
            } else {
                CheckedTemplateSupport.collectParameters(method, typeResolver, template, monitor);
            }
            ++n2;
        }
    }

    public static String getParentClassName(IType type) {
        boolean innerClass;
        boolean bl = innerClass = type.getParent() != null && type.getParent().getElementType() == 7;
        String className = !innerClass ? null : JDTTypeUtils.getSimpleClassName(type.getCompilationUnit() != null ? type.getCompilationUnit().getElementName() : type.getClassFile().getElementName());
        return className;
    }

    private static DataModelTemplate<DataModelParameter> createTemplateDataModel(String templateUri, IMethod method, IType type) {
        DataModelTemplate<DataModelParameter> template = new DataModelTemplate<DataModelParameter>();
        template.setParameters(new ArrayList());
        template.setTemplateUri(templateUri);
        template.setSourceType(type.getFullyQualifiedName());
        template.setSourceMethod(method.getElementName());
        return template;
    }

    private static DataModelFragment<DataModelParameter> createFragmentDataModel(String fragmentId, IMethod method, IType type) {
        DataModelFragment<DataModelParameter> template = new DataModelFragment<DataModelParameter>();
        template.setParameters(new ArrayList());
        template.setId(fragmentId);
        template.setSourceType(type.getFullyQualifiedName());
        template.setSourceMethod(method.getElementName());
        return template;
    }

    public static void collectParameters(IMethod method, ITypeResolver typeResolver, DataModelBaseTemplate<DataModelParameter> templateOrFragment, IProgressMonitor monitor) {
        try {
            ILocalVariable[] parameters = method.getParameters();
            if (parameters.length > 0) {
                boolean varargs = Flags.isVarargs((int)method.getFlags());
                int i = 0;
                while (i < parameters.length) {
                    DataModelParameter parameter = CheckedTemplateSupport.createParameterDataModel(parameters[i], varargs && i == parameters.length - 1, typeResolver);
                    if (templateOrFragment.getParameter(parameter.getKey()) == null) {
                        templateOrFragment.addParameter(parameter);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while getting method template parameter of '" + method.getElementName() + "'.", e);
        }
        TemplateDataSupport.collectParametersFromDataMethodInvocation((IMember)method, templateOrFragment, monitor);
    }

    private static DataModelParameter createParameterDataModel(ILocalVariable methodParameter, boolean varags, ITypeResolver typeResolver) throws JavaModelException {
        String parameterName = methodParameter.getElementName();
        String parameterType = typeResolver.resolveLocalVariableSignature(methodParameter, varags);
        DataModelParameter parameter = new DataModelParameter();
        parameter.setKey(parameterName);
        parameter.setSourceType(parameterType);
        return parameter;
    }
}

