/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template.datamodel;

import com.redhat.qute.commons.QuteProjectScope;
import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.DataModelProject;
import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.commons.datamodel.resolvers.NamespaceResolverInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverInfo;
import com.redhat.qute.jdt.internal.AbstractQuteExtensionPointRegistry;
import com.redhat.qute.jdt.template.datamodel.IDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.JDTQuteProjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;

public class DataModelProviderRegistry
extends AbstractQuteExtensionPointRegistry<IDataModelProvider> {
    private static final Logger LOGGER = Logger.getLogger(DataModelProviderRegistry.class.getName());
    private static final String DATA_MODEL_PROVIDERS_EXTENSION_POINT_ID = "dataModelProviders";
    private static final String NAMESPACES_ATTR = "namespaces";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String URL_ATTR = "url";
    private static final DataModelProviderRegistry INSTANCE = new DataModelProviderRegistry();

    private DataModelProviderRegistry() {
    }

    public static DataModelProviderRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public String getProviderExtensionId() {
        return DATA_MODEL_PROVIDERS_EXTENSION_POINT_ID;
    }

    @Override
    protected IDataModelProvider createInstance(IConfigurationElement ce) throws CoreException {
        IDataModelProvider provider = (IDataModelProvider)super.createInstance(ce);
        String namespaces = ce.getAttribute(NAMESPACES_ATTR);
        if (StringUtils.isNotEmpty((CharSequence)namespaces)) {
            String description = ce.getAttribute(DESCRIPTION_ATTR);
            String url = ce.getAttribute(URL_ATTR);
            NamespaceResolverInfo info = new NamespaceResolverInfo();
            info.setNamespaces(Arrays.asList(namespaces.split(",")));
            info.setDescription(description);
            info.setUrl(url);
            provider.setNamespaceResolverInfo(info);
        }
        return provider;
    }

    public DataModelProject<DataModelTemplate<DataModelParameter>> getDataModelProject(IJavaProject javaProject, List<QuteProjectScope> scopes, IProgressMonitor monitor) throws CoreException {
        DataModelProject<DataModelTemplate<DataModelParameter>> project = new DataModelProject<DataModelTemplate<DataModelParameter>>();
        project.setTemplates(new ArrayList());
        project.setNamespaceResolverInfos(new HashMap<String, NamespaceResolverInfo>());
        project.setValueResolvers(new ArrayList<ValueResolverInfo>());
        this.collectDataModel(project, javaProject, scopes, monitor);
        return project;
    }

    private void collectDataModel(DataModelProject<DataModelTemplate<DataModelParameter>> project, IJavaProject javaProject, List<QuteProjectScope> scopes, IProgressMonitor monitor) throws CoreException {
        long startTime = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Start collecting Qute data model for '" + JDTQuteProjectUtils.getProjectUri(javaProject) + "' project.");
        }
        SubMonitor mainMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Scanning data model for '" + javaProject.getProject().getName() + "' project in '" + scopes.stream().map(Enum::name).collect(Collectors.joining("+")) + "'"), (int)100);
        try {
            boolean excludeTestCode = true;
            this.scanJavaClasses(javaProject, excludeTestCode, scopes, project, mainMonitor.split(100));
            if (mainMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        finally {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("End collecting Qute data model for '" + JDTQuteProjectUtils.getProjectUri(javaProject) + "' project in " + (System.currentTimeMillis() - startTime) + "ms.");
            }
            mainMonitor.done();
        }
    }

    private void scanJavaClasses(IJavaProject javaProject, boolean excludeTestCode, List<QuteProjectScope> scopes, DataModelProject<DataModelTemplate<DataModelParameter>> project, SubMonitor mainMonitor) throws JavaModelException, CoreException {
        mainMonitor.subTask("Scanning Java classes");
        final SubMonitor subMonitor = mainMonitor.setWorkRemaining(100);
        try {
            subMonitor.split(5);
            SearchPattern pattern = this.createSearchPattern();
            SearchEngine engine = new SearchEngine();
            IJavaSearchScope scope = this.createSearchScope(javaProject, scopes, excludeTestCode, (IProgressMonitor)subMonitor);
            final SearchContext context = new SearchContext(javaProject, project, scopes);
            this.beginSearch(context, (IProgressMonitor)subMonitor);
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (!match.isInsideDocComment()) {
                        DataModelProviderRegistry.this.collectDataModel(match, context, (IProgressMonitor)subMonitor);
                    }
                }
            }, (IProgressMonitor)subMonitor);
            this.endSearch(context, (IProgressMonitor)subMonitor);
        }
        finally {
            subMonitor.done();
        }
    }

    private void beginSearch(SearchContext context, IProgressMonitor monitor) {
        for (IDataModelProvider provider : this.getProviders()) {
            provider.beginSearch(context, monitor);
        }
    }

    private void endSearch(SearchContext context, IProgressMonitor monitor) {
        for (IDataModelProvider provider : this.getProviders()) {
            provider.endSearch(context, monitor);
        }
    }

    private SearchPattern createSearchPattern() {
        SearchPattern leftPattern = null;
        for (IDataModelProvider provider : this.getProviders()) {
            if (leftPattern == null) {
                leftPattern = provider.createSearchPattern();
                continue;
            }
            SearchPattern rightPattern = provider.createSearchPattern();
            if (rightPattern == null) continue;
            leftPattern = SearchPattern.createOrPattern((SearchPattern)leftPattern, (SearchPattern)rightPattern);
        }
        return leftPattern;
    }

    private void collectDataModel(SearchMatch match, SearchContext context, IProgressMonitor monitor) {
        for (IDataModelProvider provider : this.getProviders()) {
            try {
                provider.collectDataModel(match, context, monitor);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while collecting data model with the provider '" + provider.getClass().getName() + "'.", e);
            }
        }
    }

    private IJavaSearchScope createSearchScope(IJavaProject project, List<QuteProjectScope> scopes, boolean excludeTestCode, IProgressMonitor monitor) throws JavaModelException {
        int searchScope = 0;
        for (QuteProjectScope scope : scopes) {
            switch (scope) {
                case sources: {
                    searchScope |= 1;
                    break;
                }
                case dependencies: {
                    searchScope |= 2;
                }
            }
        }
        return SearchEngine.createJavaSearchScope((boolean)excludeTestCode, (IJavaElement[])new IJavaElement[]{project}, (int)searchScope);
    }
}

