/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template.datamodel;

import com.redhat.qute.commons.datamodel.resolvers.ValueResolverInfo;
import com.redhat.qute.commons.datamodel.resolvers.ValueResolverKind;
import com.redhat.qute.jdt.QuteSupportForTemplate;
import com.redhat.qute.jdt.internal.resolver.ITypeResolver;
import com.redhat.qute.jdt.template.datamodel.AbstractAnnotationTypeReferenceDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import com.redhat.qute.jdt.utils.JDTTypeUtils;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TemplateExtensionAnnotationSupport
extends AbstractAnnotationTypeReferenceDataModelProvider {
    private static final Logger LOGGER = Logger.getLogger(TemplateExtensionAnnotationSupport.class.getName());
    private static final String[] ANNOTATION_NAMES = new String[]{"io.quarkus.qute.TemplateExtension"};

    @Override
    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    @Override
    protected void processAnnotation(IJavaElement javaElement, IAnnotation annotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        if (!(javaElement instanceof IAnnotatable)) {
            return;
        }
        IAnnotation templateExtension = AnnotationUtils.getAnnotation((IAnnotatable)javaElement, "io.quarkus.qute.TemplateExtension");
        if (templateExtension == null) {
            return;
        }
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            TemplateExtensionAnnotationSupport.collectResolversForTemplateExtension(type, templateExtension, context.getDataModelProject().getValueResolvers(), monitor);
        } else if (javaElement instanceof IMethod) {
            IMethod method = (IMethod)javaElement;
            TemplateExtensionAnnotationSupport.collectResolversForTemplateExtension(method, templateExtension, context.getDataModelProject().getValueResolvers(), monitor);
        }
    }

    private static void collectResolversForTemplateExtension(IType type, IAnnotation templateExtension, List<ValueResolverInfo> resolvers, IProgressMonitor monitor) {
        try {
            ITypeResolver typeResolver = QuteSupportForTemplate.createTypeResolver((IMember)type);
            IMethod[] methods = type.getMethods();
            int resolversLengthPreAdd = resolvers.size();
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (TemplateExtensionAnnotationSupport.isTemplateExtensionMethod(method)) {
                    IAnnotation methodTemplateExtension = AnnotationUtils.getAnnotation((IAnnotatable)method, "io.quarkus.qute.TemplateExtension");
                    TemplateExtensionAnnotationSupport.collectResolversForTemplateExtension(method, methodTemplateExtension != null ? methodTemplateExtension : templateExtension, resolvers, typeResolver, ValueResolverKind.TemplateExtensionOnClass);
                }
                ++n2;
            }
            if (resolversLengthPreAdd == resolvers.size()) {
                TemplateExtensionAnnotationSupport.addDummyResolverForTemplateExtensionsClass(type, resolvers);
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting methods of '" + type.getElementName() + "'.", e);
        }
    }

    private static boolean isTemplateExtensionMethod(IMethod method) {
        try {
            return !method.isConstructor() && !JDTTypeUtils.isVoidReturnType(method);
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting method information of '" + method.getElementName() + "'.", e);
            return false;
        }
    }

    public static void collectResolversForTemplateExtension(IMethod method, IAnnotation templateExtension, List<ValueResolverInfo> resolvers, IProgressMonitor monitor) {
        if (TemplateExtensionAnnotationSupport.isTemplateExtensionMethod(method)) {
            ITypeResolver typeResolver = QuteSupportForTemplate.createTypeResolver((IMember)method);
            TemplateExtensionAnnotationSupport.collectResolversForTemplateExtension(method, templateExtension, resolvers, typeResolver, ValueResolverKind.TemplateExtensionOnMethod);
        }
    }

    private static void collectResolversForTemplateExtension(IMethod method, IAnnotation templateExtension, List<ValueResolverInfo> resolvers, ITypeResolver typeResolver, ValueResolverKind kind) {
        ValueResolverInfo resolver = new ValueResolverInfo();
        resolver.setSourceType(method.getDeclaringType().getFullyQualifiedName());
        resolver.setSignature(typeResolver.resolveMethodSignature(method));
        resolver.setKind(kind);
        resolver.setBinary(method.getDeclaringType().isBinary());
        try {
            String namespace = AnnotationUtils.getAnnotationMemberValue(templateExtension, "namespace");
            resolver.setNamespace(namespace);
            List<String> matchNames = TemplateExtensionAnnotationSupport.getAnnotationMemberValueAsArray(templateExtension, "matchNames");
            if (matchNames != null) {
                resolver.setMatchNames(matchNames);
            } else {
                String matchName = AnnotationUtils.getAnnotationMemberValue(templateExtension, "matchName");
                if (StringUtils.isNotEmpty((CharSequence)matchName)) {
                    resolver.setMatchNames(Arrays.asList(matchName));
                }
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting annotation member value of '" + method.getElementName() + "'.", e);
        }
        if (!resolvers.contains(resolver)) {
            resolvers.add(resolver);
        }
    }

    private static void addDummyResolverForTemplateExtensionsClass(IType type, List<ValueResolverInfo> resolvers) {
        ValueResolverInfo resolver = new ValueResolverInfo();
        resolver.setSourceType(type.getFullyQualifiedName());
        resolver.setKind(ValueResolverKind.TemplateExtensionOnClass);
        resolver.setBinary(type.isBinary());
        resolver.setSignature("");
        resolvers.add(resolver);
    }

    public static List<String> getAnnotationMemberValueAsArray(IAnnotation annotation, String memberName) throws JavaModelException {
        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair pair = iMemberValuePairArray[n2];
            if (memberName.equals(pair.getMemberName())) {
                if (pair.getValue() instanceof Object[]) {
                    Object[] values = (Object[])pair.getValue();
                    return Stream.of(values).filter(o -> o != null).map(o -> o.toString()).collect(Collectors.toList());
                }
                return null;
            }
            ++n2;
        }
        return null;
    }
}

