/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template.datamodel;

import com.redhat.qute.commons.datamodel.DataModelParameter;
import com.redhat.qute.commons.datamodel.DataModelTemplate;
import com.redhat.qute.jdt.internal.resolver.ITypeResolver;
import com.redhat.qute.jdt.internal.template.TemplateDataSupport;
import com.redhat.qute.jdt.internal.template.datamodel.CheckedTemplateSupport;
import com.redhat.qute.jdt.template.datamodel.AbstractInterfaceImplementationDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import com.redhat.qute.jdt.utils.JDTQuteProjectUtils;
import com.redhat.qute.jdt.utils.TemplateNameStrategy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class TemplateRecordsSupport
extends AbstractInterfaceImplementationDataModelProvider {
    private static final String[] INTERFACE_NAMES = new String[]{"io.quarkus.qute.TemplateInstance"};

    @Override
    protected String[] getInterfaceNames() {
        return INTERFACE_NAMES;
    }

    @Override
    protected void processType(IType type, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        if (!type.isRecord()) {
            return;
        }
        ITypeResolver typeResolver = context.getTypeResolver(type);
        TemplateRecordsSupport.collectDataModelTemplateForTemplateRecord(type, typeResolver, context.getDataModelProject().getTemplates(), monitor);
    }

    private static void collectDataModelTemplateForTemplateRecord(IType type, ITypeResolver typeResolver, List<DataModelTemplate<DataModelParameter>> templates, IProgressMonitor monitor) throws JavaModelException {
        DataModelTemplate<DataModelParameter> template = TemplateRecordsSupport.createTemplateDataModel(type, typeResolver, monitor);
        templates.add(template);
    }

    private static DataModelTemplate<DataModelParameter> createTemplateDataModel(IType recordType, ITypeResolver typeResolver, IProgressMonitor monitor) throws JavaModelException {
        IAnnotation checkedTemplateAnnotation = AnnotationUtils.getAnnotation((IAnnotatable)recordType, "io.quarkus.qute.CheckedTemplate", "io.quarkus.qute.api.CheckedTemplate");
        boolean ignoreFragments = CheckedTemplateSupport.isIgnoreFragments(checkedTemplateAnnotation);
        String basePath = CheckedTemplateSupport.getBasePath(checkedTemplateAnnotation);
        TemplateNameStrategy templateNameStrategy = CheckedTemplateSupport.getDefaultName(checkedTemplateAnnotation);
        String className = CheckedTemplateSupport.getParentClassName(recordType);
        String recordName = recordType.getElementName();
        String templateUri = JDTQuteProjectUtils.getTemplatePath(basePath, className, recordName, ignoreFragments, templateNameStrategy).getTemplateUri();
        DataModelTemplate<DataModelParameter> template = new DataModelTemplate<DataModelParameter>();
        template.setParameters(new ArrayList());
        template.setTemplateUri(templateUri);
        template.setSourceType(recordType.getFullyQualifiedName());
        IField[] iFieldArray = recordType.getRecordComponents();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            DataModelParameter parameter = new DataModelParameter();
            parameter.setKey(field.getElementName());
            parameter.setSourceType(typeResolver.resolveTypeSignature(field.getTypeSignature(), field.getDeclaringType()));
            if (template.getParameter(parameter.getKey()) == null) {
                template.addParameter(parameter);
            }
            ++n2;
        }
        TemplateDataSupport.collectParametersFromDataMethodInvocation((IMember)recordType, template, monitor);
        return template;
    }
}

