/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template.resolvedtype;

import com.redhat.qute.commons.InvalidMethodReason;
import com.redhat.qute.commons.JavaFieldInfo;
import com.redhat.qute.commons.JavaMethodInfo;
import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.jdt.QuteSupportForTemplate;
import com.redhat.qute.jdt.internal.resolver.AbstractTypeResolver;
import com.redhat.qute.jdt.internal.resolver.ITypeResolver;
import com.redhat.qute.jdt.internal.template.resolvedtype.IResolvedJavaTypeFactory;
import com.redhat.qute.jdt.utils.JDTTypeUtils;
import com.redhat.qute.jdt.utils.QuteReflectionAnnotationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public abstract class AbstractResolvedJavaTypeFactory
implements IResolvedJavaTypeFactory {
    private static final Logger LOGGER = Logger.getLogger(AbstractResolvedJavaTypeFactory.class.getName());

    @Override
    public ResolvedJavaTypeInfo create(IType type) throws CoreException {
        IMethod[] methods;
        JavaFieldInfo info;
        IField field;
        IField[] fields;
        ITypeResolver typeResolver = QuteSupportForTemplate.createTypeResolver((IMember)type);
        String typeSignature = AbstractTypeResolver.resolveJavaTypeSignature(type);
        ArrayList<JavaFieldInfo> fieldsInfo = new ArrayList<JavaFieldInfo>();
        IField[] iFieldArray = fields = type.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            field = iFieldArray[n2];
            if (this.isValidField(field, type)) {
                info = new JavaFieldInfo();
                info.setSignature(typeResolver.resolveFieldSignature(field));
                fieldsInfo.add(info);
            }
            ++n2;
        }
        if (type.isRecord()) {
            iFieldArray = type.getRecordComponents();
            n = iFieldArray.length;
            n2 = 0;
            while (n2 < n) {
                field = iFieldArray[n2];
                if (this.isValidRecordField(field, type)) {
                    info = new JavaFieldInfo();
                    info.setSignature(typeResolver.resolveFieldSignature(field));
                    fieldsInfo.add(info);
                }
                ++n2;
            }
        }
        ArrayList<JavaMethodInfo> methodsInfo = new ArrayList<JavaMethodInfo>();
        HashMap<String, InvalidMethodReason> invalidMethods = new HashMap<String, InvalidMethodReason>();
        IMethod[] iMethodArray = methods = type.getMethods();
        int n3 = methods.length;
        int n4 = 0;
        while (n4 < n3) {
            IMethod method = iMethodArray[n4];
            if (this.isValidMethod(method, type)) {
                try {
                    InvalidMethodReason invalid = this.getValidMethodForQute(method, typeSignature);
                    if (invalid != null) {
                        invalidMethods.put(method.getElementName(), invalid);
                    } else {
                        JavaMethodInfo info2 = this.createMethod(method, typeResolver);
                        methodsInfo.add(info2);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while getting method signature of '" + method.getElementName() + "'.", e);
                }
            }
            ++n4;
        }
        ResolvedJavaTypeInfo resolvedType = new ResolvedJavaTypeInfo();
        resolvedType.setBinary(type.isBinary());
        resolvedType.setSignature(typeSignature);
        resolvedType.setFields(fieldsInfo);
        resolvedType.setMethods(methodsInfo);
        resolvedType.setInvalidMethods(invalidMethods);
        resolvedType.setExtendedTypes(typeResolver.resolveExtendedType());
        resolvedType.setJavaTypeKind(JDTTypeUtils.getJavaTypeKind(type));
        QuteReflectionAnnotationUtils.collectAnnotations(resolvedType, type, typeResolver);
        return resolvedType;
    }

    protected JavaMethodInfo createMethod(IMethod method, ITypeResolver typeResolver) {
        JavaMethodInfo info = new JavaMethodInfo();
        info.setSignature(typeResolver.resolveMethodSignature(method));
        return info;
    }

    protected abstract boolean isValidRecordField(IField var1, IType var2);

    protected abstract boolean isValidField(IField var1, IType var2) throws JavaModelException;

    protected boolean isValidMethod(IMethod method, IType type) {
        block3: {
            try {
                if (!method.isConstructor() && method.exists() && !Flags.isSynthetic((int)method.getFlags())) break block3;
                return false;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while checking if '" + method.getElementName() + "' is valid.", e);
                return false;
            }
        }
        return type.isInterface() || Flags.isPublic((int)method.getFlags());
    }

    protected abstract InvalidMethodReason getValidMethodForQute(IMethod var1, String var2);
}

