/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.internal.template.rootpath;

import com.redhat.qute.commons.TemplateRootPath;
import com.redhat.qute.jdt.internal.AbstractQuteExtensionPointRegistry;
import com.redhat.qute.jdt.template.rootpath.ITemplateRootPathProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;

public class TemplateRootPathProviderRegistry
extends AbstractQuteExtensionPointRegistry<ITemplateRootPathProvider> {
    private static final Logger LOGGER = Logger.getLogger(TemplateRootPathProviderRegistry.class.getName());
    private static final String TEMPLATE_ROOT_PATH_PROVIDERS_EXTENSION_POINT_ID = "templateRootPathProviders";
    private static final TemplateRootPathProviderRegistry INSTANCE = new TemplateRootPathProviderRegistry();

    private TemplateRootPathProviderRegistry() {
    }

    public static TemplateRootPathProviderRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public String getProviderExtensionId() {
        return TEMPLATE_ROOT_PATH_PROVIDERS_EXTENSION_POINT_ID;
    }

    public List<TemplateRootPath> getTemplateRootPaths(IJavaProject javaProject, IProgressMonitor monitor) {
        ArrayList<TemplateRootPath> rootPaths = new ArrayList<TemplateRootPath>();
        for (ITemplateRootPathProvider provider : super.getProviders()) {
            if (!provider.isApplicable(javaProject)) continue;
            try {
                provider.collectTemplateRootPaths(javaProject, rootPaths);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while collecting template root path with the provider '" + provider.getClass().getName() + "'.", e);
            }
        }
        return rootPaths;
    }
}

