/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.template.datamodel;

import com.redhat.qute.jdt.template.datamodel.AbstractDataModelProvider;
import com.redhat.qute.jdt.template.datamodel.SearchContext;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.TypeReferenceMatch;

public abstract class AbstractAnnotationTypeReferenceDataModelProvider
extends AbstractDataModelProvider {
    private static final Logger LOGGER = Logger.getLogger(AbstractAnnotationTypeReferenceDataModelProvider.class.getName());

    @Override
    protected String[] getPatterns() {
        return this.getAnnotationNames();
    }

    protected abstract String[] getAnnotationNames();

    @Override
    protected SearchPattern createSearchPattern(String annotationName) {
        return AbstractAnnotationTypeReferenceDataModelProvider.createAnnotationTypeReferenceSearchPattern(annotationName);
    }

    @Override
    public void collectDataModel(SearchMatch match, SearchContext context, IProgressMonitor monitor) {
        block5: {
            IJavaElement javaElement = null;
            try {
                Object element = AbstractAnnotationTypeReferenceDataModelProvider.getMatchedElement(match);
                if (element instanceof IAnnotation) {
                    IAnnotation annotation = (IAnnotation)element;
                    javaElement = annotation.getParent();
                    this.processAnnotation(javaElement, context, monitor, annotation);
                } else if (element instanceof IAnnotatable && element instanceof IJavaElement) {
                    javaElement = (IJavaElement)element;
                    this.processAnnotation(javaElement, context, monitor);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                LOGGER.log(Level.SEVERE, (String)("Cannot collect Qute data model for the Java element '" + String.valueOf(javaElement) != null ? javaElement.getElementName() : String.valueOf(match.getElement()) + "'."), e);
            }
        }
    }

    private static Object getMatchedElement(SearchMatch match) {
        if (match instanceof TypeReferenceMatch) {
            IJavaElement localElement = ((TypeReferenceMatch)match).getLocalElement();
            return localElement != null ? localElement : match.getElement();
        }
        return match.getElement();
    }

    protected void processAnnotation(IJavaElement javaElement, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        IAnnotation[] annotations;
        IAnnotation[] iAnnotationArray = annotations = ((IAnnotatable)javaElement).getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            this.processAnnotation(javaElement, context, monitor, annotation);
            ++n2;
        }
    }

    private void processAnnotation(IJavaElement javaElement, SearchContext context, IProgressMonitor monitor, IAnnotation annotation) throws JavaModelException {
        String[] names;
        String[] stringArray = names = this.getAnnotationNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String annotationName = stringArray[n2];
            if (AnnotationUtils.isMatchAnnotation(annotation, annotationName)) {
                this.processAnnotation(javaElement, annotation, annotationName, context, monitor);
                break;
            }
            ++n2;
        }
    }

    protected abstract void processAnnotation(IJavaElement var1, IAnnotation var2, String var3, SearchContext var4, IProgressMonitor var5) throws JavaModelException;
}

