/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.utils;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class BeanUtil {
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String IS = "is";

    public static boolean isGetter(String methodName, int numberOfParameters) {
        return (methodName.startsWith(GET) && !methodName.equals(GET) || methodName.startsWith(IS) && !methodName.equals(IS)) && numberOfParameters == 0;
    }

    public static boolean isSetter(String methodName, int numberOfParameters) {
        return methodName.startsWith(SET) && !methodName.equals(SET) && numberOfParameters == 1;
    }

    public static boolean isGetter(IMethod method) {
        return method != null && BeanUtil.isGetter(method.getElementName(), method.getNumberOfParameters()) && BeanUtil.checkPropertyReturnType(method);
    }

    public static boolean checkPropertyReturnType(String typeName, String methodName) {
        if (typeName == null || typeName.equals("void")) {
            return false;
        }
        return !methodName.startsWith(IS) || "boolean".equals(typeName) || "java.lang.Boolean".equals(typeName);
    }

    private static boolean checkPropertyReturnType(IMethod method) {
        return method != null && BeanUtil.checkPropertyReturnType(BeanUtil.getMemberTypeAsString(method), method.getElementName());
    }

    public static boolean isSetter(IMethod method) {
        return method != null && BeanUtil.isSetter(method.getElementName(), method.getNumberOfParameters());
    }

    public static String getPropertyName(String methodName) {
        if (BeanUtil.isGetter(methodName, 0) || BeanUtil.isSetter(methodName, 1)) {
            StringBuffer name = new StringBuffer(methodName);
            if (methodName.startsWith(IS)) {
                name.delete(0, 2);
            } else {
                name.delete(0, 3);
            }
            if (name.length() < 2 || !Character.isUpperCase(name.charAt(1))) {
                name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            }
            return name.toString();
        }
        return null;
    }

    public static String getDefaultBeanName(String className) {
        int lastDotPosition = ((String)className).lastIndexOf(".");
        if (lastDotPosition >= 0 && ((String)className).length() > lastDotPosition) {
            className = ((String)className).substring(lastDotPosition + 1);
        }
        if (((String)className).length() > 0) {
            className = ((String)className).substring(0, 1).toLowerCase() + ((String)className).substring(1);
        }
        return className;
    }

    public static String getDefaultBeanName(IType type) {
        return BeanUtil.getDefaultBeanName(type.getElementName());
    }

    public static String getClassName(String beanName) {
        int lastDotPosition = ((String)beanName).lastIndexOf(".");
        String beforeLastDot = "";
        if (lastDotPosition >= 0 && ((String)beanName).length() > lastDotPosition) {
            beforeLastDot = ((String)beanName).substring(0, lastDotPosition + 1);
            ++lastDotPosition;
        } else {
            lastDotPosition = 0;
        }
        if (((String)beanName).length() > lastDotPosition) {
            beanName = beforeLastDot + ((String)beanName).substring(lastDotPosition, lastDotPosition + 1).toUpperCase() + ((String)beanName).substring(lastDotPosition + 1);
        }
        return beanName;
    }

    private static String getMemberTypeAsString(IMethod m) {
        if (m == null) {
            return null;
        }
        try {
            return BeanUtil.resolveTypeAsString(m.getDeclaringType(), m.getReturnType());
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static String resolveTypeAsString(IType type, String typeName) {
        if (type == null || typeName == null) {
            return null;
        }
        int i = (typeName = new String(Signature.toCharArray((char[])typeName.toCharArray()))).indexOf(60);
        if (i > 0) {
            typeName = typeName.substring(0, i);
        }
        return BeanUtil.resolveType(type, typeName);
    }

    private static String resolveType(IType type, String typeName) {
        try {
            String[][] resolvedArray = type.resolveType((String)typeName);
            if (resolvedArray == null) {
                return typeName;
            }
            typeName = "";
            int i = 0;
            while (i < resolvedArray[0].length) {
                typeName = (String)typeName + (!"".equals(typeName) ? "." : "") + resolvedArray[0][i];
                ++i;
            }
            return typeName;
        }
        catch (JavaModelException javaModelException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }
}

