/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.utils;

import com.redhat.qute.jdt.utils.AnnotationUtils;
import com.redhat.qute.jdt.utils.BeanUtil;
import java.beans.Introspector;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public class CDIUtils {
    private CDIUtils() {
    }

    public static String getSimpleName(IJavaElement javaElement, String annotationNamedValue) {
        return CDIUtils.getSimpleName(javaElement.getElementName(), annotationNamedValue, javaElement.getElementType(), () -> BeanUtil.isGetter((IMethod)javaElement));
    }

    public static String getSimpleName(String javaElementName, String annotationNamedValue, int javaElementType) {
        return CDIUtils.getSimpleName(javaElementName, annotationNamedValue, javaElementType, () -> false);
    }

    public static String getSimpleName(String javaElementName, String annotationNamedValue, int javaElementType, Supplier<Boolean> isGetterMethod) {
        if (StringUtils.isNotEmpty((CharSequence)annotationNamedValue)) {
            return annotationNamedValue;
        }
        switch (javaElementType) {
            case 7: {
                return Introspector.decapitalize(javaElementName);
            }
            case 8: {
                return javaElementName;
            }
            case 9: {
                if (isGetterMethod.get().booleanValue()) {
                    return BeanUtil.getPropertyName(javaElementName);
                }
                return javaElementName;
            }
        }
        return javaElementName;
    }

    public static boolean isValidBean(IJavaElement javaElement) {
        try {
            IType type = (IType)javaElement;
            return type.getDeclaringType() == null && !Flags.isAbstract((int)type.getFlags()) && !AnnotationUtils.hasAnnotation((IAnnotatable)javaElement, "javax.decorator.Decorator", "jakarta.decorator.Decorator") && !AnnotationUtils.hasAnnotation((IAnnotatable)javaElement, "javax.enterprise.inject.Vetoed", "jakarta.enterprise.inject.Vetoed") && type.isClass();
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasNoArgConstructor(IType type) {
        try {
            boolean hasNoArgConstructor = true;
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return hasNoArgConstructor;
                }
                IMethod method = iMethodArray[n2];
                if (method.isConstructor()) {
                    int paramCount = method.getNumberOfParameters();
                    if (paramCount > 0) {
                        hasNoArgConstructor = false;
                    } else if (paramCount == 0) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return true;
        }
    }
}

