/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.utils;

import com.redhat.qute.commons.JavaTypeKind;
import com.redhat.qute.jdt.internal.resolver.AbstractTypeResolver;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class JDTTypeUtils {
    private static final Logger LOGGER = Logger.getLogger(JDTTypeUtils.class.getName());

    public static String getSimpleClassName(String className) {
        if (className.endsWith(".java")) {
            return className.substring(0, className.length() - ".java".length());
        }
        return className;
    }

    public static IType findType(IJavaProject project, String className) {
        try {
            IType type = project.findType(className, (IProgressMonitor)new NullProgressMonitor());
            if (type != null && type.exists()) {
                return type;
            }
        }
        catch (JavaModelException javaModelException) {}
        try {
            return project.findType(className);
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while finding type for '" + className + "'.", e);
            return null;
        }
    }

    public static String getResolvedTypeName(IField field) {
        try {
            String signature = field.getTypeSignature();
            IType primaryType = field.getTypeRoot().findPrimaryType();
            return JavaModelUtil.getResolvedTypeName((String)signature, (IType)primaryType);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static String getFullQualifiedName(String className, IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        if (className.indexOf(46) != -1) {
            return className;
        }
        IType nameType = JDTTypeUtils.findType(className, javaProject, monitor);
        if (nameType != null && nameType.exists()) {
            return AbstractTypeResolver.resolveJavaTypeSignature(nameType);
        }
        return className;
    }

    public static IType findType(String className, IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        try {
            IType type = javaProject.findType(className, monitor);
            if (type != null) {
                return type;
            }
            if (className.indexOf(46) == -1) {
                return javaProject.findType("java.lang." + className, monitor);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while finding type for '" + className + "'.", e);
        }
        return null;
    }

    public static boolean isStaticMember(IMember member) throws JavaModelException {
        return Modifier.isStatic((int)member.getFlags());
    }

    public static boolean isPrivateMember(IMember member) throws JavaModelException {
        return Modifier.isPrivate((int)member.getFlags());
    }

    public static boolean isPublicMember(IMember member) throws JavaModelException {
        return Modifier.isPublic((int)member.getFlags());
    }

    public static boolean isVoidReturnType(IMethod method) throws JavaModelException {
        return "V".equals(method.getReturnType());
    }

    public static JavaTypeKind getJavaTypeKind(IType type) throws JavaModelException {
        if (type.isClass()) {
            return JavaTypeKind.Class;
        }
        if (type.isEnum()) {
            return JavaTypeKind.Enum;
        }
        if (type.isInterface()) {
            return JavaTypeKind.Interface;
        }
        return JavaTypeKind.Unknown;
    }
}

