/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qute.jdt.utils;

import com.redhat.qute.commons.ResolvedJavaTypeInfo;
import com.redhat.qute.commons.annotations.RegisterForReflectionAnnotation;
import com.redhat.qute.commons.annotations.TemplateDataAnnotation;
import com.redhat.qute.jdt.internal.resolver.ITypeResolver;
import com.redhat.qute.jdt.utils.AnnotationUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class QuteReflectionAnnotationUtils {
    private static final Logger LOGGER = Logger.getLogger(QuteReflectionAnnotationUtils.class.getName());

    public static void collectAnnotations(ResolvedJavaTypeInfo resolvedType, IType type, ITypeResolver typeResolver) throws JavaModelException {
        IAnnotation[] annotations;
        ArrayList<TemplateDataAnnotation> templateDataAnnotations = null;
        RegisterForReflectionAnnotation registerForReflectionAnnotation = null;
        IAnnotation[] iAnnotationArray = annotations = type.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            if (AnnotationUtils.isMatchAnnotation(annotation, "io.quarkus.qute.TemplateData")) {
                if (templateDataAnnotations == null) {
                    templateDataAnnotations = new ArrayList<TemplateDataAnnotation>();
                }
                templateDataAnnotations.add(QuteReflectionAnnotationUtils.createTemplateData(annotation, typeResolver));
            } else if (AnnotationUtils.isMatchAnnotation(annotation, "io.quarkus.runtime.annotations.RegisterForReflection")) {
                registerForReflectionAnnotation = QuteReflectionAnnotationUtils.createRegisterForReflection(annotation, typeResolver);
            }
            ++n2;
        }
        resolvedType.setTemplateDataAnnotations(templateDataAnnotations);
        resolvedType.setRegisterForReflectionAnnotation(registerForReflectionAnnotation);
    }

    private static TemplateDataAnnotation createTemplateData(IAnnotation templateDataAnnotation, ITypeResolver typeResolver) {
        TemplateDataAnnotation templateData = new TemplateDataAnnotation();
        try {
            IMemberValuePair[] iMemberValuePairArray = templateDataAnnotation.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                switch (pair.getMemberName()) {
                    case "ignoreSuperclasses": {
                        Boolean ignoreSuperclasses = AnnotationUtils.getValueAsBoolean(pair);
                        if (!Boolean.TRUE.equals(ignoreSuperclasses)) break;
                        templateData.setIgnoreSuperclasses(ignoreSuperclasses);
                        break;
                    }
                    case "target": {
                        String target = AnnotationUtils.getValueAsString(pair);
                        if (target == null) break;
                        target = QuteReflectionAnnotationUtils.resolveTarget(target, typeResolver);
                        templateData.setTarget(target);
                        break;
                    }
                    case "ignore": {
                        ArrayList<String> ignore = null;
                        Object[] values = AnnotationUtils.getValueAsArray(pair);
                        if (values != null && values.length > 0) {
                            ignore = new ArrayList<String>(values.length);
                            int i = 0;
                            while (i < values.length) {
                                String ignoreItem;
                                String string = ignoreItem = values[i] != null ? values[i].toString() : null;
                                if (ignoreItem != null) {
                                    ignore.add(ignoreItem);
                                }
                                ++i;
                            }
                        }
                        templateData.setIgnore(ignore);
                        break;
                    }
                    case "properties": {
                        Boolean properties = AnnotationUtils.getValueAsBoolean(pair);
                        if (!Boolean.TRUE.equals(properties)) break;
                        templateData.setProperties(properties);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting member values of '" + templateDataAnnotation.getElementName() + "'.", e);
        }
        return templateData;
    }

    private static RegisterForReflectionAnnotation createRegisterForReflection(IAnnotation registerForReflectionAnnotation, ITypeResolver typeResolver) {
        RegisterForReflectionAnnotation registerForReflection = new RegisterForReflectionAnnotation();
        try {
            IMemberValuePair[] iMemberValuePairArray = registerForReflectionAnnotation.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair pair = iMemberValuePairArray[n2];
                switch (pair.getMemberName()) {
                    case "methods": {
                        Boolean methods = AnnotationUtils.getValueAsBoolean(pair);
                        if (!Boolean.FALSE.equals(methods)) break;
                        registerForReflection.setMethods(methods);
                        break;
                    }
                    case "fields": {
                        Boolean fields = AnnotationUtils.getValueAsBoolean(pair);
                        if (!Boolean.FALSE.equals(fields)) break;
                        registerForReflection.setFields(fields);
                        break;
                    }
                    case "targets": {
                        Object[] values;
                        ArrayList<String> targets = null;
                        if (pair.getValue() != null && pair.getValue() instanceof Object[] && (values = AnnotationUtils.getValueAsArray(pair)) != null && values.length > 0) {
                            targets = new ArrayList<String>(values.length);
                            int i = 0;
                            while (i < values.length) {
                                String target;
                                String string = target = values[i] != null ? values[i].toString() : null;
                                if (target != null) {
                                    target = QuteReflectionAnnotationUtils.resolveTarget(target, typeResolver);
                                    targets.add(target);
                                }
                                ++i;
                            }
                        }
                        registerForReflection.setTargets(targets);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting member values of '" + registerForReflectionAnnotation.getElementName() + "'.", e);
        }
        return registerForReflection;
    }

    private static String resolveTarget(String target, ITypeResolver typeResolver) {
        return typeResolver.resolveTypeSignature("Q" + target + ";", null);
    }
}

