/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdtls.ext.core.parser;

import com.microsoft.jdtls.ext.core.JdtlsExtActivator;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.JDTUtils;

public class ProjectResolver {
    private static final Map<String, CachedDependencyInfo> dependencyCache = new ConcurrentHashMap<String, CachedDependencyInfo>();
    private static volatile boolean listenersRegistered = false;
    private static final Object listenerLock = new Object();
    private static final IElementChangedListener javaElementListener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            IJavaElementDelta delta = event.getDelta();
            this.processDelta(delta);
        }

        private void processDelta(IJavaElementDelta delta) {
            IJavaElement element = delta.getElement();
            int flags = delta.getFlags();
            if (((flags & 0x20000) != 0 || (flags & 0x200000) != 0) && element instanceof IJavaProject) {
                IJavaProject project = (IJavaProject)element;
                ProjectResolver.invalidateCache(project.getProject());
            }
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                this.processDelta(child);
                ++n2;
            }
        }
    };
    private static final IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() != 1) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IProject project;
                        String fileName;
                        IResource resource = delta.getResource();
                        if (resource.getType() == 1 && ("pom.xml".equals(fileName = resource.getName()) || "build.gradle".equals(fileName) || "build.gradle.kts".equals(fileName) || ".classpath".equals(fileName) || ".project".equals(fileName)) && (project = resource.getProject()) != null) {
                            ProjectResolver.invalidateCache(project);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                JdtlsExtActivator.logException("Error processing resource delta", e);
            }
        }
    };
    private static final String KEY_BUILD_TOOL = "buildTool";
    private static final String KEY_PROJECT_NAME = "projectName";
    private static final String KEY_PROJECT_LOCATION = "projectLocation";
    private static final String KEY_JAVA_VERSION = "javaVersion";
    private static final String KEY_SOURCE_COMPATIBILITY = "sourceCompatibility";
    private static final String KEY_TARGET_COMPATIBILITY = "targetCompatibility";
    private static final String KEY_MODULE_NAME = "moduleName";
    private static final String KEY_TOTAL_LIBRARIES = "totalLibraries";
    private static final String KEY_TOTAL_PROJECT_REFS = "totalProjectReferences";
    private static final String KEY_JRE_CONTAINER = "jreContainer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureListenersRegistered() {
        if (!listenersRegistered) {
            Object object = listenerLock;
            synchronized (object) {
                if (!listenersRegistered) {
                    try {
                        JavaCore.addElementChangedListener((IElementChangedListener)javaElementListener, (int)1);
                        ResourcesPlugin.getWorkspace().addResourceChangeListener(resourceListener, 1);
                        listenersRegistered = true;
                        JdtlsExtActivator.logInfo("ProjectResolver cache listeners registered successfully");
                    }
                    catch (Exception e) {
                        JdtlsExtActivator.logException("Failed to register ProjectResolver listeners", e);
                    }
                }
            }
        }
    }

    private static void invalidateCache(IProject project) {
        if (project == null) {
            return;
        }
        String projectUri = JDTUtils.getFileURI((IResource)project);
        if (dependencyCache.remove(projectUri) != null) {
            JdtlsExtActivator.logInfo("Cache invalidated for project: " + project.getName());
        }
    }

    public static void clearCache() {
        dependencyCache.clear();
        JdtlsExtActivator.logInfo("ProjectResolver cache cleared");
    }

    private static long calculateClasspathHash(IJavaProject javaProject) {
        try {
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            long hash = 0L;
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                hash = hash * 31L + (long)entry.getPath().toString().hashCode();
                hash = hash * 31L + (long)entry.getEntryKind();
                ++n2;
            }
            return hash;
        }
        catch (JavaModelException e) {
            return 0L;
        }
    }

    public static List<DependencyInfo> resolveProjectDependencies(String fileUri, IProgressMonitor monitor) {
        ProjectResolver.ensureListenersRegistered();
        ArrayList<DependencyInfo> result = new ArrayList<DependencyInfo>();
        try {
            URI uri = JDTUtils.toURI((String)fileUri);
            IResource resource = JDTUtils.findResource((URI)uri, arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).findFilesForLocationURI(arg_0));
            if (resource == null) {
                return result;
            }
            IProject project = resource.getProject();
            if (project == null || !project.isAccessible()) {
                return result;
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject == null || !javaProject.exists()) {
                return result;
            }
            String cacheKey = JDTUtils.getFileURI((IResource)project);
            long currentClasspathHash = ProjectResolver.calculateClasspathHash(javaProject);
            CachedDependencyInfo cached = dependencyCache.get(cacheKey);
            if (cached != null && cached.isValid() && cached.classpathHash == currentClasspathHash) {
                JdtlsExtActivator.logInfo("Using cached dependencies for project: " + project.getName());
                return new ArrayList<DependencyInfo>(cached.dependencies);
            }
            ProjectResolver.addBasicProjectInfo(result, project, javaProject);
            ProjectResolver.processClasspathEntries(result, javaProject, monitor);
            ProjectResolver.detectBuildTool(result, project);
            dependencyCache.put(cacheKey, new CachedDependencyInfo(result, currentClasspathHash));
        }
        catch (Exception e) {
            JdtlsExtActivator.logException("Error in resolveProjectDependencies", e);
        }
        return result;
    }

    private static void addBasicProjectInfo(List<DependencyInfo> result, IProject project, IJavaProject javaProject) {
        result.add(new DependencyInfo(KEY_PROJECT_NAME, project.getName()));
        ProjectResolver.addIfNotNull(result, KEY_PROJECT_LOCATION, JDTUtils.getFileURI((IResource)project));
        ProjectResolver.addIfNotNull(result, KEY_JAVA_VERSION, javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true));
        ProjectResolver.addIfNotNull(result, KEY_SOURCE_COMPATIBILITY, javaProject.getOption("org.eclipse.jdt.core.compiler.source", true));
        ProjectResolver.addIfNotNull(result, KEY_TARGET_COMPATIBILITY, javaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true));
        ProjectResolver.addIfNotNull(result, KEY_MODULE_NAME, ProjectResolver.getModuleName(javaProject));
    }

    private static void processClasspathEntries(List<DependencyInfo> result, IJavaProject javaProject, IProgressMonitor monitor) {
        try {
            IClasspathEntry[] classpathEntries = javaProject.getResolvedClasspath(true);
            int libCount = 0;
            int projectRefCount = 0;
            IClasspathEntry[] iClasspathEntryArray = classpathEntries;
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (monitor.isCanceled()) break;
                switch (entry.getEntryKind()) {
                    case 1: {
                        ProjectResolver.processLibraryEntry(result, entry, ++libCount);
                        break;
                    }
                    case 2: {
                        ProjectResolver.processProjectEntry(result, entry, ++projectRefCount);
                        break;
                    }
                    case 5: {
                        ProjectResolver.processContainerEntry(result, entry);
                    }
                }
                ++n2;
            }
            result.add(new DependencyInfo(KEY_TOTAL_LIBRARIES, String.valueOf(libCount)));
            result.add(new DependencyInfo(KEY_TOTAL_PROJECT_REFS, String.valueOf(projectRefCount)));
        }
        catch (JavaModelException e) {
            JdtlsExtActivator.logException("Error getting classpath entries", e);
        }
    }

    private static void processLibraryEntry(List<DependencyInfo> result, IClasspathEntry entry, int libCount) {
        IPath libPath = entry.getPath();
        if (libPath != null) {
            result.add(new DependencyInfo("library_" + libCount, libPath.lastSegment()));
        }
    }

    private static void processProjectEntry(List<DependencyInfo> result, IClasspathEntry entry, int projectRefCount) {
        IPath projectRefPath = entry.getPath();
        if (projectRefPath != null) {
            result.add(new DependencyInfo("projectReference_" + projectRefCount, projectRefPath.lastSegment()));
        }
    }

    private static void processContainerEntry(List<DependencyInfo> result, IClasspathEntry entry) {
        String containerPath = entry.getPath().toString();
        if (containerPath.contains("JRE_CONTAINER")) {
            try {
                String vmInstallName = JavaRuntime.getVMInstallName((IPath)entry.getPath());
                ProjectResolver.addIfNotNull(result, KEY_JRE_CONTAINER, vmInstallName);
            }
            catch (Exception e) {
                if (containerPath.contains("JavaSE-")) {
                    int startIdx = containerPath.lastIndexOf("JavaSE-");
                    String version = containerPath.substring(startIdx);
                    if (version.contains("/")) {
                        version = version.substring(0, version.indexOf("/"));
                    }
                    result.add(new DependencyInfo(KEY_JRE_CONTAINER, version));
                }
            }
        } else if (containerPath.contains("MAVEN")) {
            result.add(new DependencyInfo(KEY_BUILD_TOOL, "Maven"));
        } else if (containerPath.contains("GRADLE")) {
            result.add(new DependencyInfo(KEY_BUILD_TOOL, "Gradle"));
        }
    }

    private static void detectBuildTool(List<DependencyInfo> result, IProject project) {
        if (ProjectResolver.hasBuildToolInfo(result)) {
            return;
        }
        if (project.getFile("pom.xml").exists()) {
            result.add(new DependencyInfo(KEY_BUILD_TOOL, "Maven"));
        } else if (project.getFile("build.gradle").exists() || project.getFile("build.gradle.kts").exists()) {
            result.add(new DependencyInfo(KEY_BUILD_TOOL, "Gradle"));
        }
    }

    private static String getModuleName(IJavaProject project) {
        if (project == null || !JavaRuntime.isModularProject((IJavaProject)project)) {
            return null;
        }
        try {
            IModuleDescription module = project.getModuleDescription();
            return module != null ? module.getElementName() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void addIfNotNull(List<DependencyInfo> result, String key, String value) {
        if (value != null) {
            result.add(new DependencyInfo(key, value));
        }
    }

    private static boolean hasBuildToolInfo(List<DependencyInfo> result) {
        for (DependencyInfo info : result) {
            if (!KEY_BUILD_TOOL.equals(info.key)) continue;
            return true;
        }
        return false;
    }

    private static class CachedDependencyInfo {
        final List<DependencyInfo> dependencies;
        final long timestamp;
        final long classpathHash;

        CachedDependencyInfo(List<DependencyInfo> dependencies, long classpathHash) {
            this.dependencies = new ArrayList<DependencyInfo>(dependencies);
            this.timestamp = System.currentTimeMillis();
            this.classpathHash = classpathHash;
        }

        boolean isValid() {
            return System.currentTimeMillis() - this.timestamp < 300000L;
        }
    }

    public static class DependencyInfo {
        public String key;
        public String value;

        public DependencyInfo(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

