/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.builditems.java;

import com.redhat.microprofile.jdt.internal.quarkus.builditems.QuarkusBuildItemErrorCode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.java.validators.JavaASTValidator;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class QuarkusBuildItemASTVisitor
extends JavaASTValidator {
    private static final String INVALID_MODIFIER = "BuildItem class %2$s%1$s%2$s must either be declared final or abstract";

    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType((IJavaProject)javaProject, (String)"io.quarkus.builder.item.BuildItem") != null;
    }

    public boolean visit(TypeDeclaration node) {
        ITypeBinding typeBinding = node.resolveBinding();
        if (QuarkusBuildItemASTVisitor.isBuildItem(typeBinding)) {
            this.validateBuildItem(node, typeBinding, super.getContext());
        }
        return super.visit(node);
    }

    private static boolean isBuildItem(ITypeBinding typeBinding) {
        return typeBinding != null && QuarkusBuildItemASTVisitor.extendsClass(typeBinding, "io.quarkus.builder.item.BuildItem");
    }

    private void validateBuildItem(TypeDeclaration typeDeclaration, ITypeBinding typeBinding, JavaDiagnosticsContext context) {
        if (QuarkusBuildItemASTVisitor.isValidBuildItem(typeDeclaration)) {
            return;
        }
        super.addDiagnostic(QuarkusBuildItemASTVisitor.createDiagnosticMessage(typeBinding, context.getDocumentFormat()), "quarkus", (ASTNode)typeDeclaration.getName(), (IJavaErrorCode)QuarkusBuildItemErrorCode.InvalidModifierBuildItem, DiagnosticSeverity.Error);
    }

    private static boolean isValidBuildItem(TypeDeclaration typeDeclaration) {
        int flags = typeDeclaration.getModifiers();
        return Modifier.isAbstract((int)flags) || Modifier.isFinal((int)flags);
    }

    private static String createDiagnosticMessage(ITypeBinding typeBinding, DocumentFormat documentFormat) {
        String quote = DocumentFormat.Markdown.equals((Object)documentFormat) ? "`" : "'";
        return String.format(INVALID_MODIFIER, typeBinding.getQualifiedName(), quote);
    }

    private static boolean extendsClass(ITypeBinding typeBinding, String classNameToCheck) {
        ITypeBinding superClass = typeBinding.getSuperclass();
        while (superClass != null) {
            if (superClass.getQualifiedName().equals(classNameToCheck)) {
                return true;
            }
            superClass = superClass.getSuperclass();
        }
        return false;
    }
}

