/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.cache.properties;

import com.redhat.microprofile.jdt.internal.quarkus.providers.QuarkusSearchContext;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.commons.metadata.ItemHint;
import org.eclipse.lsp4mp.commons.metadata.ValueHint;
import org.eclipse.lsp4mp.jdt.core.AbstractAnnotationTypeReferencePropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;

public class QuarkusCacheResultProvider
extends AbstractAnnotationTypeReferencePropertiesProvider {
    private static final String QUARKUS_CACHE_EXTENSION = "quarkus-cache";
    private static final String[] ANNOTATION_NAMES = new String[]{"io.quarkus.cache.CacheResult"};
    private static final String QUARKUS_CACHE_NAME = "${quarkus.cache.name}";

    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    public void beginSearch(SearchContext context, IProgressMonitor monitor) {
        QuarkusSearchContext quarkusContext = QuarkusSearchContext.getQuarkusContext(context);
        quarkusContext.registerPropertyMapKeyReplacer(QUARKUS_CACHE_EXTENSION, (baseKey, keyIndex) -> QUARKUS_CACHE_NAME);
    }

    protected void processAnnotation(IJavaElement javaElement, IAnnotation cacheResultAnnotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        String cacheName = AnnotationUtils.getAnnotationMemberValue((IAnnotation)cacheResultAnnotation, (String)"cacheName");
        if (!StringUtils.isBlank((CharSequence)cacheName)) {
            IPropertiesCollector collector = context.getCollector();
            ItemHint itemHint = collector.getItemHint(QUARKUS_CACHE_NAME);
            itemHint.setSource(Boolean.TRUE);
            ValueHint value = new ValueHint();
            value.setValue(cacheName);
            if (!itemHint.getValues().contains(value)) {
                itemHint.getValues().add(value);
            }
        }
    }
}

