/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.core.java;

import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.java.validators.JavaASTValidator;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class QuarkusConfigMappingASTVisitor
extends JavaASTValidator {
    private static final Logger LOGGER = Logger.getLogger(QuarkusConfigMappingASTVisitor.class.getName());
    private static final String EXPECTED_INTERFACE_ERROR = "The @ConfigMapping annotation can only be placed in interfaces, class `{0}` is a class";

    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType((IJavaProject)javaProject, (String)"io.smallrye.config.ConfigMapping") != null;
    }

    public boolean visit(TypeDeclaration node) {
        try {
            List modifiers = node.modifiers();
            for (Object modifier : modifiers) {
                Annotation annotation;
                if (!(modifier instanceof Annotation) || !AnnotationUtils.isMatchAnnotation((Annotation)(annotation = (Annotation)modifier), (String)"io.smallrye.config.ConfigMapping")) continue;
                this.validateConfigMappingAnnotation(node, annotation);
            }
        }
        catch (JavaModelException javaModelException) {
            LOGGER.log(Level.WARNING, "An exception occurred when attempting to validate the annotation marked type");
        }
        super.visit(node);
        return true;
    }

    private void validateConfigMappingAnnotation(TypeDeclaration node, Annotation annotation) throws JavaModelException {
        if (!node.isInterface()) {
            super.addDiagnostic(MessageFormat.format(EXPECTED_INTERFACE_ERROR, node.getName()), "quarkus", (ASTNode)annotation, null, DiagnosticSeverity.Error);
        }
    }
}

