/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.core.properties;

import com.redhat.microprofile.jdt.internal.quarkus.core.properties.NamingStrategy;
import com.redhat.microprofile.jdt.quarkus.JDTQuarkusUtils;
import io.quarkus.runtime.util.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.lsp4mp.commons.metadata.ItemMetadata;
import org.eclipse.lsp4mp.jdt.core.AbstractAnnotationTypeReferencePropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class QuarkusConfigMappingProvider
extends AbstractAnnotationTypeReferencePropertiesProvider {
    private static final Logger LOGGER = Logger.getLogger(QuarkusConfigMappingProvider.class.getName());
    private static final String[] ANNOTATION_NAMES = new String[]{"io.smallrye.config.ConfigMapping"};

    protected String[] getAnnotationNames() {
        return ANNOTATION_NAMES;
    }

    protected void processAnnotation(IJavaElement javaElement, IAnnotation annotation, String annotationName, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        this.processConfigMapping(javaElement, annotation, context.getCollector(), monitor);
    }

    private void processConfigMapping(IJavaElement javaElement, IAnnotation configMappingAnnotation, IPropertiesCollector collector, IProgressMonitor monitor) throws JavaModelException {
        if (javaElement.getElementType() != 7) {
            return;
        }
        IType configMappingType = (IType)javaElement;
        if (!configMappingType.isInterface()) {
            return;
        }
        IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)javaElement.getAncestor(3);
        String location = packageRoot.getPath().toString();
        String extensionName = JDTQuarkusUtils.getExtensionName(location);
        String prefix = QuarkusConfigMappingProvider.getPrefixFromAnnotation(configMappingAnnotation);
        if (prefix == null || prefix.trim().isEmpty()) {
            return;
        }
        Set<IType> allInterfaces = QuarkusConfigMappingProvider.findInterfaces(configMappingType, monitor);
        for (IType configMappingInterface : allInterfaces) {
            this.populateConfigObject(configMappingInterface, prefix, extensionName, new HashSet<IType>(), configMappingAnnotation, collector, monitor);
        }
    }

    private static Set<IType> findInterfaces(IType type, IProgressMonitor progressMonitor) throws JavaModelException {
        if (type == null || type.getFullyQualifiedName() == null || type.getFullyQualifiedName().startsWith("java")) {
            return Collections.emptySet();
        }
        HashSet<IType> result = new HashSet<IType>();
        result.add(type);
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(progressMonitor);
        IType[] allSuperInterfaces = typeHierarchy.getAllSuperInterfaces(type);
        result.addAll(Arrays.asList(allSuperInterfaces));
        return result;
    }

    private void populateConfigObject(IType configMappingType, String prefixStr, String extensionName, Set<IType> typesAlreadyProcessed, IAnnotation configMappingAnnotation, IPropertiesCollector collector, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] elements;
        if (typesAlreadyProcessed.contains(configMappingType)) {
            return;
        }
        typesAlreadyProcessed.add(configMappingType);
        IJavaElement[] iJavaElementArray = elements = configMappingType.getChildren();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block16: {
                String resolvedTypeSignature;
                String returnTypeSignature;
                IMethod method;
                block17: {
                    IJavaElement child = iJavaElementArray[n2];
                    if (child.getElementType() != 9 || Flags.isDefaultMethod((int)(method = (IMethod)child).getFlags()) || method.getNumberOfParameters() > 0 || "void".equals(method.getReturnType()) || "<clinit>".equals(method.getElementName())) break block16;
                    returnTypeSignature = method.getReturnType();
                    resolvedTypeSignature = JDTTypeUtils.getResolvedResultTypeName((IMethod)method);
                    if (!JDTTypeUtils.isOptional((String)resolvedTypeSignature)) break block17;
                    String[] typeArguments = Signature.getTypeArguments((String)returnTypeSignature);
                    if (typeArguments.length < 1) break block16;
                    returnTypeSignature = typeArguments[0];
                    resolvedTypeSignature = JavaModelUtil.getResolvedTypeName((String)returnTypeSignature, (IType)configMappingType);
                }
                IType returnType = JDTTypeUtils.findType((IJavaProject)method.getJavaProject(), (String)resolvedTypeSignature);
                boolean leafType = QuarkusConfigMappingProvider.isLeafType(returnType, resolvedTypeSignature);
                String defaultValue = QuarkusConfigMappingProvider.getWithDefault((IMember)method);
                Object propertyName = this.getPropertyName((IMember)method, prefixStr, configMappingAnnotation);
                String type = JDTTypeUtils.getPropertyType((IType)returnType, (String)resolvedTypeSignature);
                String description = null;
                String sourceType = JDTTypeUtils.getSourceType((IMember)method);
                String sourceMethod = JDTTypeUtils.getSourceMethod((IMethod)method);
                IType enclosedType = JDTTypeUtils.getEnclosedType((IType)returnType, (String)resolvedTypeSignature, (IJavaProject)method.getJavaProject());
                super.updateHint(collector, enclosedType);
                if (!leafType) {
                    if (QuarkusConfigMappingProvider.isMap(returnType, resolvedTypeSignature)) {
                        propertyName = (String)propertyName + ".{*}";
                        typeArguments = Signature.getTypeArguments((String)returnTypeSignature);
                        if (typeArguments.length > 1) {
                            genericTypeName = typeArguments[1];
                            resolvedTypeSignature = JavaModelUtil.getResolvedTypeName((String)genericTypeName, (IType)configMappingType);
                            returnType = JDTTypeUtils.findType((IJavaProject)method.getJavaProject(), (String)resolvedTypeSignature);
                            leafType = QuarkusConfigMappingProvider.isLeafType(returnType, resolvedTypeSignature);
                        } else {
                            leafType = false;
                        }
                    } else if (QuarkusConfigMappingProvider.isCollection(returnType, resolvedTypeSignature)) {
                        propertyName = (String)propertyName + "[*]";
                        typeArguments = Signature.getTypeArguments((String)returnTypeSignature);
                        if (typeArguments.length > 0) {
                            genericTypeName = typeArguments[0];
                            resolvedTypeSignature = JavaModelUtil.getResolvedTypeName((String)genericTypeName, (IType)configMappingType);
                            returnType = JDTTypeUtils.findType((IJavaProject)method.getJavaProject(), (String)resolvedTypeSignature);
                            leafType = QuarkusConfigMappingProvider.isLeafType(returnType, resolvedTypeSignature);
                        } else {
                            leafType = false;
                        }
                    }
                }
                if (leafType) {
                    ItemMetadata metadata = super.addItemMetadata(collector, (String)propertyName, type, description, sourceType, null, sourceMethod, defaultValue, extensionName, method.isBinary());
                    JDTQuarkusUtils.updateConverterKinds(metadata, (IMember)method, enclosedType);
                } else {
                    Set<IType> allInterfaces = QuarkusConfigMappingProvider.findInterfaces(returnType, monitor);
                    for (IType configMappingInterface : allInterfaces) {
                        this.populateConfigObject(configMappingInterface, (String)propertyName, extensionName, typesAlreadyProcessed, configMappingAnnotation, collector, monitor);
                    }
                }
            }
            ++n2;
        }
    }

    private static boolean isLeafType(IType returnType, String resolvedTypeSignature) throws JavaModelException {
        if (returnType != null) {
            return !returnType.isInterface();
        }
        return !QuarkusConfigMappingProvider.isMap(returnType, resolvedTypeSignature) && !QuarkusConfigMappingProvider.isCollection(returnType, resolvedTypeSignature);
    }

    private static boolean isMap(IType type, String typeName) {
        return typeName.startsWith("java.util.Map") || typeName.startsWith("java.util.SortedMap");
    }

    private static boolean isCollection(IType type, String typeName) {
        return typeName.startsWith("java.util.Collection") || typeName.startsWith("java.util.Set") || typeName.startsWith("java.util.SortedSet") || typeName.startsWith("java.util.List");
    }

    private String getPropertyName(IMember member, String prefix, IAnnotation configMappingAnnotation) throws JavaModelException {
        if (AnnotationUtils.hasAnnotation((IAnnotatable)((IAnnotatable)member), (String)"io.smallrye.config.WithParentName")) {
            return prefix;
        }
        return prefix + "." + QuarkusConfigMappingProvider.convertName(member, configMappingAnnotation);
    }

    private static String convertName(IMember member, IAnnotation configMappingAnnotation) throws JavaModelException {
        String name;
        IAnnotation withNameAnnotation = AnnotationUtils.getFirstAnnotation((IAnnotatable)((IAnnotatable)member), (String[])new String[]{"io.smallrye.config.WithName"});
        if (withNameAnnotation != null && StringUtils.isNotEmpty((CharSequence)(name = AnnotationUtils.getAnnotationMemberValue((IAnnotation)withNameAnnotation, (String)"value")))) {
            return name;
        }
        name = member.getElementName();
        NamingStrategy namingStrategy = QuarkusConfigMappingProvider.getNamingStrategy(configMappingAnnotation);
        if (namingStrategy != null) {
            switch (namingStrategy) {
                case VERBATIM: {
                    return name;
                }
                case SNAKE_CASE: {
                    return QuarkusConfigMappingProvider.snake(name);
                }
            }
            return StringUtil.hyphenate((String)name);
        }
        return StringUtil.hyphenate((String)name);
    }

    private static NamingStrategy getNamingStrategy(IAnnotation configMappingAnnotation) throws JavaModelException {
        String namingStrategy = AnnotationUtils.getAnnotationMemberValue((IAnnotation)configMappingAnnotation, (String)"namingStrategy");
        if (namingStrategy != null) {
            try {
                return NamingStrategy.valueOf(namingStrategy.toUpperCase());
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private static String getWithDefault(IMember member) {
        try {
            String defaultValue;
            IAnnotation withDefaultAnnotation = AnnotationUtils.getFirstAnnotation((IAnnotatable)((IAnnotatable)member), (String[])new String[]{"io.smallrye.config.WithDefault"});
            if (withDefaultAnnotation != null && StringUtils.isNotEmpty((CharSequence)(defaultValue = AnnotationUtils.getAnnotationMemberValue((IAnnotation)withDefaultAnnotation, (String)"value")))) {
                return defaultValue;
            }
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while getting @WithDefault value", e);
        }
        return null;
    }

    private static String getPrefixFromAnnotation(IAnnotation configMappingAnnotation) throws JavaModelException {
        String value = AnnotationUtils.getAnnotationMemberValue((IAnnotation)configMappingAnnotation, (String)"prefix");
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }

    private static String snake(String orig) {
        return StringUtil.join((String)"_", (Iterator)StringUtil.lowerCase((Iterator)StringUtil.camelHumpsIterator((String)orig)));
    }
}

