/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.jaxrs.java;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4mp.jdt.core.java.codelens.IJavaCodeLensParticipant;
import org.eclipse.lsp4mp.jdt.core.java.codelens.JavaCodeLensContext;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsContext;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProject;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProjectManager;

public class QuarkusJaxRsCodeLensParticipant
implements IJavaCodeLensParticipant {
    private static final String QUARKUS_DEV_HTTP_PORT = "%dev.quarkus.http.port";
    private static final String QUARKUS_HTTP_PORT = "quarkus.http.port";
    private static final String QUARKUS_DEV_HTTP_ROOT_PATH = "%dev.quarkus.http.root-path";
    private static final String QUARKUS_HTTP_ROOT_PATH = "quarkus.http.root-path";
    private static final String QUARKUS_REST_PATH = "quarkus.rest.path";
    private static final String QUARKUS_DEV_REST_PATH = "%dev.quarkus.rest.path";

    public void beginCodeLens(JavaCodeLensContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        JDTMicroProfileProject mpProject = JDTMicroProfileProjectManager.getInstance().getJDTMicroProfileProject(javaProject);
        int serverPort = mpProject.getPropertyAsInteger(QUARKUS_HTTP_PORT, Integer.valueOf(8080));
        int devServerPort = mpProject.getPropertyAsInteger(QUARKUS_DEV_HTTP_PORT, Integer.valueOf(serverPort));
        JaxRsContext.getJaxRsContext((JavaCodeLensContext)context).setServerPort(devServerPort);
        String httpRootPath = mpProject.getProperty(QUARKUS_HTTP_ROOT_PATH);
        String devHttpRootPath = mpProject.getProperty(QUARKUS_DEV_HTTP_ROOT_PATH, httpRootPath);
        JaxRsContext.getJaxRsContext((JavaCodeLensContext)context).setRootPath(devHttpRootPath);
        String restPath = mpProject.getProperty(QUARKUS_REST_PATH);
        String devRestPath = mpProject.getProperty(QUARKUS_DEV_REST_PATH, restPath);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{devRestPath})) {
            JaxRsContext.getJaxRsContext((JavaCodeLensContext)context).setApplicationPath(devRestPath);
        }
    }

    public List<CodeLens> collectCodeLens(JavaCodeLensContext context, IProgressMonitor monitor) throws CoreException {
        return null;
    }
}

