/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.kubernetes.properties;

import com.redhat.microprofile.jdt.internal.quarkus.providers.QuarkusContext;
import io.quarkus.runtime.util.StringUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.jdt.core.AbstractTypeDeclarationPropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.BuildingScopeContext;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class QuarkusKubernetesProvider
extends AbstractTypeDeclarationPropertiesProvider {
    private static final String S2I_PREFIX = "s2i";
    private static final String DOCKER_PREFIX = "docker";
    private static final String OPENSHIFT_PREFIX = "openshift";
    private static final String KUBERNETES_PREFIX = "kubernetes";
    private static final String KUBERNETES_APPLICATION_ANNOTATION = "io.dekorate.kubernetes.annotation.KubernetesApplication";
    private static final String OPENSHIFT_APPLICATION_ANNOTATION = "io.dekorate.openshift.annotation.OpenshiftApplication";
    private static final String S2I_BUILD_ANNOTATION = "io.dekorate.s2i.annotation.S2iBuild";
    private static final String DOCKER_BUILD_ANNOTATION = "io.dekorate.docker.annotation.DockerBuild";

    protected String[] getTypeNames() {
        return new String[]{KUBERNETES_APPLICATION_ANNOTATION, DOCKER_BUILD_ANNOTATION, OPENSHIFT_APPLICATION_ANNOTATION, S2I_BUILD_ANNOTATION};
    }

    public void beginBuildingScope(BuildingScopeContext context, IProgressMonitor monitor) {
        QuarkusContext quarkusContext = QuarkusContext.getQuarkusContext(context);
        quarkusContext.collectDependenciesFor("quarkus-kubernetes-deployment");
        quarkusContext.collectDependenciesFor("quarkus-openshift-deployment");
    }

    protected SearchPattern createSearchPattern(String annotationName) {
        return QuarkusKubernetesProvider.createAnnotationTypeDeclarationSearchPattern((String)annotationName);
    }

    protected void processClass(IType configType, String className, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        block10: {
            String configPrefix = QuarkusKubernetesProvider.getConfigPrefix(className);
            if (configPrefix == null) break block10;
            IPropertiesCollector collector = context.getCollector();
            IJDTUtils utils = context.getUtils();
            DocumentFormat documentFormat = context.getDocumentFormat();
            this.collectProperties(configPrefix, configType, collector, utils, documentFormat, monitor);
            switch (configPrefix) {
                case "kubernetes": {
                    super.addItemMetadata(collector, "kubernetes.deployment.target", "java.lang.String", "To enable the generation of OpenShift resources, you need to include OpenShift in the target platforms: `kubernetes.deployment.target=openshift`." + System.lineSeparator() + "If you need to generate resources for both platforms (vanilla Kubernetes and OpenShift), then you need to include both (coma separated)." + System.lineSeparator() + "`kubernetes.deployment.target=kubernetes, openshift`.", null, null, null, KUBERNETES_PREFIX, null, true);
                    super.addItemMetadata(collector, "kubernetes.registry", "java.lang.String", "Specify the docker registry.", null, null, null, null, null, true);
                    break;
                }
                case "openshift": {
                    super.addItemMetadata(collector, "openshift.registry", "java.lang.String", "Specify the docker registry.", null, null, null, null, null, true);
                }
            }
        }
    }

    private void collectProperties(String prefix, IType configType, IPropertiesCollector collector, IJDTUtils utils, DocumentFormat documentFormat, IProgressMonitor monitor) throws JavaModelException {
        IMethod[] methods;
        String sourceType = configType.getFullyQualifiedName();
        IMethod[] iMethodArray = methods = configType.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isArray;
            IMethod method = iMethodArray[n2];
            String resultTypeName = JDTTypeUtils.getResolvedResultTypeName((IMethod)method);
            IType resultTypeClass = JDTTypeUtils.findType((IJavaProject)method.getJavaProject(), (String)resultTypeName);
            String methodName = method.getElementName();
            String propertyName = prefix + "." + StringUtil.hyphenate((String)methodName);
            boolean bl = isArray = Signature.getArrayCount((String)method.getReturnType()) > 0;
            if (isArray) {
                propertyName = propertyName + "[*]";
            }
            if (JDTTypeUtils.isSimpleFieldType((IType)resultTypeClass, (String)resultTypeName)) {
                String type = JDTTypeUtils.getPropertyType((IType)resultTypeClass, (String)resultTypeName);
                String description = utils.getJavadoc((IMember)method, documentFormat);
                String sourceMethod = JDTTypeUtils.getSourceMethod((IMethod)method);
                String defaultValue = JDTTypeUtils.getDefaultValue((IMethod)method);
                String extensionName = null;
                IType enclosedType = JDTTypeUtils.getEnclosedType((IType)resultTypeClass, (String)resultTypeName, (IJavaProject)method.getJavaProject());
                super.updateHint(collector, enclosedType);
                super.addItemMetadata(collector, propertyName, type, description, sourceType, null, sourceMethod, defaultValue, extensionName, method.isBinary());
            } else {
                this.collectProperties(propertyName, resultTypeClass, collector, utils, documentFormat, monitor);
            }
            ++n2;
        }
    }

    private static String getConfigPrefix(String configClassName) {
        switch (configClassName) {
            case "io.dekorate.kubernetes.annotation.KubernetesApplication": {
                return KUBERNETES_PREFIX;
            }
            case "io.dekorate.openshift.annotation.OpenshiftApplication": {
                return OPENSHIFT_PREFIX;
            }
            case "io.dekorate.docker.annotation.DockerBuild": {
                return DOCKER_PREFIX;
            }
            case "io.dekorate.s2i.annotation.S2iBuild": {
                return S2I_PREFIX;
            }
        }
        return null;
    }
}

