/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsp4mp.jdt.core.SearchContext;

public class QuarkusSearchContext {
    private static final String QUARKUS_CONTEXT_KEY = QuarkusSearchContext.class.getName();
    private final Map<String, PropertyMapKeyReplacer> propertyMapKeyReplacers = new HashMap<String, PropertyMapKeyReplacer>();

    private QuarkusSearchContext() {
    }

    public static QuarkusSearchContext getQuarkusContext(SearchContext context) {
        QuarkusSearchContext quarkusContext = (QuarkusSearchContext)context.get(QUARKUS_CONTEXT_KEY);
        if (quarkusContext == null) {
            quarkusContext = new QuarkusSearchContext();
            context.put(QUARKUS_CONTEXT_KEY, (Object)quarkusContext);
        }
        return quarkusContext;
    }

    public void registerPropertyMapKeyReplacer(String extensionName, PropertyMapKeyReplacer replacer) {
        this.propertyMapKeyReplacers.put(extensionName, replacer);
    }

    public String getPropertyMapKey(String extensionName, String baseKey, int keyIndex) {
        PropertyMapKeyReplacer replacer = this.propertyMapKeyReplacers.get(extensionName);
        return replacer != null ? replacer.replace(baseKey, keyIndex) : "{*}";
    }

    public static interface PropertyMapKeyReplacer {
        public String replace(String var1, int var2);
    }
}

