/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.renarde.java;

import com.redhat.microprofile.jdt.internal.quarkus.renarde.java.RenardeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.jaxrs.HttpMethod;
import org.eclipse.lsp4mp.jdt.core.jaxrs.IJaxRsInfoProvider;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsConstants;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsContext;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsMethodInfo;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsUtils;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class RenardeJaxRsInfoProvider
implements IJaxRsInfoProvider {
    private static final Logger LOGGER = Logger.getLogger(RenardeJaxRsInfoProvider.class.getName());

    public boolean canProvideJaxRsMethodInfoForClass(ITypeRoot typeRoot, IProgressMonitor monitor) {
        return RenardeUtils.isControllerClass(typeRoot.getJavaProject(), typeRoot, monitor);
    }

    public Set<ITypeRoot> getAllJaxRsClasses(IJavaProject javaProject, IProgressMonitor monitor) {
        return RenardeUtils.getAllControllerClasses(javaProject, monitor);
    }

    public List<JaxRsMethodInfo> getJaxRsMethodInfo(ITypeRoot typeRoot, JaxRsContext jaxrsContext, IJDTUtils utils, IProgressMonitor monitor) {
        try {
            IType type = typeRoot.findPrimaryType();
            String pathSegment = JaxRsUtils.getJaxRsPathValue((IAnnotatable)type);
            String typeSegment = type.getElementName();
            ArrayList<JaxRsMethodInfo> methodInfos = new ArrayList<JaxRsMethodInfo>();
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (!utils.isHiddenGeneratedElement((IJavaElement)method) && !JDTTypeUtils.overlaps((ISourceRange)type.getNameRange(), (ISourceRange)method.getNameRange()) && Flags.isPublic((int)method.getFlags())) {
                    String methodSegment = JaxRsUtils.getJaxRsPathValue((IAnnotatable)method);
                    if (methodSegment == null) {
                        methodSegment = method.getElementName();
                    }
                    String path = pathSegment == null ? (methodSegment.startsWith("/") ? methodSegment : JaxRsUtils.buildURL((String[])new String[]{typeSegment, methodSegment})) : JaxRsUtils.buildURL((String[])new String[]{pathSegment, methodSegment});
                    String url = JaxRsUtils.buildURL((String[])new String[]{jaxrsContext.getLocalBaseURL(), path});
                    JaxRsMethodInfo methodInfo = RenardeJaxRsInfoProvider.createMethodInfo(method, url);
                    if (methodInfo != null) {
                        methodInfos.add(methodInfo);
                    }
                }
                ++n2;
            }
            return methodInfos;
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "error while collecting JAX-RS methods for Renarde", e);
            return Collections.emptyList();
        }
    }

    private static JaxRsMethodInfo createMethodInfo(IMethod method, String url) throws JavaModelException {
        IResource resource = method.getResource();
        if (resource == null) {
            return null;
        }
        String documentUri = resource.getLocationURI().toString();
        HttpMethod httpMethod = HttpMethod.GET;
        for (String methodAnnotationFQN : JaxRsConstants.HTTP_METHOD_ANNOTATIONS) {
            if (!AnnotationUtils.hasAnnotation((IAnnotatable)method, (String)methodAnnotationFQN)) continue;
            httpMethod = JaxRsUtils.getHttpMethodForAnnotation((String)methodAnnotationFQN);
            break;
        }
        return new JaxRsMethodInfo(url, httpMethod, method, documentUri);
    }
}

