/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.jdt.internal.quarkus.route.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.jaxrs.HttpMethod;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;

public class ReactiveRouteUtils {
    private ReactiveRouteUtils() {
    }

    public static boolean isReactiveRoute(IMethod method) {
        try {
            if (!method.isConstructor() && AnnotationUtils.hasAnyAnnotation((IAnnotatable)method, (String[])new String[]{"io.quarkus.vertx.web.Route"})) {
                return !Flags.isPrivate((int)method.getFlags()) && !Flags.isStatic((int)method.getFlags());
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        return false;
    }

    public static IAnnotation getRouteBaseAnnotation(IAnnotatable annotatable) throws JavaModelException {
        return AnnotationUtils.getFirstAnnotation((IAnnotatable)annotatable, (String[])new String[]{"io.quarkus.vertx.web.RouteBase"});
    }

    public static String getRouteBasePath(IAnnotation routeBaseAnnotation) throws JavaModelException {
        return AnnotationUtils.getAnnotationMemberValue((IAnnotation)routeBaseAnnotation, (String)"path");
    }

    public static List<IAnnotation> getRouteAnnotations(IAnnotatable annotatable) throws JavaModelException {
        return ReactiveRouteUtils.getAllAnnotations(annotatable, "io.quarkus.vertx.web.Route");
    }

    public static String getRoutePath(IAnnotation routeAnnotation) throws JavaModelException {
        return AnnotationUtils.getAnnotationMemberValue((IAnnotation)routeAnnotation, (String)"path");
    }

    public static String getRouteHttpMethodName(IAnnotation routeAnnotation) throws JavaModelException {
        int index;
        String value = AnnotationUtils.getAnnotationMemberValue((IAnnotation)routeAnnotation, (String)"methods");
        if (value != null && (index = value.lastIndexOf(46)) != -1) {
            return value.substring(index);
        }
        return value;
    }

    public static HttpMethod getHttpMethodForAnnotation(String httpMethodName) {
        if (httpMethodName != null) {
            try {
                return HttpMethod.valueOf((String)httpMethodName);
            }
            catch (Exception exception) {}
        }
        return HttpMethod.GET;
    }

    public static List<IAnnotation> getAllAnnotations(IAnnotatable annotatable, String ... annotationNames) throws JavaModelException {
        ArrayList<IAnnotation> all = new ArrayList<IAnnotation>();
        ReactiveRouteUtils.collectAnnotations(annotatable.getAnnotations(), all, annotationNames);
        return all;
    }

    private static void collectAnnotations(IAnnotation[] annotations, List<IAnnotation> all, String ... annotationNames) {
        if (annotations == null || annotations.length == 0 || annotationNames == null || annotationNames.length == 0) {
            return;
        }
        IAnnotation[] iAnnotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String[] stringArray = annotationNames;
            int n3 = annotationNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String annotationName = stringArray[n4];
                if (AnnotationUtils.isMatchAnnotation((IAnnotation)annotation, (String)annotationName)) {
                    all.add(annotation);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

