/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;

public class ThrowableDeserializer
extends BeanDeserializer {
    private static final long serialVersionUID = 1L;
    protected static final String PROP_NAME_MESSAGE = "message";
    protected static final String PROP_NAME_SUPPRESSED = "suppressed";
    protected static final String PROP_NAME_LOCALIZED_MESSAGE = "localizedMessage";

    @Deprecated
    public ThrowableDeserializer(BeanDeserializer baseDeserializer) {
        super(baseDeserializer);
        this._vanillaProcessing = false;
    }

    public static ThrowableDeserializer construct(DeserializationContext ctxt, BeanDeserializer baseDeserializer) {
        return new ThrowableDeserializer(baseDeserializer);
    }

    protected ThrowableDeserializer(BeanDeserializer src, NameTransformer unwrapper) {
        super((BeanDeserializerBase)src, unwrapper);
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer unwrapper) {
        if (this.getClass() != ThrowableDeserializer.class) {
            return this;
        }
        return new ThrowableDeserializer(this, unwrapper);
    }

    @Override
    public Object deserializeFromObject(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(p2, ctxt);
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p2, ctxt));
        }
        if (this._beanType.isAbstract()) {
            return ctxt.handleMissingInstantiator(this.handledType(), this.getValueInstantiator(), p2, "abstract type (need to add/enable type information?)", new Object[0]);
        }
        boolean hasStringCreator = this._valueInstantiator.canCreateFromString();
        boolean hasDefaultCtor = this._valueInstantiator.canCreateUsingDefault();
        if (!hasStringCreator && !hasDefaultCtor) {
            return ctxt.handleMissingInstantiator(this.handledType(), this.getValueInstantiator(), p2, "Throwable needs a default constructor, a single-String-arg constructor; or explicit @JsonCreator", new Object[0]);
        }
        Throwable throwable = null;
        Object[] pending = null;
        Throwable[] suppressed = null;
        int pendingIx = 0;
        while (!p2.hasToken(JsonToken.END_OBJECT)) {
            String propName = p2.currentName();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            p2.nextToken();
            if (prop != null) {
                if (throwable != null) {
                    prop.deserializeAndSet(p2, ctxt, throwable);
                } else {
                    if (pending == null) {
                        int len = this._beanProperties.size();
                        pending = new Object[len + len];
                    }
                    pending[pendingIx++] = prop;
                    pending[pendingIx++] = prop.deserialize(p2, ctxt);
                }
            } else if (PROP_NAME_MESSAGE.equalsIgnoreCase(propName)) {
                throwable = this._instantiate(ctxt, hasStringCreator, p2.getValueAsString());
            } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                p2.skipChildren();
            } else if (PROP_NAME_SUPPRESSED.equalsIgnoreCase(propName)) {
                suppressed = ctxt.readValue(p2, Throwable[].class);
            } else if (PROP_NAME_LOCALIZED_MESSAGE.equalsIgnoreCase(propName)) {
                p2.skipChildren();
            } else if (this._anySetter != null) {
                if (throwable == null) {
                    throwable = this._instantiate(ctxt, hasStringCreator, null);
                }
                this._anySetter.deserializeAndSet(p2, ctxt, throwable, propName);
            } else if (PROP_NAME_MESSAGE.equalsIgnoreCase(propName)) {
                p2.skipChildren();
            } else {
                this.handleUnknownProperty(p2, ctxt, throwable, propName);
            }
            p2.nextToken();
        }
        if (throwable == null) {
            throwable = this._instantiate(ctxt, hasStringCreator, null);
        }
        if (pending != null) {
            int len = pendingIx;
            for (int i2 = 0; i2 < len; i2 += 2) {
                SettableBeanProperty prop = (SettableBeanProperty)pending[i2];
                prop.set(throwable, pending[i2 + 1]);
            }
        }
        if (suppressed != null) {
            for (void var12_18 : suppressed) {
                throwable.addSuppressed((Throwable)var12_18);
            }
        }
        return throwable;
    }

    private Throwable _instantiate(DeserializationContext ctxt, boolean hasStringCreator, String valueAsString) throws IOException {
        if (hasStringCreator) {
            if (valueAsString != null) {
                return (Throwable)this._valueInstantiator.createFromString(ctxt, valueAsString);
            }
            return (Throwable)this._valueInstantiator.createFromString(ctxt, null);
        }
        return (Throwable)this._valueInstantiator.createUsingDefault(ctxt);
    }
}

