/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.util;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.nimbusds.oauth2.sdk.util.JSONUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public final class JSONArrayUtils {
    public static JSONArray parse(String s2) throws ParseException {
        Object o2 = JSONUtils.parseJSON(s2);
        if (o2 instanceof JSONArray) {
            return (JSONArray)o2;
        }
        throw new ParseException("The JSON entity is not an array");
    }

    public static List<String> toStringList(JSONArray jsonArray) {
        if (CollectionUtils.isEmpty(jsonArray)) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>(jsonArray.size());
        for (Object o2 : jsonArray) {
            if (o2 == null) continue;
            stringList.add(o2.toString());
        }
        return stringList;
    }

    public static List<URI> toURIList(JSONArray jsonArray) throws ParseException {
        if (CollectionUtils.isEmpty(jsonArray)) {
            return Collections.emptyList();
        }
        ArrayList<URI> uriList = new ArrayList<URI>(jsonArray.size());
        for (Object o2 : jsonArray) {
            if (o2 == null) continue;
            try {
                uriList.add(new URI(o2.toString()));
            }
            catch (URISyntaxException e2) {
                throw new ParseException("Illegal URI: " + e2.getMessage(), e2);
            }
        }
        return uriList;
    }

    public static List<JSONObject> toJSONObjectList(JSONArray jsonArray) throws ParseException {
        if (CollectionUtils.isEmpty(jsonArray)) {
            return Collections.emptyList();
        }
        ArrayList<JSONObject> objectList = new ArrayList<JSONObject>(jsonArray.size());
        int i2 = -1;
        for (Object o2 : jsonArray) {
            ++i2;
            if (o2 == null) continue;
            if (o2 instanceof JSONObject) {
                objectList.add((JSONObject)o2);
                continue;
            }
            if (o2 instanceof Map) {
                JSONObject jo = new JSONObject((Map)o2);
                objectList.add(jo);
                continue;
            }
            throw new ParseException("Invalid JSON object at position " + i2);
        }
        return objectList;
    }

    private JSONArrayUtils() {
    }
}

