/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.assurance;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.openid.connect.sdk.assurance.Policy;
import com.nimbusds.openid.connect.sdk.assurance.Procedure;
import com.nimbusds.openid.connect.sdk.assurance.Status;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class IdentityAssuranceProcess {
    private final Policy policy;
    private final Procedure procedure;
    private final Status status;

    public IdentityAssuranceProcess(Policy policy, Procedure procedure, Status status) {
        if (policy == null && procedure == null && status == null) {
            throw new IllegalArgumentException("At least one assurance process element must be specified");
        }
        this.policy = policy;
        this.procedure = procedure;
        this.status = status;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof IdentityAssuranceProcess)) {
            return false;
        }
        IdentityAssuranceProcess that = (IdentityAssuranceProcess)o2;
        return Objects.equals(this.getPolicy(), that.getPolicy()) && Objects.equals(this.getProcedure(), that.getProcedure()) && Objects.equals(this.getStatus(), that.getStatus());
    }

    public int hashCode() {
        return Objects.hash(this.getPolicy(), this.getProcedure(), this.getStatus());
    }

    public JSONObject toJSONObject() {
        JSONObject o2 = new JSONObject();
        if (this.policy != null) {
            o2.put("policy", this.policy.getValue());
        }
        if (this.procedure != null) {
            o2.put("procedure", this.procedure.getValue());
        }
        if (this.status != null) {
            o2.put("status", this.status.getValue());
        }
        return o2;
    }

    public static IdentityAssuranceProcess parse(JSONObject jsonObject) throws ParseException {
        Policy policy = null;
        String value = JSONObjectUtils.getString(jsonObject, "policy", null);
        if (StringUtils.isNotBlank(value)) {
            policy = new Policy(value);
        }
        Procedure procedure = null;
        value = JSONObjectUtils.getString(jsonObject, "procedure", null);
        if (StringUtils.isNotBlank(value)) {
            procedure = new Procedure(value);
        }
        Status status = null;
        value = JSONObjectUtils.getString(jsonObject, "status", null);
        if (StringUtils.isNotBlank(value)) {
            status = new Status(value);
        }
        try {
            return new IdentityAssuranceProcess(policy, procedure, status);
        }
        catch (IllegalArgumentException e2) {
            throw new ParseException(e2.getMessage());
        }
    }
}

