/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.assurance.evidences;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.date.DateWithTimeZoneOffset;
import com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidence;
import com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidenceType;
import java.util.Objects;
import net.minidev.json.JSONObject;

@Deprecated
public class QESEvidence
extends IdentityEvidence {
    private final Issuer issuer;
    private final String serialNumber;
    private final DateWithTimeZoneOffset createdAt;

    public QESEvidence(Issuer issuer, String serialNumber, DateWithTimeZoneOffset createdAt) {
        super(IdentityEvidenceType.QES, null);
        this.issuer = issuer;
        this.serialNumber = serialNumber;
        this.createdAt = createdAt;
    }

    public Issuer getQESIssuer() {
        return this.issuer;
    }

    public String getQESSerialNumberString() {
        return this.serialNumber;
    }

    public DateWithTimeZoneOffset getQESCreationTime() {
        return this.createdAt;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o2 = super.toJSONObject();
        if (this.getQESIssuer() != null) {
            o2.put("issuer", this.getQESIssuer().getValue());
        }
        if (this.getQESSerialNumberString() != null) {
            o2.put("serial_number", this.getQESSerialNumberString());
        }
        if (this.getQESCreationTime() != null) {
            o2.put("created_at", this.getQESCreationTime().toISO8601String());
        }
        return o2;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof QESEvidence)) {
            return false;
        }
        QESEvidence evidence = (QESEvidence)o2;
        return Objects.equals(this.getQESIssuer(), evidence.getQESIssuer()) && Objects.equals(this.getQESSerialNumberString(), evidence.getQESSerialNumberString()) && Objects.equals(this.getQESCreationTime(), evidence.getQESCreationTime());
    }

    public int hashCode() {
        return Objects.hash(this.getQESIssuer(), this.getQESSerialNumberString(), this.getQESCreationTime());
    }

    public static QESEvidence parse(JSONObject jsonObject) throws ParseException {
        QESEvidence.ensureType(IdentityEvidenceType.QES, jsonObject);
        Issuer issuer = null;
        if (jsonObject.get("issuer") != null) {
            issuer = new Issuer(JSONObjectUtils.getNonBlankString(jsonObject, "issuer"));
        }
        String serialNumber = JSONObjectUtils.getString(jsonObject, "serial_number", null);
        DateWithTimeZoneOffset createdAt = null;
        if (jsonObject.get("created_at") != null) {
            createdAt = DateWithTimeZoneOffset.parseISO8601String(JSONObjectUtils.getNonBlankString(jsonObject, "created_at"));
        }
        return new QESEvidence(issuer, serialNumber, createdAt);
    }
}

