/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.assurance.evidences.attachment;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.AttachmentType;
import com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.EmbeddedAttachment;
import com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.ExternalAttachment;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public abstract class Attachment {
    private final AttachmentType type;
    private final String description;

    protected Attachment(AttachmentType type, String description) {
        Objects.requireNonNull(type);
        this.type = type;
        this.description = description;
    }

    public AttachmentType getType() {
        return this.type;
    }

    public String getDescriptionString() {
        return this.description;
    }

    public JSONObject toJSONObject() {
        JSONObject o2 = new JSONObject();
        if (this.getDescriptionString() != null) {
            o2.put("desc", this.getDescriptionString());
        }
        return o2;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Attachment)) {
            return false;
        }
        Attachment that = (Attachment)o2;
        return Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.description);
    }

    public EmbeddedAttachment toEmbeddedAttachment() {
        return (EmbeddedAttachment)this;
    }

    public ExternalAttachment toExternalAttachment() {
        return (ExternalAttachment)this;
    }

    public static Attachment parse(JSONObject jsonObject) throws ParseException {
        if (jsonObject.get("content") != null) {
            return EmbeddedAttachment.parse(jsonObject);
        }
        if (jsonObject.get("url") != null) {
            return ExternalAttachment.parse(jsonObject);
        }
        throw new ParseException("Missing required attachment parameter(s)");
    }

    public static List<Attachment> parseList(JSONArray jsonArray) throws ParseException {
        if (jsonArray == null) {
            return null;
        }
        LinkedList<Attachment> attachments = new LinkedList<Attachment>();
        for (JSONObject attachmentObject : JSONArrayUtils.toJSONObjectList(jsonArray)) {
            attachments.add(Attachment.parse(attachmentObject));
        }
        return attachments;
    }
}

