/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.assurance.evidences.attachment;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.Attachment;
import com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.AttachmentType;
import com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.Content;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class EmbeddedAttachment
extends Attachment {
    private final Content content;

    public EmbeddedAttachment(Content content) {
        super(AttachmentType.EMBEDDED, content.getDescription());
        this.content = content;
    }

    public Content getContent() {
        return this.content;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o2 = super.toJSONObject();
        o2.put("content_type", this.getContent().getType().toString());
        o2.put("content", this.getContent().getBase64().toString());
        return o2;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof EmbeddedAttachment)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        EmbeddedAttachment that = (EmbeddedAttachment)o2;
        return this.getContent().equals(that.getContent());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getContent());
    }

    public static EmbeddedAttachment parse(JSONObject jsonObject) throws ParseException {
        ContentType type;
        try {
            type = ContentType.parse(JSONObjectUtils.getString(jsonObject, "content_type"));
        }
        catch (java.text.ParseException e2) {
            throw new ParseException("Invalid content_type: " + e2.getMessage(), e2);
        }
        Base64 base64 = Base64.from(JSONObjectUtils.getNonBlankString(jsonObject, "content"));
        String description = JSONObjectUtils.getString(jsonObject, "desc", null);
        return new EmbeddedAttachment(new Content(type, base64, description));
    }
}

