/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.entities;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.claims.CommonClaimsSet;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import com.nimbusds.openid.connect.sdk.federation.entities.FederationEntityMetadata;
import com.nimbusds.openid.connect.sdk.federation.trust.marks.TrustMarkEntry;
import com.nimbusds.openid.connect.sdk.federation.trust.marks.TrustMarkIssuerMetadata;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public abstract class CommonFederationClaimsSet
extends CommonClaimsSet {
    public static final String EXP_CLAIM_NAME = "exp";
    public static final String METADATA_CLAIM_NAME = "metadata";
    public static final String TRUST_MARKS_CLAIM_NAME = "trust_marks";

    protected CommonFederationClaimsSet() {
    }

    protected CommonFederationClaimsSet(JSONObject jsonObject) {
        super(jsonObject);
    }

    protected void validateRequiredClaimsPresence() throws ParseException {
        if (this.getIssuer() == null) {
            throw new ParseException("Missing iss (issuer) claim");
        }
        EntityID.parse(this.getIssuer());
        if (this.getSubject() == null) {
            throw new ParseException("Missing sub (subject) claim");
        }
        EntityID.parse(this.getSubject());
        if (this.getIssueTime() == null) {
            throw new ParseException("Missing iat (issued-at) claim");
        }
        if (this.getExpirationTime() == null) {
            throw new ParseException("Missing exp (expiration) claim");
        }
    }

    public EntityID getIssuerEntityID() {
        return new EntityID(this.getIssuer().getValue());
    }

    public EntityID getSubjectEntityID() {
        return new EntityID(this.getSubject().getValue());
    }

    public Date getExpirationTime() {
        return this.getDateClaim(EXP_CLAIM_NAME);
    }

    public JSONObject getMetadata(EntityType type) {
        JSONObject o2 = this.getJSONObjectClaim(METADATA_CLAIM_NAME);
        if (o2 == null) {
            return null;
        }
        try {
            return JSONObjectUtils.getJSONObject(o2, type.getValue(), null);
        }
        catch (ParseException e2) {
            return null;
        }
    }

    public void setMetadata(EntityType type, JSONObject metadata) {
        JSONObject o2 = this.getJSONObjectClaim(METADATA_CLAIM_NAME);
        if (o2 == null) {
            if (metadata == null) {
                return;
            }
            o2 = new JSONObject();
        }
        o2.put(type.getValue(), metadata);
        this.setClaim(METADATA_CLAIM_NAME, o2);
    }

    public OIDCClientMetadata getRPMetadata() {
        JSONObject o2 = this.getMetadata(EntityType.OPENID_RELYING_PARTY);
        if (o2 == null) {
            return null;
        }
        try {
            return OIDCClientMetadata.parse(o2);
        }
        catch (ParseException e2) {
            return null;
        }
    }

    public void setRPMetadata(OIDCClientMetadata rpMetadata) {
        JSONObject o2 = rpMetadata != null ? rpMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.OPENID_RELYING_PARTY, o2);
    }

    public OIDCProviderMetadata getOPMetadata() {
        JSONObject o2 = this.getMetadata(EntityType.OPENID_PROVIDER);
        if (o2 == null) {
            return null;
        }
        try {
            return OIDCProviderMetadata.parse(o2);
        }
        catch (ParseException e2) {
            return null;
        }
    }

    public void setOPMetadata(OIDCProviderMetadata opMetadata) {
        JSONObject o2 = opMetadata != null ? opMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.OPENID_PROVIDER, o2);
    }

    public ClientMetadata getOAuthClientMetadata() {
        JSONObject o2 = this.getMetadata(EntityType.OAUTH_CLIENT);
        if (o2 == null) {
            return null;
        }
        try {
            return ClientMetadata.parse(o2);
        }
        catch (ParseException e2) {
            return null;
        }
    }

    public void setOAuthClientMetadata(ClientMetadata clientMetadata) {
        JSONObject o2 = clientMetadata != null ? clientMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.OAUTH_CLIENT, o2);
    }

    public AuthorizationServerMetadata getASMetadata() {
        JSONObject o2 = this.getMetadata(EntityType.OAUTH_AUTHORIZATION_SERVER);
        if (o2 == null) {
            return null;
        }
        try {
            return AuthorizationServerMetadata.parse(o2);
        }
        catch (ParseException e2) {
            return null;
        }
    }

    public void setASMetadata(AuthorizationServerMetadata asMetadata) {
        JSONObject o2 = asMetadata != null ? asMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.OAUTH_AUTHORIZATION_SERVER, o2);
    }

    public FederationEntityMetadata getFederationEntityMetadata() {
        JSONObject o2 = this.getMetadata(EntityType.FEDERATION_ENTITY);
        if (o2 == null) {
            return null;
        }
        try {
            return FederationEntityMetadata.parse(o2);
        }
        catch (ParseException e2) {
            return null;
        }
    }

    public void setFederationEntityMetadata(FederationEntityMetadata entityMetadata) {
        JSONObject o2 = entityMetadata != null ? entityMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.FEDERATION_ENTITY, o2);
    }

    @Deprecated
    public TrustMarkIssuerMetadata getTrustMarkIssuerMetadata() {
        JSONObject o2 = this.getMetadata(EntityType.TRUST_MARK_ISSUER);
        if (o2 == null) {
            return null;
        }
        try {
            return TrustMarkIssuerMetadata.parse(o2);
        }
        catch (ParseException e2) {
            return null;
        }
    }

    public List<TrustMarkEntry> getTrustMarks() {
        List<JSONObject> jsonObjects;
        JSONArray array = this.getJSONArrayClaim(TRUST_MARKS_CLAIM_NAME);
        if (array == null) {
            return null;
        }
        try {
            jsonObjects = JSONArrayUtils.toJSONObjectList(array);
        }
        catch (ParseException e2) {
            return null;
        }
        LinkedList<TrustMarkEntry> marks = new LinkedList<TrustMarkEntry>();
        for (JSONObject o2 : jsonObjects) {
            try {
                marks.add(TrustMarkEntry.parse(o2));
            }
            catch (ParseException e3) {
                return null;
            }
        }
        return marks;
    }

    public void setTrustMarks(List<TrustMarkEntry> marks) {
        if (marks != null) {
            JSONArray array = new JSONArray();
            for (TrustMarkEntry en : marks) {
                array.add(en.toJSONObject());
            }
            this.setClaim(TRUST_MARKS_CLAIM_NAME, array);
        } else {
            this.setClaim(TRUST_MARKS_CLAIM_NAME, null);
        }
    }
}

