/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.trust.constraints;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.nimbusds.openid.connect.sdk.federation.trust.constraints.EntityIDConstraint;
import com.nimbusds.openid.connect.sdk.federation.trust.constraints.LeafEntityTypeConstraint;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

@Immutable
public final class TrustChainConstraints
implements JSONAware {
    public static final TrustChainConstraints NO_CONSTRAINTS = new TrustChainConstraints();
    private final int maxPathLength;
    private final List<EntityIDConstraint> permittedEntityIDs;
    private final List<EntityIDConstraint> excludedEntityIDs;
    private final LeafEntityTypeConstraint leafEntityTypeConstraint;

    public TrustChainConstraints() {
        this(-1, null, null, LeafEntityTypeConstraint.ANY);
    }

    public TrustChainConstraints(int maxPathLength) {
        this(maxPathLength, null, null, null);
    }

    public TrustChainConstraints(int maxPathLength, List<EntityIDConstraint> permittedEntityIDs, List<EntityIDConstraint> excludedEntityIDs, LeafEntityTypeConstraint leafEntityTypeConstraint) {
        this.maxPathLength = maxPathLength;
        this.permittedEntityIDs = permittedEntityIDs != null ? permittedEntityIDs : Collections.emptyList();
        this.excludedEntityIDs = excludedEntityIDs != null ? excludedEntityIDs : Collections.emptyList();
        this.leafEntityTypeConstraint = leafEntityTypeConstraint != null ? leafEntityTypeConstraint : LeafEntityTypeConstraint.ANY;
    }

    public boolean isPermitted(int numIntermediatesInPath) {
        if (numIntermediatesInPath < 0) {
            throw new IllegalArgumentException("The path length must not be negative");
        }
        return this.getMaxPathLength() <= -1 || numIntermediatesInPath <= this.getMaxPathLength();
    }

    public boolean isPermitted(EntityID entityID) {
        if (this.getExcludedEntityIDs().isEmpty() && this.getPermittedEntityIDs().isEmpty()) {
            return true;
        }
        if (!this.getExcludedEntityIDs().isEmpty()) {
            for (EntityIDConstraint constraint : this.getExcludedEntityIDs()) {
                if (!constraint.matches(entityID)) continue;
                return false;
            }
        }
        if (!this.getPermittedEntityIDs().isEmpty()) {
            for (EntityIDConstraint constraint : this.getPermittedEntityIDs()) {
                if (!constraint.matches(entityID)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean isPermitted(int numIntermediatesInPath, EntityID entityID) {
        return this.isPermitted(numIntermediatesInPath) && this.isPermitted(entityID);
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public List<EntityIDConstraint> getPermittedEntityIDs() {
        return this.permittedEntityIDs;
    }

    public List<EntityIDConstraint> getExcludedEntityIDs() {
        return this.excludedEntityIDs;
    }

    public LeafEntityTypeConstraint getLeafEntityTypeConstraint() {
        return this.leafEntityTypeConstraint;
    }

    public JSONObject toJSONObject() {
        LinkedList<String> vals;
        JSONObject o2 = new JSONObject();
        if (this.maxPathLength > -1) {
            o2.put("max_path_length", this.maxPathLength);
        }
        JSONObject namingConstraints = new JSONObject();
        if (CollectionUtils.isNotEmpty(this.permittedEntityIDs)) {
            vals = new LinkedList<String>();
            for (EntityIDConstraint v2 : this.permittedEntityIDs) {
                vals.add(v2.toString());
            }
            namingConstraints.put("permitted", vals);
        }
        if (CollectionUtils.isNotEmpty(this.excludedEntityIDs)) {
            vals = new LinkedList();
            for (EntityIDConstraint v2 : this.excludedEntityIDs) {
                vals.add(v2.toString());
            }
            namingConstraints.put("excluded", vals);
        }
        if (!namingConstraints.isEmpty()) {
            o2.put("naming_constraints", namingConstraints);
        }
        if (!this.leafEntityTypeConstraint.allowsAny()) {
            o2.put("allowed_leaf_entity_types", this.leafEntityTypeConstraint.getAllowedAsStringList());
        }
        return o2;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof TrustChainConstraints)) {
            return false;
        }
        TrustChainConstraints that = (TrustChainConstraints)o2;
        return this.getMaxPathLength() == that.getMaxPathLength() && Objects.equals(this.getPermittedEntityIDs(), that.getPermittedEntityIDs()) && Objects.equals(this.getExcludedEntityIDs(), that.getExcludedEntityIDs()) && this.getLeafEntityTypeConstraint().equals(that.getLeafEntityTypeConstraint());
    }

    public int hashCode() {
        return Objects.hash(this.getMaxPathLength(), this.getPermittedEntityIDs(), this.getExcludedEntityIDs(), this.getLeafEntityTypeConstraint());
    }

    public static TrustChainConstraints parse(JSONObject jsonObject) throws ParseException {
        int maxPathLength = JSONObjectUtils.getInt(jsonObject, "max_path_length", -1);
        JSONObject namingConstraints = JSONObjectUtils.getJSONObject(jsonObject, "naming_constraints", new JSONObject());
        LinkedList<EntityIDConstraint> permitted = null;
        List<String> values = JSONObjectUtils.getStringList(namingConstraints, "permitted", null);
        if (values != null) {
            permitted = new LinkedList<EntityIDConstraint>();
            for (String string : values) {
                if (string == null) continue;
                permitted.add(EntityIDConstraint.parse(string));
            }
        }
        LinkedList<EntityIDConstraint> excluded = null;
        values = JSONObjectUtils.getStringList(namingConstraints, "excluded", null);
        if (values != null) {
            excluded = new LinkedList<EntityIDConstraint>();
            for (String v3 : values) {
                if (v3 == null) continue;
                excluded.add(EntityIDConstraint.parse(v3));
            }
        }
        LeafEntityTypeConstraint leafEntityTypeConstraint = LeafEntityTypeConstraint.parse(JSONObjectUtils.getStringList(jsonObject, "allowed_leaf_entity_types", null));
        return new TrustChainConstraints(maxPathLength, permitted, excluded, leafEntityTypeConstraint);
    }
}

