/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.federation.utils;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.oauth2.sdk.ParseException;
import java.security.PublicKey;
import java.util.List;

public class JWTUtils {
    public static JWSAlgorithm resolveSigningAlgorithm(JWK jwk) throws JOSEException {
        KeyType jwkType = jwk.getKeyType();
        if (KeyType.RSA.equals(jwkType)) {
            if (jwk.getAlgorithm() != null) {
                return new JWSAlgorithm(jwk.getAlgorithm().getName());
            }
            return JWSAlgorithm.RS256;
        }
        if (KeyType.EC.equals(jwkType)) {
            ECKey ecJWK = jwk.toECKey();
            if (jwk.getAlgorithm() != null) {
                return new JWSAlgorithm(ecJWK.getAlgorithm().getName());
            }
            if (Curve.P_256.equals(ecJWK.getCurve())) {
                return JWSAlgorithm.ES256;
            }
            if (Curve.P_384.equals(ecJWK.getCurve())) {
                return JWSAlgorithm.ES384;
            }
            if (Curve.P_521.equals(ecJWK.getCurve())) {
                return JWSAlgorithm.ES512;
            }
            if (Curve.SECP256K1.equals(ecJWK.getCurve())) {
                return JWSAlgorithm.ES256K;
            }
            throw new JOSEException("Unsupported ECDSA curve: " + ecJWK.getCurve());
        }
        if (KeyType.OKP.equals(jwkType)) {
            OctetKeyPair okp = jwk.toOctetKeyPair();
            if (Curve.Ed25519.equals(okp.getCurve())) {
                return JWSAlgorithm.EdDSA;
            }
            throw new JOSEException("Unsupported EdDSA curve: " + okp.getCurve());
        }
        throw new JOSEException("Unsupported JWK type: " + jwkType);
    }

    public static SignedJWT sign(JWK signingJWK, JWSAlgorithm alg, JOSEObjectType type, JWTClaimsSet claimsSet) throws JOSEException {
        JWSSigner jwsSigner = new DefaultJWSSignerFactory().createJWSSigner(signingJWK, alg);
        JWSHeader jwsHeader = new JWSHeader.Builder(alg).type(type).keyID(signingJWK.getKeyID()).build();
        SignedJWT jwt = new SignedJWT(jwsHeader, claimsSet);
        jwt.sign(jwsSigner);
        return jwt;
    }

    public static Base64URL verifySignature(SignedJWT jwt, JOSEObjectType type, JWTClaimsSetVerifier<?> claimsVerifier, JWKSet jwkSet) throws BadJOSEException, JOSEException {
        if (!type.equals(jwt.getHeader().getType())) {
            throw new BadJOSEException("JWT rejected: Invalid or missing JWT typ (type) header");
        }
        try {
            claimsVerifier.verify(jwt.getJWTClaimsSet(), null);
        }
        catch (java.text.ParseException e2) {
            throw new BadJOSEException(e2.getMessage(), e2);
        }
        List<JWK> jwkMatches = new JWKSelector(JWKMatcher.forJWSHeader(jwt.getHeader())).select(jwkSet);
        if (jwkMatches.isEmpty()) {
            throw new BadJOSEException("JWT rejected: Another JOSE algorithm expected, or no matching key(s) found");
        }
        DefaultJWSVerifierFactory verifierFactory = new DefaultJWSVerifierFactory();
        for (JWK candidateJWK : jwkMatches) {
            if (!(candidateJWK instanceof AsymmetricJWK)) continue;
            PublicKey publicKey = ((AsymmetricJWK)((Object)candidateJWK)).toPublicKey();
            JWSVerifier jwsVerifier = verifierFactory.createJWSVerifier(jwt.getHeader(), publicKey);
            if (!jwt.verify(jwsVerifier)) continue;
            return candidateJWK.computeThumbprint();
        }
        throw new BadJOSEException("JWT rejected: Invalid signature");
    }

    public static JWTClaimsSet parseSignedJWTClaimsSet(SignedJWT jwt) throws ParseException {
        if (JWSObject.State.UNSIGNED.equals((Object)jwt.getState())) {
            throw new ParseException("The JWT is not signed");
        }
        try {
            return jwt.getJWTClaimsSet();
        }
        catch (java.text.ParseException e2) {
            throw new ParseException(e2.getMessage(), e2);
        }
    }

    private JWTUtils() {
    }
}

