/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.nativesso;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.nativesso.DeviceSecret;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class DeviceSecretToken
extends Token {
    private static final long serialVersionUID = -5834546200975074494L;

    public DeviceSecretToken(DeviceSecret deviceSecret) {
        super(deviceSecret.getValue());
    }

    public DeviceSecret getDeviceSecret() {
        return new DeviceSecret(this.getValue());
    }

    @Override
    public Set<String> getParameterNames() {
        HashSet<String> paramNames = new HashSet<String>(this.getCustomParameters().keySet());
        paramNames.add("device_secret");
        return paramNames;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o2 = new JSONObject();
        o2.putAll(this.getCustomParameters());
        o2.put("device_secret", this.getValue());
        return o2;
    }

    public static DeviceSecretToken parse(JSONObject jsonObject) throws ParseException {
        String value = JSONObjectUtils.getString(jsonObject, "device_secret", null);
        if (value == null) {
            return null;
        }
        try {
            return new DeviceSecretToken(new DeviceSecret(value));
        }
        catch (Exception e2) {
            throw new ParseException("Illegal device secret", e2);
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof DeviceSecretToken && this.toString().equals(object.toString());
    }
}

