/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.writer;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.writer.JsonReader;
import net.minidev.json.writer.JsonReaderI;

public class ArraysMapper<T>
extends JsonReaderI<T> {
    public static JsonReaderI<int[]> MAPPER_PRIM_INT = new ArraysMapper<int[]>(null){

        @Override
        public int[] convert(Object current) {
            int p2 = 0;
            int[] r2 = new int[((List)current).size()];
            for (Object e2 : (List)current) {
                r2[p2++] = ((Number)e2).intValue();
            }
            return r2;
        }
    };
    public static JsonReaderI<Integer[]> MAPPER_INT = new ArraysMapper<Integer[]>(null){

        @Override
        public Integer[] convert(Object current) {
            int p2 = 0;
            Integer[] r2 = new Integer[((List)current).size()];
            for (Object e2 : (List)current) {
                if (e2 == null) continue;
                r2[p2] = e2 instanceof Integer ? (Integer)e2 : Integer.valueOf(((Number)e2).intValue());
                ++p2;
            }
            return r2;
        }
    };
    public static JsonReaderI<short[]> MAPPER_PRIM_SHORT = new ArraysMapper<short[]>(null){

        @Override
        public short[] convert(Object current) {
            int p2 = 0;
            short[] r2 = new short[((List)current).size()];
            for (Object e2 : (List)current) {
                r2[p2++] = ((Number)e2).shortValue();
            }
            return r2;
        }
    };
    public static JsonReaderI<Short[]> MAPPER_SHORT = new ArraysMapper<Short[]>(null){

        @Override
        public Short[] convert(Object current) {
            int p2 = 0;
            Short[] r2 = new Short[((List)current).size()];
            for (Object e2 : (List)current) {
                if (e2 == null) continue;
                r2[p2] = e2 instanceof Short ? (Short)e2 : Short.valueOf(((Number)e2).shortValue());
                ++p2;
            }
            return r2;
        }
    };
    public static JsonReaderI<byte[]> MAPPER_PRIM_BYTE = new ArraysMapper<byte[]>(null){

        @Override
        public byte[] convert(Object current) {
            int p2 = 0;
            byte[] r2 = new byte[((List)current).size()];
            for (Object e2 : (List)current) {
                r2[p2++] = ((Number)e2).byteValue();
            }
            return r2;
        }
    };
    public static JsonReaderI<Byte[]> MAPPER_BYTE = new ArraysMapper<Byte[]>(null){

        @Override
        public Byte[] convert(Object current) {
            int p2 = 0;
            Byte[] r2 = new Byte[((List)current).size()];
            for (Object e2 : (List)current) {
                if (e2 == null) continue;
                r2[p2] = e2 instanceof Byte ? (Byte)e2 : Byte.valueOf(((Number)e2).byteValue());
                ++p2;
            }
            return r2;
        }
    };
    public static JsonReaderI<char[]> MAPPER_PRIM_CHAR = new ArraysMapper<char[]>(null){

        @Override
        public char[] convert(Object current) {
            int p2 = 0;
            char[] r2 = new char[((List)current).size()];
            for (Object e2 : (List)current) {
                r2[p2++] = e2.toString().charAt(0);
            }
            return r2;
        }
    };
    public static JsonReaderI<Character[]> MAPPER_CHAR = new ArraysMapper<Character[]>(null){

        @Override
        public Character[] convert(Object current) {
            int p2 = 0;
            Character[] r2 = new Character[((List)current).size()];
            for (Object e2 : (List)current) {
                if (e2 == null) continue;
                r2[p2] = Character.valueOf(e2.toString().charAt(0));
                ++p2;
            }
            return r2;
        }
    };
    public static JsonReaderI<long[]> MAPPER_PRIM_LONG = new ArraysMapper<long[]>(null){

        @Override
        public long[] convert(Object current) {
            int p2 = 0;
            long[] r2 = new long[((List)current).size()];
            for (Object e2 : (List)current) {
                r2[p2++] = ((Number)e2).intValue();
            }
            return r2;
        }
    };
    public static JsonReaderI<Long[]> MAPPER_LONG = new ArraysMapper<Long[]>(null){

        @Override
        public Long[] convert(Object current) {
            int p2 = 0;
            Long[] r2 = new Long[((List)current).size()];
            for (Object e2 : (List)current) {
                if (e2 == null) continue;
                r2[p2] = e2 instanceof Float ? (Long)e2 : Long.valueOf(((Number)e2).longValue());
                ++p2;
            }
            return r2;
        }
    };
    public static JsonReaderI<float[]> MAPPER_PRIM_FLOAT = new ArraysMapper<float[]>(null){

        @Override
        public float[] convert(Object current) {
            int p2 = 0;
            float[] r2 = new float[((List)current).size()];
            for (Object e2 : (List)current) {
                r2[p2++] = ((Number)e2).floatValue();
            }
            return r2;
        }
    };
    public static JsonReaderI<Float[]> MAPPER_FLOAT = new ArraysMapper<Float[]>(null){

        @Override
        public Float[] convert(Object current) {
            int p2 = 0;
            Float[] r2 = new Float[((List)current).size()];
            for (Object e2 : (List)current) {
                if (e2 == null) continue;
                r2[p2] = e2 instanceof Float ? (Float)e2 : Float.valueOf(((Number)e2).floatValue());
                ++p2;
            }
            return r2;
        }
    };
    public static JsonReaderI<double[]> MAPPER_PRIM_DOUBLE = new ArraysMapper<double[]>(null){

        @Override
        public double[] convert(Object current) {
            int p2 = 0;
            double[] r2 = new double[((List)current).size()];
            for (Object e2 : (List)current) {
                r2[p2++] = ((Number)e2).doubleValue();
            }
            return r2;
        }
    };
    public static JsonReaderI<Double[]> MAPPER_DOUBLE = new ArraysMapper<Double[]>(null){

        @Override
        public Double[] convert(Object current) {
            int p2 = 0;
            Double[] r2 = new Double[((List)current).size()];
            for (Object e2 : (List)current) {
                if (e2 == null) continue;
                r2[p2] = e2 instanceof Double ? (Double)e2 : Double.valueOf(((Number)e2).doubleValue());
                ++p2;
            }
            return r2;
        }
    };
    public static JsonReaderI<boolean[]> MAPPER_PRIM_BOOL = new ArraysMapper<boolean[]>(null){

        @Override
        public boolean[] convert(Object current) {
            int p2 = 0;
            boolean[] r2 = new boolean[((List)current).size()];
            for (Object e2 : (List)current) {
                r2[p2++] = (Boolean)e2;
            }
            return r2;
        }
    };
    public static JsonReaderI<Boolean[]> MAPPER_BOOL = new ArraysMapper<Boolean[]>(null){

        @Override
        public Boolean[] convert(Object current) {
            int p2 = 0;
            Boolean[] r2 = new Boolean[((List)current).size()];
            for (Object e2 : (List)current) {
                if (e2 == null) continue;
                if (e2 instanceof Boolean) {
                    r2[p2] = (boolean)((Boolean)e2);
                } else if (e2 instanceof Number) {
                    r2[p2] = ((Number)e2).intValue() != 0;
                } else {
                    throw new RuntimeException("can not convert " + e2 + " toBoolean");
                }
                ++p2;
            }
            return r2;
        }
    };

    public ArraysMapper(JsonReader base) {
        super(base);
    }

    @Override
    public Object createArray() {
        return new ArrayList();
    }

    @Override
    public void addValue(Object current, Object value) {
        ((List)current).add(value);
    }

    @Override
    public T convert(Object current) {
        return (T)current;
    }

    public static class GenericMapper<T>
    extends ArraysMapper<T> {
        final Class<?> componentType;
        JsonReaderI<?> subMapper;

        public GenericMapper(JsonReader base, Class<T> type) {
            super(base);
            this.componentType = type.getComponentType();
        }

        @Override
        public T convert(Object current) {
            int p2 = 0;
            Object[] r2 = (Object[])Array.newInstance(this.componentType, ((List)current).size());
            for (Object e2 : (List)current) {
                r2[p2++] = e2;
            }
            return (T)r2;
        }

        @Override
        public JsonReaderI<?> startArray(String key) {
            if (this.subMapper == null) {
                this.subMapper = this.base.getMapper(this.componentType);
            }
            return this.subMapper;
        }

        @Override
        public JsonReaderI<?> startObject(String key) {
            if (this.subMapper == null) {
                this.subMapper = this.base.getMapper(this.componentType);
            }
            return this.subMapper;
        }
    }
}

