/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.RAW;
import oracle.xml.binxml.BinXMLDecoder;
import oracle.xml.binxml.BinXMLDecoderImpl;
import oracle.xml.binxml.BinXMLEncoder;
import oracle.xml.binxml.BinXMLMetadataProviderFactory;
import oracle.xml.binxml.BinXMLProcessorFactory;
import oracle.xml.binxml.BinXMLProcessorImpl;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.binxml.DBBinXMLMetadataProvider;
import oracle.xml.binxml.DBBinXMLMetadataProviderImpl;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLSAXSerializer;

public class BinXMLTestEncDec {
    public static BLOB encode(CLOB inclob, String schemaURL) {
        BLOB outblob = null;
        if (inclob == null) {
            return outblob;
        }
        char[] buffer = new char[100];
        try {
            inclob.getChars(1L, 100, buffer);
            System.out.println(buffer);
        }
        catch (Exception ec) {
            ec.printStackTrace(System.out);
        }
        try {
            Connection conn = null;
            DriverManager.registerDriver(new OracleDriver());
            conn = new OracleDriver().defaultConnection();
            DBBinXMLMetadataProvider dbmconn = BinXMLMetadataProviderFactory.createDBMetadataProvider();
            if (conn == null || !(conn instanceof OracleConnection)) {
                return null;
            }
            dbmconn.setConnection((OracleConnection)conn);
            BinXMLProcessorFactory binf = new BinXMLProcessorFactory();
            BinXMLProcessorImpl binp = (BinXMLProcessorImpl)BinXMLProcessorFactory.createProcessor(dbmconn);
            binp.setDebugMode(false);
            ByteArrayOutputStream bytestrm = new ByteArrayOutputStream();
            BinXMLStream binstrm = binp.createBinXMLStream(bytestrm);
            BinXMLEncoder binenc = binstrm.getEncoder();
            System.out.println(schemaURL);
            if (schemaURL != null) {
                binenc.setProperty(1, true);
                binenc.setSchema(schemaURL);
            } else {
                binenc.setProperty(1, false);
            }
            binenc.setProperty(6, true);
            binenc.setChunkMode(true);
            binenc.setProperty(4, true);
            SAXParser dp = new SAXParser();
            dp.setContentHandler(binenc.getContentHandler());
            dp.setLexHandler(binenc.getLexicalHandler());
            dp.setProperty("http://xml.org/sax/properties/lexical-handler", binenc.getLexicalHandler());
            dp.setErrorHandler(binenc.getErrorHandler());
            dp.setDTDHandler(binenc.getDTDHandler());
            dp.setProperty("http://xml.org/sax/properties/declaration-handler", binenc.getDeclHandler());
            Reader istream = inclob.getCharacterStream();
            dp.parse(istream);
            outblob = BLOB.createTemporary(conn, true, 10);
            outblob.putBytes(1L, bytestrm.toByteArray());
            System.out.println(bytestrm.toByteArray());
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
        return outblob;
    }

    public static BLOB encode_from_xsd(CLOB inclob, String xsdfile) {
        BLOB outblob = null;
        try {
            Connection conn = null;
            DriverManager.registerDriver(new OracleDriver());
            conn = new OracleDriver().defaultConnection();
            DBBinXMLMetadataProvider dbmconn = BinXMLMetadataProviderFactory.createDBMetadataProvider();
            if (conn == null || !(conn instanceof OracleConnection)) {
                return null;
            }
            dbmconn.setConnection((OracleConnection)conn);
            BinXMLProcessorFactory binf = new BinXMLProcessorFactory();
            BinXMLProcessorImpl binp = (BinXMLProcessorImpl)BinXMLProcessorFactory.createProcessor(dbmconn);
            binp.setDebugMode(false);
            System.out.println(xsdfile);
            URL schLocURL = BinXMLUtil.createURL(xsdfile);
            String schLoc = schLocURL.toExternalForm();
            BinXMLVocabId schid = dbmconn.saveSchema(schLoc);
            Reader r2 = dbmconn.getCompiledSchema(schid);
            new BinXMLUtil();
            binp.registerSchema(BinXMLUtil.createURL(schLoc), r2);
            ByteArrayOutputStream bytestrm = new ByteArrayOutputStream();
            BinXMLStream binstrm = binp.createBinXMLStream(bytestrm);
            BinXMLEncoder binenc = binstrm.getEncoder();
            binenc.setProperty(1, true);
            binenc.setSchema(schLoc);
            SAXParser dp = new SAXParser();
            dp.setContentHandler(binenc.getContentHandler());
            dp.setErrorHandler(binenc.getErrorHandler());
            outblob = BLOB.createTemporary(conn, true, 10);
            outblob.putBytes(1L, bytestrm.toByteArray());
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
        return outblob;
    }

    public static CLOB decode(BLOB inblob, String encoding, RAW rguid) {
        CLOB outclob = null;
        if (inblob == null) {
            return outclob;
        }
        try {
            Connection conn = null;
            DriverManager.registerDriver(new OracleDriver());
            conn = new OracleDriver().defaultConnection();
            DBBinXMLMetadataProviderImpl dbmconn = (DBBinXMLMetadataProviderImpl)BinXMLMetadataProviderFactory.createDBMetadataProvider();
            if (conn == null || !(conn instanceof OracleConnection)) {
                return null;
            }
            dbmconn.setConnection((OracleConnection)conn);
            if (rguid != null) {
                dbmconn.setGUID((byte[])rguid.toJdbc());
            }
            BinXMLProcessorFactory binf = new BinXMLProcessorFactory();
            BinXMLProcessorImpl binp = (BinXMLProcessorImpl)BinXMLProcessorFactory.createProcessor(dbmconn);
            binp.setDebugMode(false);
            BinXMLStream binstrm = binp.createBinXMLStream(inblob);
            BinXMLDecoderImpl bindec = (BinXMLDecoderImpl)binstrm.getDecoder();
            outclob = CLOB.createTemporary(conn, true, 10);
            ByteArrayOutputStream outstrm = new ByteArrayOutputStream();
            XMLSAXSerializer saxser = new XMLSAXSerializer(outstrm);
            bindec.setLexicalHandler(saxser);
            bindec.setDeclHandler(saxser);
            bindec.setDTDHandler(saxser);
            if (encoding != null) {
                bindec.decode(saxser, saxser, encoding);
            } else {
                bindec.decode(saxser, saxser);
            }
            outclob.putString(1L, outstrm.toString());
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
        return outclob;
    }

    public static void decode_to_file(BLOB inblob, String filename) {
        try {
            Connection conn = null;
            DriverManager.registerDriver(new OracleDriver());
            conn = new OracleDriver().defaultConnection();
            DBBinXMLMetadataProvider dbmconn = BinXMLMetadataProviderFactory.createDBMetadataProvider();
            if (conn != null && conn instanceof OracleConnection) {
                dbmconn.setConnection((OracleConnection)conn);
            }
            BinXMLProcessorFactory binf = new BinXMLProcessorFactory();
            BinXMLProcessorImpl binp = (BinXMLProcessorImpl)BinXMLProcessorFactory.createProcessor(dbmconn);
            binp.setDebugMode(false);
            BinXMLStream binstrm = binp.createBinXMLStream(inblob);
            BinXMLDecoder bindec = binstrm.getDecoder();
            File xmlfile = new File(filename);
            FileOutputStream xmlfilestrm = new FileOutputStream(xmlfile);
            XMLSAXSerializer saxser = new XMLSAXSerializer(xmlfilestrm);
            bindec.decode(saxser, saxser);
        }
        catch (Exception e2) {
            e2.printStackTrace(System.out);
        }
    }
}

