/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import oracle.xdb.servlet.XDBStream;

public class XDBServletResponse
extends ServletOutputStream
implements HttpServletResponse,
XDBStream {
    private static final boolean DEBUG = false;
    private Locale loc_ = Locale.getDefault();
    private Hashtable headers_ = new Hashtable();
    private byte[] localbuf_;
    private PrintWriter writer_;
    private int statusCode_ = 200;
    private int offset_;
    private boolean committed_ = false;
    private int length_ = -1;
    private String charEncoding_ = "ISO-8859-1";
    private boolean flushing_writer_ = false;
    static final String[] dayNames = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final String[] monthNames = new String[]{" Jan ", " Feb ", " Mar ", " Apr ", " May ", " Jun ", " Jul ", " Aug ", " Sep ", " Oct ", " Nov ", " Dec "};

    native void write_header(boolean var1, int var2, String var3, String var4);

    native void write_status(int var1);

    native void write_data(byte[] var1, int var2, int var3);

    native void flush_data();

    native void close_stream();

    private native void write_xml(long var1, String var3, short var4);

    private native void endOfHeaders(int var1);

    XDBServletResponse() {
    }

    public void close() throws IOException {
        if (!this.committed_) {
            this.writeHeaders();
        }
        if (this.localbuf_ != null && this.offset_ > 0) {
            this.write_data(this.localbuf_, 0, this.offset_);
            this.offset_ = 0;
        }
    }

    private void writeHeaders() throws IOException {
        Enumeration keys = this.headers_.keys();
        Enumeration elements = this.headers_.elements();
        this.write_status(this.statusCode_);
        this.committed_ = true;
        if (keys.hasMoreElements()) {
            boolean more;
            do {
                String hdrnm = (String)keys.nextElement();
                Object data = elements.nextElement();
                more = keys.hasMoreElements();
                if (data instanceof Vector) {
                    Object[] hdrdata = ((Vector)data).toArray();
                    int len = hdrdata.length;
                    for (int i2 = 0; i2 < len; ++i2) {
                        this.write_header(!more && i2 == len - 1, this.length_, hdrnm, (String)hdrdata[i2]);
                    }
                } else {
                    this.write_header(!more, this.length_, hdrnm, data.toString());
                }
            } while (more);
        } else {
            this.endOfHeaders(this.length_);
        }
    }

    private void int_flush() {
        this.flushing_writer_ = true;
        this.writer_.flush();
        this.flushing_writer_ = false;
    }

    public final void print(String s2) throws IOException {
        if (this.writer_ == null) {
            this.writer_ = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this), this.charEncoding_));
        }
        this.writer_.print(s2);
        this.int_flush();
    }

    public void println(String s2) throws IOException {
        if (this.writer_ == null) {
            this.writer_ = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this), this.charEncoding_));
        }
        this.writer_.println(s2);
        this.int_flush();
    }

    public final void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        if (len == 0) {
            Thread.dumpStack();
            return;
        }
        if (this.localbuf_ != null) {
            int remains = this.localbuf_.length - this.offset_;
            int l2 = len - remains;
            if (l2 < 0) {
                System.arraycopy(b2, off, this.localbuf_, this.offset_, len);
                this.offset_ += len;
                return;
            }
            System.arraycopy(b2, off, this.localbuf_, this.offset_, remains);
            this.offset_ = this.localbuf_.length;
            off += l2;
            len -= l2;
            if (!this.committed_) {
                this.writeHeaders();
            }
            this.write_data(this.localbuf_, 0, this.localbuf_.length);
            this.offset_ = 0;
        }
        if (!this.committed_) {
            this.writeHeaders();
        }
        this.write_data(b2, off, len);
    }

    @Override
    public final void writeXMLNative(long xobCState, String encoding, short indent) throws IOException {
        if (!this.committed_) {
            this.writeHeaders();
        }
        this.write_xml(xobCState, encoding, indent);
    }

    public final void write(int b2) throws IOException {
        if (this.localbuf_ != null) {
            if (this.offset_ == this.localbuf_.length) {
                if (!this.committed_) {
                    this.writeHeaders();
                }
                this.write_data(this.localbuf_, 0, this.localbuf_.length);
                this.offset_ = 0;
            }
            this.localbuf_[this.offset_++] = (byte)b2;
            return;
        }
        if (!this.committed_) {
            this.writeHeaders();
        }
        byte[] bar = new byte[]{(byte)b2};
        this.write_data(bar, 0, 1);
    }

    public void flush() throws IOException {
        if (this.flushing_writer_) {
            return;
        }
        if (!this.committed_) {
            this.writeHeaders();
        }
        if (this.localbuf_ != null && this.offset_ > 0) {
            this.write_data(this.localbuf_, 0, this.offset_);
            this.offset_ = 0;
        }
        this.flush_data();
    }

    public void flushBuffer() throws IOException {
        this.flush();
    }

    public final int getBufferSize() {
        if (this.localbuf_ == null) {
            return 0;
        }
        return this.localbuf_.length;
    }

    public final String getCharacterEncoding() {
        return this.charEncoding_;
    }

    public final Locale getLocale() {
        return this.loc_;
    }

    public final ServletOutputStream getOutputStream() {
        return this;
    }

    public final PrintWriter getWriter() throws IOException {
        if (this.writer_ == null) {
            this.writer_ = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this), this.charEncoding_));
        }
        return new XDBServletWriter(this.writer_);
    }

    public boolean isCommitted() {
        return this.committed_;
    }

    public final void reset() {
        this.headers_.clear();
        this.offset_ = 0;
        this.statusCode_ = 200;
    }

    public final void setBufferSize(int size) {
        if (this.localbuf_ != null || this.committed_) {
            throw new IllegalStateException("Content already written to output");
        }
        this.localbuf_ = new byte[size];
    }

    public final void setContentType(String type) {
        this.headers_.put("Content-Type", type);
        StringTokenizer st = new StringTokenizer(type, ";");
        while (st.hasMoreTokens()) {
            String buf = st.nextToken();
            String charset = buf.trim();
            if (!charset.startsWith("charset=")) continue;
            int i2 = buf.indexOf("=");
            String charsetSub = buf.substring(i2 + 1);
            this.charEncoding_ = charsetSub.startsWith("\"") ? charsetSub.substring(1, charsetSub.length() - 1) : charsetSub;
            this.charEncoding_ = this.charEncoding_.trim();
            break;
        }
    }

    public final void setContentLength(int len) {
        this.headers_.put("Content-Length", Integer.toString(len));
        this.length_ = len;
    }

    public final void setLocale(Locale loc) {
        this.loc_ = loc;
    }

    private static String cookieToString(Cookie c2) {
        if (c2.getName() == null || c2.getValue() == null) {
            return null;
        }
        String cookstr = c2.getName() + "=" + c2.getValue();
        if (c2.getComment() != null) {
            cookstr = cookstr + "; Comment=" + c2.getComment();
        }
        if (c2.getDomain() != null) {
            cookstr = cookstr + "; Domain=" + c2.getDomain();
        }
        if (c2.getMaxAge() >= 0) {
            cookstr = cookstr + "; Max-Age=" + c2.getMaxAge();
        }
        if (c2.getPath() != null) {
            cookstr = cookstr + "; Path=" + c2.getPath();
        }
        if (c2.getSecure()) {
            cookstr = cookstr + "; Secure";
        }
        cookstr = cookstr + "; Version=" + c2.getVersion();
        return cookstr;
    }

    public final void addCookie(Cookie cookie) {
        Vector v2;
        Object o2 = this.headers_.get("Set-Cookie");
        String cookstr = " " + XDBServletResponse.cookieToString(cookie);
        if (cookstr == null) {
            return;
        }
        if (o2 == null || o2 instanceof String) {
            v2 = new Vector();
            this.headers_.put("Set-Cookie", v2);
        } else if (o2 instanceof Vector) {
            v2 = (Vector)o2;
        } else {
            throw new RuntimeException("Value of Set-Cookie header must be Vector/String");
        }
        if (o2 != null && o2 instanceof String) {
            v2.add((String)o2);
        }
        v2.add(cookstr);
    }

    private static void pad_append(StringBuffer out, int i2) {
        if (i2 < 10) {
            out.append("0");
        }
        out.append(i2);
    }

    private static String dateToString(long date) {
        SimpleTimeZone tz = new SimpleTimeZone(0, "GMT");
        GregorianCalendar cal = new GregorianCalendar(tz, Locale.US);
        StringBuffer out = new StringBuffer();
        cal.setTime(new Date(date));
        out.append(dayNames[cal.get(7) - 1]);
        out.append(", ");
        XDBServletResponse.pad_append(out, cal.get(5));
        out.append(monthNames[cal.get(2)]);
        out.append(cal.get(1));
        out.append(" ");
        XDBServletResponse.pad_append(out, cal.get(11));
        out.append(":");
        XDBServletResponse.pad_append(out, cal.get(12));
        out.append(":");
        XDBServletResponse.pad_append(out, cal.get(13));
        out.append(" GMT");
        return out.toString();
    }

    public final void addHeader(String name, String value) {
        value = " " + value;
        String o2 = this.headers_.put(name, value);
        if (o2 != null) {
            Vector<String> v2 = new Vector<String>();
            if (o2 instanceof Collection) {
                v2.addAll((Collection)((Object)o2));
            } else {
                v2.add(o2);
            }
            v2.add(value);
            this.headers_.put(name, v2);
        }
    }

    public final void addDateHeader(String name, long date) {
        this.addHeader(name, XDBServletResponse.dateToString(date));
    }

    public final void addIntHeader(String name, int value) {
        this.addHeader(name, Integer.toString(value));
    }

    public final boolean containsHeader(String name) {
        return this.headers_.get(name) != null;
    }

    public final String encodeRedirectUrl(String url) {
        return url;
    }

    public final String encodeRedirectURL(String url) {
        return url;
    }

    public final String encodeUrl(String url) {
        return url;
    }

    public final String encodeURL(String url) {
        return url;
    }

    public final void sendError(int sc) {
        this.sendError(sc, null);
    }

    private final native void send_error(int var1, String var2);

    public final void sendError(int sc, String msg) {
        if (this.committed_) {
            throw new IllegalStateException("Servlet response already commited");
        }
        this.send_error(sc, msg);
        this.committed_ = true;
        this.offset_ = 0;
    }

    private final native String get_req_abspath();

    private final native String get_uri_prefix();

    public final void sendRedirect(String location) throws IOException {
        String absuri = location;
        if (this.committed_) {
            throw new IllegalStateException("Cannot redirect after response is committed");
        }
        this.headers_.clear();
        this.localbuf_ = null;
        if (location.indexOf("://") == -1) {
            String prefix = this.get_uri_prefix();
            if (!location.startsWith(System.getProperty("file.separator"))) {
                absuri = this.get_req_abspath() + absuri;
            }
            if (prefix != null) {
                absuri = prefix + absuri;
            }
        }
        this.setStatus(307);
        this.setHeader("Location", absuri);
        this.writeHeaders();
    }

    public final void setDateHeader(String name, long date) {
        this.headers_.put(name, XDBServletResponse.dateToString(date));
    }

    public final void setHeader(String name, String value) {
        value = " " + value;
        this.headers_.put(name, value);
    }

    public final void setIntHeader(String name, int value) {
        this.headers_.put(name, Integer.toString(value));
    }

    public final void setStatus(int sc) {
        this.statusCode_ = sc;
    }

    public final void setStatus(int sc, String ms) {
        this.setStatus(sc);
    }

    class XDBServletWriter
    extends PrintWriter {
        public XDBServletWriter(PrintWriter pw) {
            super(pw);
        }

        @Override
        public void print(boolean b2) {
            XDBServletResponse.this.writer_.print(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void print(char b2) {
            XDBServletResponse.this.writer_.print(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void print(int b2) {
            XDBServletResponse.this.writer_.print(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void print(float b2) {
            XDBServletResponse.this.writer_.print(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void print(double b2) {
            XDBServletResponse.this.writer_.print(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void print(long b2) {
            XDBServletResponse.this.writer_.print(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void print(Object b2) {
            XDBServletResponse.this.writer_.print(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void print(char[] b2) {
            XDBServletResponse.this.writer_.print(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void print(String b2) {
            XDBServletResponse.this.writer_.print(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void println(boolean b2) {
            XDBServletResponse.this.writer_.println(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void println(char b2) {
            XDBServletResponse.this.writer_.println(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void println(int b2) {
            XDBServletResponse.this.writer_.println(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void println(float b2) {
            XDBServletResponse.this.writer_.println(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void println(double b2) {
            XDBServletResponse.this.writer_.println(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void println(long b2) {
            XDBServletResponse.this.writer_.println(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void println(Object b2) {
            XDBServletResponse.this.writer_.println(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void println(char[] b2) {
            XDBServletResponse.this.writer_.println(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void println(String b2) {
            XDBServletResponse.this.writer_.println(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void write(String b2) {
            XDBServletResponse.this.writer_.write(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void write(String b2, int off, int len) {
            XDBServletResponse.this.writer_.write(b2, off, len);
            XDBServletResponse.this.int_flush();
        }

        public void write(char b2) {
            XDBServletResponse.this.writer_.write(b2);
            XDBServletResponse.this.int_flush();
        }

        @Override
        public void write(char[] b2, int off, int len) {
            XDBServletResponse.this.writer_.write(b2, off, len);
            XDBServletResponse.this.int_flush();
        }
    }
}

