/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.common.regex.xerces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.xml.common.regex.xerces.Match;
import oracle.xml.common.regex.xerces.ReMatch;
import oracle.xml.common.regex.xerces.RegularExpression;

public abstract class GenericEngine<E extends Exception> {
    final RegularExpression m_re;

    public GenericEngine(String string, String string2) throws E {
        this(string, string2, false);
    }

    public GenericEngine(String string, String string2, boolean bl) throws E {
        if (string2 == null || string2.length() == 0) {
            this.m_re = new RegularExpression(string, "X", bl);
        } else {
            if (string2.indexOf(120) >= 0 && string2.indexOf(113) == -1) {
                string = this.eliminateSpaces(string);
            }
            string2 = this.normalizeFlags(string2);
            this.m_re = new RegularExpression(string, string2, bl);
        }
    }

    public String replace(String string, String string2) throws E {
        StringBuilder stringBuilder = new StringBuilder(string);
        Match match = new Match();
        boolean bl = this.m_re.matches(string, match);
        int n2 = 0;
        List<Segment> list = this.compileReplacement(string2, match.getNumberOfGroups());
        while (bl) {
            int n3 = match.getBeginning(0);
            int n4 = match.getEnd(0);
            StringBuilder stringBuilder2 = new StringBuilder();
            for (Segment segment : list) {
                segment.process(stringBuilder2, match);
            }
            stringBuilder.replace(n3 + n2, n4 + n2, stringBuilder2.toString());
            n2 += stringBuilder2.length() + n3 - n4;
            if (n4 == n3) {
                ++n4;
            }
            bl = this.m_re.matches(string, n4, string.length(), match);
        }
        return stringBuilder.toString();
    }

    private List<Segment> compileReplacement(String string, int n2) throws E {
        if (this.m_re.isOptionSet(2048)) {
            return Collections.singletonList(new TextSegment(string));
        }
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '$': {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    int n3 = i2 + 1;
                    while (n3 < string.length() && Character.isDigit(string.charAt(n3))) {
                        stringBuilder2.append(string.charAt(n3));
                        n3 = ++i2 + 1;
                    }
                    if (stringBuilder2.length() == 0) {
                        throw this.createBadReplacementException(string);
                    }
                    int n4 = Integer.valueOf(stringBuilder2.toString());
                    this.flushBuffer(arrayList, stringBuilder);
                    arrayList.add(new ReplacementSegment(n4));
                    continue block4;
                }
                case '\\': {
                    if (i2 + 1 == string.length()) {
                        throw this.createBadReplacementException(string);
                    }
                    char c3 = string.charAt(i2 + 1);
                    if (c3 == '$' || c3 == '\\') {
                        stringBuilder.append(c3);
                        ++i2;
                        continue block4;
                    }
                    throw this.createBadReplacementException(string);
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        this.flushBuffer(arrayList, stringBuilder);
        return arrayList;
    }

    private void flushBuffer(ArrayList<Segment> arrayList, StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            arrayList.add(new TextSegment(stringBuilder.toString()));
            stringBuilder.setLength(0);
        }
    }

    public boolean match(String string) {
        return this.m_re.matches(string);
    }

    public boolean match(String string, int n2, ReMatch reMatch) {
        return this.m_re.matches(string, n2, string.length(), (Match)reMatch);
    }

    public ReMatch createMatchObject() {
        return new Match();
    }

    public int[] getGroupParentIndex() {
        return this.m_re.getGroupParentIndex();
    }

    public Iterator<String> tokenize(final String string) {
        final Match match = new Match();
        return new Iterator<String>(){
            boolean m_hasNext = true;
            int m_lastEnd = 0;

            @Override
            public boolean hasNext() {
                return this.m_hasNext;
            }

            @Override
            public String next() {
                String string2;
                if (!this.m_hasNext) {
                    throw new IllegalStateException();
                }
                if (GenericEngine.this.m_re.matches(string, this.m_lastEnd, string.length(), match)) {
                    string2 = string.substring(this.m_lastEnd, match.getBeginning(0));
                    this.m_lastEnd = match.getEnd(0);
                } else {
                    this.m_hasNext = false;
                    string2 = string.substring(this.m_lastEnd);
                }
                return string2;
            }

            @Override
            public void remove() {
                this.m_hasNext = false;
            }
        };
    }

    private String eliminateSpaces(String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if ((c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 == ' ') && !bl) continue;
            if (c2 == '[') {
                bl = true;
            } else if (c2 == ']') {
                bl = false;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public String normalizeFlags(String string) throws E {
        if (string == null || string.length() == 0) {
            return string;
        }
        boolean[] blArray = new boolean[]{false, false, false, false};
        StringBuilder stringBuilder = new StringBuilder("X");
        int n2 = string.length();
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            switch (string.charAt(i2)) {
                case 's': {
                    if (blArray[0]) continue block7;
                    stringBuilder.append('s');
                    blArray[0] = true;
                    continue block7;
                }
                case 'm': {
                    if (blArray[1]) continue block7;
                    stringBuilder.append('m');
                    blArray[1] = true;
                    continue block7;
                }
                case 'i': {
                    if (blArray[2]) continue block7;
                    stringBuilder.append('i');
                    blArray[2] = true;
                    continue block7;
                }
                case 'x': {
                    continue block7;
                }
                case 'q': {
                    if (blArray[3]) continue block7;
                    stringBuilder.append('q');
                    blArray[3] = true;
                    continue block7;
                }
                default: {
                    throw this.createBadFlagsException(string);
                }
            }
        }
        return stringBuilder.toString();
    }

    public abstract E createBadFlagsException(String var1);

    public abstract E createBadReplacementException(String var1);

    static final class ReplacementSegment
    implements Segment {
        private final int group;

        ReplacementSegment(int n2) {
            this.group = n2;
        }

        @Override
        public void process(StringBuilder stringBuilder, Match match) {
            int n2 = match.getNumberOfGroups() - 1;
            int n3 = this.group;
            int n4 = 1;
            while (true) {
                if (n3 == 0 || n3 <= n2) {
                    String string = match.getCapturedText(n3);
                    if (string == null) break;
                    stringBuilder.append(string);
                    break;
                }
                if (n3 <= 9) break;
                n3 /= 10;
                n4 *= 10;
            }
            if (n4 > 1) {
                stringBuilder.append(this.group - n3 * n4);
            }
        }
    }

    static final class TextSegment
    implements Segment {
        private final String text;

        TextSegment(String string) {
            this.text = string;
        }

        @Override
        public void process(StringBuilder stringBuilder, Match match) {
            stringBuilder.append(this.text);
        }
    }

    static interface Segment {
        public void process(StringBuilder var1, Match var2);
    }
}

