/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import oracle.xml.jdwp.LineTable;
import oracle.xml.jdwp.XSLJDWPBreakpointEvent;
import oracle.xml.jdwp.XSLJDWPClassMatchEventRequest;
import oracle.xml.jdwp.XSLJDWPClassPrepareEvent;
import oracle.xml.jdwp.XSLJDWPDebugger;
import oracle.xml.jdwp.XSLJDWPEvent;
import oracle.xml.jdwp.XSLJDWPEventRequest;
import oracle.xml.jdwp.XSLJDWPEventRequestGroup;
import oracle.xml.jdwp.XSLJDWPEventRequestManager;
import oracle.xml.jdwp.XSLJDWPEventValue;
import oracle.xml.jdwp.XSLJDWPEventValue4ContextNode;
import oracle.xml.jdwp.XSLJDWPEvents;
import oracle.xml.jdwp.XSLJDWPLocation;
import oracle.xml.jdwp.XSLJDWPLocationOnlyEventRequest;
import oracle.xml.jdwp.XSLJDWPMethod;
import oracle.xml.jdwp.XSLJDWPMethodEntryEvent;
import oracle.xml.jdwp.XSLJDWPMethodExitEvent;
import oracle.xml.jdwp.XSLJDWPSingleStepEvent;
import oracle.xml.jdwp.XSLJDWPStepEventRequest;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.jdwp.XSLJDWPVMDeathEvent;
import oracle.xml.jdwp.XSLJDWPVMStartEvent;
import oracle.xml.jdwp.XSLJDWPVirtualMachine;
import oracle.xml.util.NSName;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLStylesheet;

public class XSLJDWPEventManager {
    private static final int IS_CALL_TEMPLATE = 1;
    private static final int IS_APPLY_TEMPLATES = 2;
    private static final int IS_NONE_TEMPLATE = 3;
    private static final int IS_APPLY_IMPORTS = 4;
    private XSLJDWPEvents events;
    private XSLJDWPLocation currentlocation;
    private boolean reportnextsinglestepevent = false;
    private int currentRequestID;
    private LinkedList haltpoints = new LinkedList();
    private long methodendpoint = -1L;
    private boolean removeframe = false;
    private XSLJDWPEventValue ev;
    private boolean hitxmlbk = false;

    public XSLJDWPEventManager(XSLStylesheet xSLStylesheet) {
        this.events = new XSLJDWPEvents(xSLStylesheet);
    }

    synchronized void addSourceNode(XSLJDWPEventValue4ContextNode xSLJDWPEventValue4ContextNode) {
        XSLJDWPLocation xSLJDWPLocation = this.calculateSourceNodeLocation(xSLJDWPEventValue4ContextNode);
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue4ContextNode.getXSLStylesheet();
        int n2 = xSLJDWPLocation.getClassID();
        if (!xSLStylesheet.getJDWPVirtualMachine().getXMLSourceClassIDs().contains(new Integer(n2))) {
            return;
        }
        XSLJDWPEvent xSLJDWPEvent = this.reportBreakpointEvent(xSLJDWPEventValue4ContextNode, xSLJDWPLocation);
        if (xSLJDWPEvent != null) {
            this.events.add(xSLJDWPEvent);
            this.events.setCompositeDone();
            this.addFrame(xSLJDWPEventValue4ContextNode, xSLJDWPLocation);
            this.events.add();
            xSLStylesheet.suspendDebugger(true);
            this.hitxmlbk = true;
            while (xSLStylesheet.waitMode()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.events.reset();
            this.reportSingleStepEvent(this.ev);
        }
    }

    synchronized void addEventValue(XSLJDWPEventValue xSLJDWPEventValue) {
        boolean bl;
        XSLJDWPLocation xSLJDWPLocation;
        this.ev = xSLJDWPEventValue;
        this.currentlocation = xSLJDWPLocation = this.calculateGeneralLocation(xSLJDWPEventValue);
        XSLJDWPEvent xSLJDWPEvent = this.reportEvent(xSLJDWPEventValue);
        if (xSLJDWPEvent != null) {
            this.events.add(xSLJDWPEvent);
        }
        if (xSLJDWPEvent != null && (xSLJDWPEvent.getEventKind() == 90 || xSLJDWPEvent.getEventKind() == 99 || xSLJDWPEvent.getEventKind() == 6 || xSLJDWPEvent.getEventKind() == 7)) {
            this.events.add();
            return;
        }
        xSLJDWPEvent = this.reportClassPrepareEvent(xSLJDWPEventValue);
        if (xSLJDWPEvent != null) {
            this.events.add(xSLJDWPEvent);
            this.events.add();
            this.halt(xSLJDWPEventValue, xSLJDWPLocation);
            this.events.reset();
        }
        if ((xSLJDWPEvent = this.reportBreakpointEvent(xSLJDWPEventValue, xSLJDWPLocation)) != null) {
            this.events.add(xSLJDWPEvent);
        }
        if (this.reportnextsinglestepevent && ((bl = this.isStartCodeIndex(xSLJDWPEventValue, xSLJDWPLocation)) || this.hitxmlbk)) {
            xSLJDWPEvent = new XSLJDWPSingleStepEvent(this.currentRequestID, xSLJDWPLocation);
            this.events.add(xSLJDWPEvent);
            this.reportnextsinglestepevent = false;
            this.hitxmlbk = false;
        }
        this.events.setCompositeDone();
        this.events.add();
        this.halt(xSLJDWPEventValue, xSLJDWPLocation);
        if (this.removeframe) {
            this.removeFrame(xSLJDWPEventValue, xSLJDWPLocation);
        }
        this.events.reset();
        this.reportSingleStepEvent(xSLJDWPEventValue);
        if (xSLJDWPEventValue.getCodeIndex() == this.methodendpoint) {
            this.reportnextsinglestepevent = true;
            this.methodendpoint = -1L;
        }
    }

    private void removeFrame(XSLJDWPEventValue xSLJDWPEventValue, XSLJDWPLocation xSLJDWPLocation) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        if (xSLStylesheet.getFrames().size() > 0) {
            xSLStylesheet.getFrames().removeLast();
        }
        if (xSLStylesheet.getFrameValues().size() > 0) {
            xSLStylesheet.getFrameValues().removeLast();
        }
        if (xSLStylesheet.getFrameParams().size() > 0) {
            xSLStylesheet.getFrameParams().removeLast();
        }
        XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Frame removed :" + xSLJDWPLocation.getClassID() + ":" + xSLJDWPLocation.getMethodID() + ":" + xSLJDWPLocation.getIndex());
    }

    private void addFrame(XSLJDWPEventValue4ContextNode xSLJDWPEventValue4ContextNode, XSLJDWPLocation xSLJDWPLocation) {
        XSLJDWPLocation xSLJDWPLocation2;
        int n2;
        int n3;
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue4ContextNode.getXSLStylesheet();
        XSLJDWPVirtualMachine xSLJDWPVirtualMachine = xSLStylesheet.getJDWPVirtualMachine();
        Vector vector = xSLJDWPVirtualMachine.getXMLSourceClassIDs();
        LinkedList linkedList = xSLStylesheet.getFrames();
        int n4 = -1;
        for (n4 = linkedList.size() - 1; n4 >= 0 && (n3 = vector.indexOf(new Integer(n2 = (xSLJDWPLocation2 = (XSLJDWPLocation)linkedList.get(n4)).getClassID()))) == -1; --n4) {
        }
        if (n4 != -1) {
            this.remove3frames(xSLStylesheet, n4);
        }
        this.add3frames(xSLStylesheet, xSLJDWPLocation);
    }

    private void remove3frames(XSLStylesheet xSLStylesheet, int n2) {
        xSLStylesheet.getFrames().remove(n2);
        xSLStylesheet.getFrameValues().remove(n2);
        xSLStylesheet.getFrameParams().remove(n2);
    }

    private void add3frames(XSLStylesheet xSLStylesheet, XSLJDWPLocation xSLJDWPLocation) {
        xSLStylesheet.getFrames().add(xSLJDWPLocation);
        xSLStylesheet.getFrameValues().add(new LinkedList());
        xSLStylesheet.getFrameParams().add(new Integer(1));
    }

    private void addFrame(XSLJDWPEventValue xSLJDWPEventValue, XSLJDWPLocation xSLJDWPLocation, byte by) {
        if (xSLJDWPLocation.getClassID() <= 0 || xSLJDWPLocation.getMethodID() <= 0) {
            return;
        }
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        LinkedList linkedList = xSLStylesheet.getFrames();
        switch (by) {
            case 10: {
                this.add3frames(xSLStylesheet, xSLJDWPLocation);
                break;
            }
            case 40: {
                if (linkedList.getLast() == null) {
                    linkedList.set(linkedList.size() - 1, xSLJDWPLocation);
                    break;
                }
                this.add3frames(xSLStylesheet, xSLJDWPLocation);
                break;
            }
        }
        int n2 = xSLStylesheet.getFrameValues().size() - 1;
        XPathSequence xPathSequence = new XPathSequence(xSLJDWPEventValue.getXSLTContext());
        try {
            XPathSequence.setStringValue(xPathSequence, xSLJDWPEventValue.getName());
        }
        catch (XQException xQException) {
            // empty catch block
        }
        LinkedList linkedList2 = (LinkedList)xSLStylesheet.getFrameValues().get(n2);
        linkedList2.add(0, xPathSequence);
        XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Frame added :" + xSLJDWPLocation.getClassID() + ":" + xSLJDWPLocation.getMethodID() + ":" + xSLJDWPLocation.getIndex());
    }

    private void updateFrameLocation(XSLStylesheet xSLStylesheet) {
        if (xSLStylesheet == null || xSLStylesheet.getFrames() == null || xSLStylesheet.getFrames().size() == 0) {
            return;
        }
        if (this.currentlocation == null || this.currentlocation.getClassID() <= 0 || this.currentlocation.getMethodID() <= 0 || this.currentlocation.getIndex() <= 0L || this.currentlocation.getLine() <= 0) {
            return;
        }
        XSLJDWPVirtualMachine xSLJDWPVirtualMachine = xSLStylesheet.getJDWPVirtualMachine();
        Vector vector = xSLJDWPVirtualMachine.getXMLSourceClassIDs();
        int n2 = this.currentlocation.getClassID();
        int n3 = vector.indexOf(new Integer(n2));
        LinkedList linkedList = xSLStylesheet.getFrames();
        if (n3 != -1) {
            XSLJDWPLocation xSLJDWPLocation;
            int n4;
            int n5;
            int n6 = -1;
            for (n6 = linkedList.size() - 1; n6 >= 0 && (n5 = vector.indexOf(new Integer(n4 = (xSLJDWPLocation = (XSLJDWPLocation)linkedList.get(n6)).getClassID()))) == -1; --n6) {
            }
            if (n6 != -1) {
                this.remove3frames(xSLStylesheet, n6);
            }
            this.add3frames(xSLStylesheet, this.currentlocation);
        } else {
            XSLJDWPLocation xSLJDWPLocation;
            int n7 = -1;
            for (n7 = linkedList.size() - 1; !(n7 < 0 || (xSLJDWPLocation = (XSLJDWPLocation)linkedList.get(n7)) != null && this.inSameLine(xSLJDWPLocation, this.currentlocation)); --n7) {
            }
            if (n7 != -1) {
                for (int i2 = linkedList.size() - 1; i2 >= 0; --i2) {
                    int n8;
                    int n9;
                    XSLJDWPLocation xSLJDWPLocation2 = (XSLJDWPLocation)linkedList.get(i2);
                    if (xSLJDWPLocation2 == null || (n9 = vector.indexOf(new Integer(n8 = xSLJDWPLocation2.getClassID()))) == -1) continue;
                    this.remove3frames(xSLStylesheet, i2);
                    break;
                }
                linkedList.set(n7, this.currentlocation);
            } else {
                xSLJDWPLocation = (XSLJDWPLocation)xSLStylesheet.getFrames().getLast();
                if (xSLJDWPLocation != null) {
                    xSLJDWPLocation.setClassID(this.currentlocation.getClassID());
                    xSLJDWPLocation.setMethodID(this.currentlocation.getMethodID());
                    xSLJDWPLocation.setIndex(this.currentlocation.getIndex());
                    xSLJDWPLocation.setLine(this.currentlocation.getLine());
                }
            }
        }
    }

    private boolean inSameLine(XSLJDWPLocation xSLJDWPLocation, XSLJDWPLocation xSLJDWPLocation2) {
        if (xSLJDWPLocation.getClassID() != xSLJDWPLocation2.getClassID()) {
            return false;
        }
        if (xSLJDWPLocation.getMethodID() != xSLJDWPLocation2.getMethodID()) {
            return false;
        }
        return xSLJDWPLocation.getLine() == xSLJDWPLocation2.getLine();
    }

    private boolean isStartCodeIndex(XSLJDWPEventValue xSLJDWPEventValue, XSLJDWPLocation xSLJDWPLocation) {
        int n2;
        int n3 = xSLJDWPLocation.getClassID();
        if (n3 < 1) {
            return false;
        }
        int n4 = xSLJDWPLocation.getMethodID();
        if (n4 < 0) {
            return false;
        }
        long l2 = xSLJDWPEventValue.getCodeIndex();
        if (l2 < 1L) {
            return false;
        }
        LineTable lineTable = xSLJDWPEventValue.getXSLStylesheet().getJDWPMethod().getLineTable(n3, n4);
        long[] lArray = lineTable.getLineCodeIndex();
        for (n2 = 0; n2 < lineTable.getLines() && lArray[n2] < l2; ++n2) {
        }
        return n2 < lineTable.getLines() && lArray[n2] == l2;
    }

    private XSLJDWPLocation calculateGeneralLocation(XSLJDWPEventValue xSLJDWPEventValue) {
        int n2 = this.getClassID(xSLJDWPEventValue);
        XSLJDWPMethod xSLJDWPMethod = xSLJDWPEventValue.getXSLStylesheet().getJDWPMethod();
        long l2 = xSLJDWPEventValue.getCodeIndex();
        int n3 = this.getMethodIDFromLineTable(n2, l2, xSLJDWPMethod);
        XSLJDWPLocation xSLJDWPLocation = new XSLJDWPLocation(1, n2, n3, l2);
        xSLJDWPLocation.setLine(xSLJDWPEventValue.getLineNumber());
        return xSLJDWPLocation;
    }

    private XSLJDWPLocation calculateSourceNodeLocation(XSLJDWPEventValue4ContextNode xSLJDWPEventValue4ContextNode) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue4ContextNode.getXSLStylesheet();
        String string = xSLJDWPEventValue4ContextNode.getBaseURL();
        int n2 = xSLStylesheet.getJDWPVirtualMachine().getClassID(string);
        long l2 = xSLJDWPEventValue4ContextNode.getLineNumber();
        int n3 = 1;
        return new XSLJDWPLocation(1, n2, n3, l2);
    }

    private void halt(XSLJDWPEventValue xSLJDWPEventValue, XSLJDWPLocation xSLJDWPLocation) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        int n2 = this.events.getEvents();
        if (n2 == 0) {
            Object object;
            int n3;
            int n4 = this.haltpoints.size();
            if (n4 == 0) {
                return;
            }
            long l2 = xSLJDWPEventValue.getCodeIndex();
            for (n3 = 0; n3 < n4 && (Long)(object = (Long)this.haltpoints.get(n3)) != l2; ++n3) {
            }
            if (n3 < n4) {
                this.haltpoints.remove(n3);
                object = new XSLJDWPSingleStepEvent(this.currentRequestID, xSLJDWPLocation);
                this.events.add((XSLJDWPEvent)object);
                this.events.add();
                this.halt(xSLJDWPEventValue, xSLJDWPLocation);
                this.events.reset();
                this.reportSingleStepEvent(xSLJDWPEventValue);
            }
        } else if (n2 == 1) {
            XSLJDWPEvent xSLJDWPEvent = this.events.getEvent(0);
            byte by = xSLJDWPEvent.getEventKind();
            switch (by) {
                case 8: {
                    XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Class Prepare Event");
                    xSLStylesheet.suspendDebugger(true);
                    break;
                }
                case 1: {
                    XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Single Step Event");
                    xSLStylesheet.suspendDebugger(true);
                    break;
                }
                case 2: {
                    XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Breakpoint Event");
                    xSLStylesheet.suspendDebugger(true);
                    break;
                }
                case 40: {
                    xSLStylesheet.suspendDebugger(true);
                    XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Method Entry Event");
                    break;
                }
                case 41: {
                    xSLStylesheet.suspendDebugger(true);
                    XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Method Exit Event");
                    break;
                }
            }
        } else {
            xSLStylesheet.suspendDebugger(true);
            XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Group Events");
        }
        XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "stopped & waiting ...");
        while (xSLStylesheet.waitMode()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void addHaltPoint(long l2) {
        Long l3 = new Long(l2);
        if (this.haltpoints.contains(l3)) {
            return;
        }
        this.haltpoints.add(l3);
    }

    private XSLJDWPEvent reportSingleStepEvent(XSLJDWPEventValue xSLJDWPEventValue) {
        long l2 = xSLJDWPEventValue.getCodeIndex();
        if (l2 == 0L) {
            return null;
        }
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        ArrayList<NSName> arrayList = xSLStylesheet.getUserDefinedFunctions();
        XSLJDWPDebugger xSLJDWPDebugger = xSLStylesheet.getJDWPDebugger();
        int n2 = this.getClassID(xSLJDWPEventValue);
        XSLJDWPMethod xSLJDWPMethod = xSLStylesheet.getJDWPMethod();
        int n3 = this.getMethodIDFromLineTable(n2, l2, xSLJDWPMethod);
        XSLJDWPEventRequestManager xSLJDWPEventRequestManager = xSLJDWPDebugger.getEventRequestManager();
        int n4 = xSLJDWPEventRequestManager.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            XSLJDWPEventRequestGroup xSLJDWPEventRequestGroup = (XSLJDWPEventRequestGroup)xSLJDWPEventRequestManager.get(i2);
            if (xSLJDWPEventRequestGroup.getEventKind() != 1) continue;
            XSLJDWPEventRequest[] xSLJDWPEventRequestArray = xSLJDWPEventRequestGroup.getXSLJDWPEventRequests();
            int n5 = xSLJDWPEventRequestGroup.getModifiers();
            for (int i3 = 0; i3 < n5; ++i3) {
                XSLJDWPEventRequest xSLJDWPEventRequest = xSLJDWPEventRequestArray[i3];
                if (xSLJDWPEventRequest == null || xSLJDWPEventRequest.getModKind() != 10) continue;
                Object var18_17 = null;
                int n6 = ((XSLJDWPStepEventRequest)xSLJDWPEventRequest).getDepth();
                if (n6 == 2) {
                    this.reportnextsinglestepevent = false;
                    this.methodendpoint = this.calculateEndOfMethodLocation(n2, n3, xSLJDWPMethod);
                } else {
                    String string = xSLJDWPEventValue.getConcatedAttrs();
                    int n7 = this.getStatementType(xSLJDWPEventValue);
                    if (this.isUserDefinedFunction(arrayList, string)) {
                        n7 = 1;
                    }
                    block0 : switch (n7) {
                        case 2: 
                        case 3: {
                            this.reportnextsinglestepevent = true;
                            break;
                        }
                        case 1: 
                        case 4: {
                            switch (n6) {
                                case 0: {
                                    this.reportnextsinglestepevent = true;
                                    break block0;
                                }
                                case 1: {
                                    this.calculateStepOverLocation(n2, n3, l2, xSLJDWPMethod);
                                }
                            }
                        }
                    }
                }
                this.currentRequestID = xSLJDWPEventRequestGroup.getRequestID();
                xSLJDWPEventRequestManager.remove(xSLJDWPEventRequestGroup);
                return null;
            }
        }
        return null;
    }

    private boolean isUserDefinedFunction(ArrayList<NSName> arrayList, String string) {
        if (arrayList == null || string == null) {
            return false;
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            int n2;
            int n3;
            NSName nSName = arrayList.get(i2);
            String string2 = nSName.getPrefix();
            String string3 = nSName.getLocalName();
            if (string2 != null && string2.length() > 0) {
                string3 = string2 + ":" + string3;
            }
            if ((n3 = string.indexOf(string3)) == -1 || n3 != 0 && string.charAt(n3 - 1) != ' ' || string.charAt(n2 = n3 + string3.length()) != '(') continue;
            return true;
        }
        return false;
    }

    private long calculateEndOfMethodLocation(int n2, int n3, XSLJDWPMethod xSLJDWPMethod) {
        LineTable lineTable = xSLJDWPMethod.getLineTable(n2, n3);
        if (lineTable == null) {
            this.methodendpoint = -1L;
            this.reportnextsinglestepevent = true;
            return this.methodendpoint;
        }
        long[] lArray = lineTable.getLineCodeIndex();
        return lArray[lineTable.getLines() - 1];
    }

    private void calculateStepOverLocation(int n2, int n3, long l2, XSLJDWPMethod xSLJDWPMethod) {
        LineTable lineTable = xSLJDWPMethod.getLineTable(n2, n3);
        long[] lArray = lineTable.getLineCodeIndex();
        int n4 = 0;
        while (lArray[n4] != l2) {
            ++n4;
        }
        if (n4 + 1 < lArray.length) {
            this.addHaltPoint(lArray[n4 + 1]);
        } else {
            this.reportnextsinglestepevent = true;
        }
    }

    private int getStatementType(XSLJDWPEventValue xSLJDWPEventValue) {
        String string = xSLJDWPEventValue.getInstructionName().intern();
        if (string == "xsl:apply-templates") {
            return 2;
        }
        if (string == "xsl:apply-imports") {
            return 4;
        }
        if (string == "xsl:call-template") {
            return 1;
        }
        return 3;
    }

    private int getMethodIDFromLineTable(int n2, long l2, XSLJDWPMethod xSLJDWPMethod) {
        int n3 = 2;
        LineTable lineTable = xSLJDWPMethod.getLineTable(n2, n3);
        while (lineTable != null) {
            long l3 = lineTable.getStart();
            long l4 = lineTable.getEnd();
            if (l2 >= l3 && l2 <= l4) {
                return n3;
            }
            lineTable = xSLJDWPMethod.getLineTable(n2, ++n3);
        }
        return 1;
    }

    private XSLJDWPEvent reportClassPrepareEvent(XSLJDWPEventValue xSLJDWPEventValue) {
        XSLJDWPClassPrepareEvent xSLJDWPClassPrepareEvent = null;
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        XSLJDWPDebugger xSLJDWPDebugger = xSLStylesheet.getJDWPDebugger();
        if (xSLJDWPDebugger == null) {
            return null;
        }
        XSLJDWPEventRequestManager xSLJDWPEventRequestManager = xSLJDWPDebugger.getEventRequestManager();
        int n2 = xSLJDWPEventRequestManager.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            XSLJDWPEventRequestGroup xSLJDWPEventRequestGroup = (XSLJDWPEventRequestGroup)xSLJDWPEventRequestManager.get(i2);
            if (xSLJDWPEventRequestGroup.getEventKind() != 8 || (n3 = xSLJDWPEventRequestGroup.getModifiers()) == 0) continue;
            XSLJDWPEventRequest[] xSLJDWPEventRequestArray = xSLJDWPEventRequestGroup.getXSLJDWPEventRequests();
            for (int i3 = 0; i3 < n3; ++i3) {
                XSLJDWPEventRequest xSLJDWPEventRequest = xSLJDWPEventRequestArray[i3];
                if (xSLJDWPEventRequest == null || xSLJDWPEventRequest.getModKind() != 5) continue;
                String string = null;
                String string2 = null;
                Hashtable hashtable = xSLStylesheet.getJDWPVirtualMachine().getAllClassesByID();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    try {
                        Integer n4 = (Integer)enumeration.nextElement();
                        string2 = (String)hashtable.get(n4);
                        URL uRL = new URL(string2);
                        string = XSLJDWPUtil.getClassName(uRL);
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                    if (!string.equals(((XSLJDWPClassMatchEventRequest)xSLJDWPEventRequest).getClassPattern())) continue;
                    this.events.setSuspendPolicy(xSLJDWPEventRequestGroup.getSuspendPolicy());
                    int n5 = xSLJDWPEventRequestGroup.getRequestID();
                    xSLJDWPClassPrepareEvent = new XSLJDWPClassPrepareEvent(xSLStylesheet, n5, string, string2);
                    xSLJDWPEventRequestManager.remove(xSLJDWPEventRequestGroup);
                    return xSLJDWPClassPrepareEvent;
                }
            }
        }
        return xSLJDWPClassPrepareEvent;
    }

    private XSLJDWPEvent reportBreakpointEvent(XSLJDWPEventValue4ContextNode xSLJDWPEventValue4ContextNode, XSLJDWPLocation xSLJDWPLocation) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue4ContextNode.getXSLStylesheet();
        XSLJDWPDebugger xSLJDWPDebugger = xSLStylesheet.getJDWPDebugger();
        XSLJDWPEventRequestManager xSLJDWPEventRequestManager = xSLJDWPDebugger.getEventRequestManager();
        int n2 = xSLJDWPEventRequestManager.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSLJDWPEventRequestGroup xSLJDWPEventRequestGroup = (XSLJDWPEventRequestGroup)xSLJDWPEventRequestManager.get(i2);
            if (xSLJDWPEventRequestGroup.getEventKind() != 2) continue;
            XSLJDWPEventRequest[] xSLJDWPEventRequestArray = xSLJDWPEventRequestGroup.getXSLJDWPEventRequests();
            int n3 = xSLJDWPEventRequestGroup.getModifiers();
            for (int i3 = 0; i3 < n3; ++i3) {
                XSLJDWPLocation xSLJDWPLocation2;
                XSLJDWPEventRequest xSLJDWPEventRequest = xSLJDWPEventRequestArray[i3];
                if (xSLJDWPEventRequest.getModKind() != 7 || !this.compare(xSLJDWPLocation2 = ((XSLJDWPLocationOnlyEventRequest)xSLJDWPEventRequest).getLocation(), xSLJDWPLocation)) continue;
                this.events.setSuspendPolicy(xSLJDWPEventRequestGroup.getSuspendPolicy());
                XSLJDWPBreakpointEvent xSLJDWPBreakpointEvent = new XSLJDWPBreakpointEvent(xSLJDWPLocation2);
                xSLJDWPBreakpointEvent.setThreadID(1);
                xSLJDWPBreakpointEvent.setRequestID(xSLJDWPEventRequestGroup.getRequestID());
                XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "XML Source Breakpoint hit!");
                return xSLJDWPBreakpointEvent;
            }
        }
        return null;
    }

    private XSLJDWPEvent reportBreakpointEvent(XSLJDWPEventValue xSLJDWPEventValue, XSLJDWPLocation xSLJDWPLocation) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        XSLJDWPDebugger xSLJDWPDebugger = xSLStylesheet.getJDWPDebugger();
        XSLJDWPEventRequestManager xSLJDWPEventRequestManager = xSLJDWPDebugger.getEventRequestManager();
        int n2 = xSLJDWPEventRequestManager.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSLJDWPEventRequestGroup xSLJDWPEventRequestGroup = (XSLJDWPEventRequestGroup)xSLJDWPEventRequestManager.get(i2);
            if (xSLJDWPEventRequestGroup.getEventKind() != 2) continue;
            XSLJDWPEventRequest[] xSLJDWPEventRequestArray = xSLJDWPEventRequestGroup.getXSLJDWPEventRequests();
            int n3 = xSLJDWPEventRequestGroup.getModifiers();
            for (int i3 = 0; i3 < n3; ++i3) {
                XSLJDWPLocation xSLJDWPLocation2;
                XSLJDWPEventRequest xSLJDWPEventRequest = xSLJDWPEventRequestArray[i3];
                if (xSLJDWPEventRequest.getModKind() != 7 || !this.compare(xSLJDWPLocation2 = ((XSLJDWPLocationOnlyEventRequest)xSLJDWPEventRequest).getLocation(), xSLJDWPLocation)) continue;
                this.haltpoints.clear();
                this.methodendpoint = -1L;
                this.events.setSuspendPolicy(xSLJDWPEventRequestGroup.getSuspendPolicy());
                XSLJDWPBreakpointEvent xSLJDWPBreakpointEvent = new XSLJDWPBreakpointEvent(xSLJDWPLocation2);
                xSLJDWPBreakpointEvent.setThreadID(1);
                xSLJDWPBreakpointEvent.setRequestID(xSLJDWPEventRequestGroup.getRequestID());
                XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Breakpoint hit!");
                return xSLJDWPBreakpointEvent;
            }
        }
        return null;
    }

    private XSLJDWPEvent reportEvent(XSLJDWPEventValue xSLJDWPEventValue) {
        XSLJDWPEvent xSLJDWPEvent = null;
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        this.removeframe = false;
        switch (xSLJDWPEventValue.getEventKind()) {
            case 90: {
                xSLJDWPEvent = new XSLJDWPVMStartEvent();
                this.events.setSuspendPolicy((byte)2);
                break;
            }
            case 99: {
                xSLJDWPEvent = new XSLJDWPVMDeathEvent();
                this.events.setSuspendPolicy((byte)0);
                break;
            }
            case 6: {
                xSLJDWPEvent = xSLJDWPEventValue.getEvent();
                this.events.setSuspendPolicy(xSLJDWPEventValue.getSuspendPolicy());
                break;
            }
            case 7: {
                xSLJDWPEvent = xSLJDWPEventValue.getEvent();
                this.events.setSuspendPolicy(xSLJDWPEventValue.getSuspendPolicy());
                break;
            }
            case 2: {
                break;
            }
            case 10: {
                XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "CLASS_LOAD Event can be fired");
                XSLJDWPLocation xSLJDWPLocation = this.calculateGeneralLocation(xSLJDWPEventValue);
                this.addFrame(xSLJDWPEventValue, xSLJDWPLocation, (byte)10);
                break;
            }
            case 9: {
                XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "CLASS_UNLOAD Event can be fired");
                XSLJDWPLocation xSLJDWPLocation = this.calculateGeneralLocation(xSLJDWPEventValue);
                this.removeframe = true;
                break;
            }
            case 40: {
                XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "METHOD_ENTRY Event can be fired");
                XSLJDWPLocation xSLJDWPLocation = this.calculateGeneralLocation(xSLJDWPEventValue);
                this.addFrame(xSLJDWPEventValue, xSLJDWPLocation, (byte)40);
                xSLJDWPEvent = this.reportMethodEntryExitEvent(xSLJDWPEventValue, xSLJDWPLocation, true);
                break;
            }
            case 41: {
                XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "METHOD_EXIT Event can be fired");
                XSLJDWPLocation xSLJDWPLocation = this.calculateGeneralLocation(xSLJDWPEventValue);
                this.removeframe = true;
                xSLJDWPEvent = this.reportMethodEntryExitEvent(xSLJDWPEventValue, xSLJDWPLocation, false);
                break;
            }
        }
        this.updateFrameLocation(xSLStylesheet);
        return xSLJDWPEvent;
    }

    private int getClassID(XSLJDWPEventValue xSLJDWPEventValue) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        String string = xSLJDWPEventValue.getBaseURL();
        if (string == null) {
            return 0;
        }
        int n2 = xSLStylesheet.getJDWPVirtualMachine().getClassID(string);
        return n2;
    }

    private XSLJDWPEvent reportMethodEntryExitEvent(XSLJDWPEventValue xSLJDWPEventValue, XSLJDWPLocation xSLJDWPLocation, boolean bl) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        XSLJDWPDebugger xSLJDWPDebugger = xSLStylesheet.getJDWPDebugger();
        XSLJDWPEventRequestManager xSLJDWPEventRequestManager = xSLJDWPDebugger.getEventRequestManager();
        int n2 = xSLJDWPEventRequestManager.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            XSLJDWPEventRequestGroup xSLJDWPEventRequestGroup = (XSLJDWPEventRequestGroup)xSLJDWPEventRequestManager.get(i2);
            if (bl && xSLJDWPEventRequestGroup.getEventKind() != 40 || !bl && xSLJDWPEventRequestGroup.getEventKind() != 41) continue;
            XSLJDWPEventRequest[] xSLJDWPEventRequestArray = xSLJDWPEventRequestGroup.getXSLJDWPEventRequests();
            int n4 = xSLJDWPEventRequestGroup.getModifiers();
            for (n3 = 0; n3 < n4; ++n3) {
                XSLJDWPEventRequest xSLJDWPEventRequest = xSLJDWPEventRequestArray[n3];
                if (xSLJDWPEventRequest == null || xSLJDWPEventRequest.getModKind() != 5) continue;
                String string = null;
                String string2 = null;
                Hashtable hashtable = xSLStylesheet.getJDWPVirtualMachine().getAllClassesByID();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    try {
                        Integer n5 = (Integer)enumeration.nextElement();
                        string2 = (String)hashtable.get(n5);
                        URL uRL = new URL(string2);
                        string = XSLJDWPUtil.getClassName(uRL);
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                    if (!string.equals(((XSLJDWPClassMatchEventRequest)xSLJDWPEventRequest).getClassPattern())) continue;
                    this.events.setSuspendPolicy(xSLJDWPEventRequestGroup.getSuspendPolicy());
                    int n6 = xSLJDWPEventRequestGroup.getRequestID();
                    XSLJDWPEvent xSLJDWPEvent = bl ? new XSLJDWPMethodEntryEvent(n6, 1, xSLJDWPLocation) : new XSLJDWPMethodExitEvent(n6, 1, xSLJDWPLocation);
                    xSLJDWPEventRequestManager.remove(xSLJDWPEventRequestGroup);
                    return xSLJDWPEvent;
                }
            }
            if (n3 != n4) continue;
            this.events.setSuspendPolicy(xSLJDWPEventRequestGroup.getSuspendPolicy());
            int n7 = xSLJDWPEventRequestGroup.getRequestID();
            XSLJDWPEvent xSLJDWPEvent = bl ? new XSLJDWPMethodEntryEvent(n7, 1, xSLJDWPLocation) : new XSLJDWPMethodExitEvent(n7, 1, xSLJDWPLocation);
            return xSLJDWPEvent;
        }
        return null;
    }

    private boolean compare(XSLJDWPLocation xSLJDWPLocation, XSLJDWPLocation xSLJDWPLocation2) {
        if (xSLJDWPLocation2.getClassID() != xSLJDWPLocation.getClassID()) {
            return false;
        }
        if (xSLJDWPLocation2.getMethodID() != xSLJDWPLocation.getMethodID()) {
            return false;
        }
        return xSLJDWPLocation2.getIndex() == xSLJDWPLocation.getIndex();
    }
}

