/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPLocation;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketValue;

class XSLJDWPPacketStream
implements XSLJDWPConstants {
    private int inCursor = 0;
    private XSLJDWPPacket pkt;
    private ByteArrayOutputStream dataStream = new ByteArrayOutputStream();

    XSLJDWPPacketStream(XSLJDWPPacket xSLJDWPPacket) {
        this.pkt = xSLJDWPPacket;
    }

    XSLJDWPPacket packet() {
        return this.pkt;
    }

    void setVMDeath() {
        this.pkt.setVMDeath();
    }

    static boolean isObjectTag(byte by) {
        return by == 76 || by == 91 || by == 115 || by == 116 || by == 103 || by == 108 || by == 99;
    }

    int readArrayID() {
        return this.readObjectID();
    }

    boolean readBoolean() {
        byte by = this.readByte();
        return by != 0;
    }

    byte readByte() {
        byte by = this.pkt.data[this.inCursor];
        ++this.inCursor;
        return by;
    }

    char readChar() {
        int n2 = this.pkt.data[this.inCursor++] & 0xFF;
        int n3 = this.pkt.data[this.inCursor++] & 0xFF;
        return (char)((n2 << 8) + n3);
    }

    int readClassID() {
        return this.readInt();
    }

    double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    int readFieldID() {
        return this.readInt();
    }

    int readFrameID() {
        return this.readInt();
    }

    int readInt() {
        int n2 = this.pkt.data.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.inCursor < n2) {
            n3 = this.pkt.data[this.inCursor++] & 0xFF;
        }
        if (this.inCursor < n2) {
            n4 = this.pkt.data[this.inCursor++] & 0xFF;
        }
        if (this.inCursor < n2) {
            n5 = this.pkt.data[this.inCursor++] & 0xFF;
        }
        if (this.inCursor < n2) {
            n6 = this.pkt.data[this.inCursor++] & 0xFF;
        }
        return (n3 << 24) + (n4 << 16) + (n5 << 8) + n6;
    }

    XSLJDWPLocation readLocation() throws XSLJDWPException {
        byte by = this.readByte();
        int n2 = this.readObjectID();
        int n3 = this.readMethodID();
        long l2 = this.readLong();
        if (n2 == 0) {
            return null;
        }
        return new XSLJDWPLocation(by, n2, n3, l2);
    }

    long readLong() {
        long l2 = this.pkt.data[this.inCursor++] & 0xFF;
        long l3 = this.pkt.data[this.inCursor++] & 0xFF;
        long l4 = this.pkt.data[this.inCursor++] & 0xFF;
        long l5 = this.pkt.data[this.inCursor++] & 0xFF;
        long l6 = this.pkt.data[this.inCursor++] & 0xFF;
        long l7 = this.pkt.data[this.inCursor++] & 0xFF;
        long l8 = this.pkt.data[this.inCursor++] & 0xFF;
        long l9 = this.pkt.data[this.inCursor++] & 0xFF;
        return (l2 << 56) + (l3 << 48) + (l4 << 40) + (l5 << 32) + (l6 << 24) + (l7 << 16) + (l8 << 8) + l9;
    }

    int readMethodID() {
        return this.readInt();
    }

    int readObjectID() {
        return this.readInt();
    }

    int readReferenceType() {
        return this.readObjectID();
    }

    short readShort() {
        int n2 = this.pkt.data[this.inCursor++] & 0xFF;
        int n3 = this.pkt.data[this.inCursor++] & 0xFF;
        return (short)((n2 << 8) + n3);
    }

    String readString() throws XSLJDWPException {
        String string;
        int n2 = this.readInt();
        try {
            string = new String(this.pkt.data, this.inCursor, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XSLJDWPException(unsupportedEncodingException, 113);
        }
        finally {
            this.inCursor += n2;
        }
        return string;
    }

    int readThreadID() {
        return this.readObjectID();
    }

    void close() {
        this.pkt.data = this.dataStream.toByteArray();
    }

    void writeArrayRegion(byte by, XSLJDWPPacketValue[] xSLJDWPPacketValueArray) throws XSLJDWPException {
        this.writeByte(by);
        this.writeInt(xSLJDWPPacketValueArray.length);
        for (int i2 = 0; i2 < xSLJDWPPacketValueArray.length; ++i2) {
            XSLJDWPPacketValue xSLJDWPPacketValue = xSLJDWPPacketValueArray[i2];
            if (XSLJDWPPacketStream.isObjectTag(xSLJDWPPacketValue.getType())) {
                this.writeValue(xSLJDWPPacketValue);
                continue;
            }
            this.writeUntaggedValue(xSLJDWPPacketValue);
        }
    }

    void writeBoolean(boolean bl) {
        if (bl) {
            this.dataStream.write(1);
        } else {
            this.dataStream.write(0);
        }
    }

    void writeByte(byte by) {
        this.dataStream.write(by);
    }

    void writeByteArray(byte[] byArray) {
        this.dataStream.write(byArray, 0, byArray.length);
    }

    void writeChar(char c2) {
        this.dataStream.write((byte)(c2 >>> 8 & 0xFF));
        this.dataStream.write((byte)(c2 & 0xFF));
    }

    void writeClassID(int n2) {
        this.writeInt(n2);
    }

    void writeClassLoaderID(int n2) {
        this.writeObjectID(n2);
    }

    void writeDouble(double d2) {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    void writeFieldID(int n2) {
        this.writeInt(n2);
    }

    void writeFloat(float f2) {
        this.writeInt(Float.floatToIntBits(f2));
    }

    void writeFrameID(int n2) {
        this.writeInt(n2);
    }

    void writeInt(int n2) {
        this.dataStream.write((byte)(n2 >>> 24 & 0xFF));
        this.dataStream.write((byte)(n2 >>> 16 & 0xFF));
        this.dataStream.write((byte)(n2 >>> 8 & 0xFF));
        this.dataStream.write((byte)(n2 & 0xFF));
    }

    void writeLocation(XSLJDWPLocation xSLJDWPLocation) {
        this.writeByte(xSLJDWPLocation.getType());
        this.writeClassID(xSLJDWPLocation.getClassID());
        this.writeMethodID(xSLJDWPLocation.getMethodID());
        this.writeLong(xSLJDWPLocation.getIndex());
    }

    void writeLong(long l2) {
        this.dataStream.write((byte)(l2 >>> 56 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 48 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 40 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 32 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 24 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 16 & 0xFFL));
        this.dataStream.write((byte)(l2 >>> 8 & 0xFFL));
        this.dataStream.write((byte)(l2 & 0xFFL));
    }

    void writeMethodID(int n2) {
        this.writeInt(n2);
    }

    void writeNullObjectID() {
        this.writeObjectID(0);
    }

    void writeObjectID(int n2) {
        this.writeInt(n2);
    }

    void writeStringID(int n2) {
        this.writeInt(n2);
    }

    void writeReferenceTypeID(int n2) {
        this.writeObjectID(n2);
    }

    void writeShort(short s2) {
        this.dataStream.write((byte)(s2 >>> 8 & 0xFF));
        this.dataStream.write((byte)(s2 & 0xFF));
    }

    void writeString(String string) throws XSLJDWPException {
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.writeInt(byArray.length);
            this.writeByteArray(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XSLJDWPException(unsupportedEncodingException, 113);
        }
    }

    void writeTaggedObjectID(long l2) {
        this.writeLong(l2);
    }

    void writeThreadID(int n2) {
        this.writeObjectID(n2);
    }

    void writeThreadGroupID(int n2) {
        this.writeObjectID(n2);
    }

    void writeUntaggedValue(XSLJDWPPacketValue xSLJDWPPacketValue) throws XSLJDWPException {
        byte by = xSLJDWPPacketValue.getType();
        Object object = xSLJDWPPacketValue.getValue();
        if (!XSLJDWPPacketStream.isObjectTag(by)) {
            switch (by) {
                case 66: {
                    if (!(object instanceof Byte)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeByte((Byte)object);
                    break;
                }
                case 90: {
                    if (!(object instanceof Boolean)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeBoolean((Boolean)object);
                    break;
                }
                case 67: {
                    if (!(object instanceof Character)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeChar(((Character)object).charValue());
                    break;
                }
                case 70: {
                    if (!(object instanceof Float)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeFloat(((Float)object).floatValue());
                    break;
                }
                case 68: {
                    if (!(object instanceof Double)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeDouble((Double)object);
                    break;
                }
                case 73: {
                    if (!(object instanceof Integer)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeInt((Integer)object);
                    break;
                }
                case 74: {
                    if (!(object instanceof Long)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeLong((Long)object);
                    break;
                }
                case 83: {
                    if (!(object instanceof Short)) {
                        throw new XSLJDWPException("Invalid Tag/Type pair", 113);
                    }
                    this.writeShort((Short)object);
                }
            }
        } else if (object == null) {
            this.writeObjectID(0);
        } else {
            if (!(object instanceof Integer)) {
                throw new XSLJDWPException("Invalid Tag/Type pair", 113);
            }
            this.writeObjectID((Integer)object);
        }
    }

    void writeValue(XSLJDWPPacketValue xSLJDWPPacketValue) throws XSLJDWPException {
        this.writeByte(xSLJDWPPacketValue.getType());
        this.writeUntaggedValue(xSLJDWPPacketValue);
    }
}

